/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import oracle.bali.share.nls.StringUtils;
import oracle.help.common.Target;
import oracle.help.common.Topic;
import oracle.help.common.navigator.searchNavigator.SearchModel;
import oracle.help.common.navigator.searchNavigator.SearchModelData;
import oracle.help.navigator.searchNavigator.OHJSearchModelData;
import oracle.ide.IdeConstants;
import oracle.ide.controls.ArrowIcon;
import oracle.ide.controls.RotatingIcon;
import oracle.ide.editor.Editor;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.SwingWorker;
import oracle.javatools.border.JavatoolsBorderFactory;
import oracle.javatools.controls.HyperlinkButton;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchProgress;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.Themes;
import oracle.javatools.util.ModelUtil;
import oracle.jdevimpl.help.HelpArb;
import oracle.jdevimpl.help.HelpCenterWindow;
import oracle.jdevimpl.help.HelpUtils;
import oracle.jdevimpl.help.MultipleTypeTopic;
import oracle.jdevimpl.help.SearchWorker;
import oracle.jdevimpl.help.UserQuery;

class SearchResultsEditor
extends Editor {
    private JPanel _mainPanel;
    private SearchModel _searchModel;
    private SwingWorker _swingWorker;
    private SearchModel _otnSearchModel;
    private String _otnErrorText;
    private SearchModel _tahitiSearchModel;
    private String _tahitiErrorText;
    private JSplitPane _mainSplitPane;
    private JSplitPane _bottomSplitPane;
    private SearchResultSection _localResultSection;
    private List<SearchResultSection> _sections;
    private static final int ROWS_TO_DISPLAY = 15;
    private static final int MAX_PAGES_IN_CONTROL = 10;

    private void $init$() {
        this._mainPanel = new JPanel();
        this._sections = new ArrayList<SearchResultSection>(3);
    }

    public SearchResultsEditor(String searchText, SearchModel searchModel) {
        this.$init$();
        this._searchModel = searchModel;
        this._mainPanel.setLayout(new BorderLayout());
    }

    void stopSearch() {
        if (this._swingWorker != null) {
            this._swingWorker.interrupt();
        }
    }

    void startSearch(SearchEvent se) {
        SearchProgress searchProgress = se.getSearchProgress();
        String searchText = se.getSearchText().trim();
        if (searchText != null && searchText.length() > 0) {
            UserQuery query = new UserQuery(searchText);
            this._swingWorker = new 1(this, query, searchProgress);
            this._swingWorker.start();
        }
    }

    private void createNeededSplitPanes() {
        if (this._sections.size() == 1) {
            return;
        }
        this._mainSplitPane = new JSplitPane(0);
        HelpCenterWindow.setupSplitPaneDivider(this._mainSplitPane);
        this._mainSplitPane.setResizeWeight(0.5);
        this._mainPanel.add((Component)this._mainSplitPane, "Center");
        if (this._sections.size() == 3) {
            this._bottomSplitPane = new JSplitPane(0);
            HelpCenterWindow.setupSplitPaneDivider(this._bottomSplitPane);
            this._bottomSplitPane.setResizeWeight(0.5);
            this._mainSplitPane.setBottomComponent(this._bottomSplitPane);
        }
    }

    private void addSearchResultSections() {
        int numSections = this._sections.size();
        if (numSections == 1) {
            this._mainPanel.add((Component)this._sections.get(0), "Center");
        } else if (numSections == 2) {
            this._mainSplitPane.add(this._sections.get(0));
            this._mainSplitPane.add(this._sections.get(1));
        } else {
            this._mainSplitPane.add(this._sections.get(0));
            this._bottomSplitPane.add(this._sections.get(1));
            this._bottomSplitPane.add(this._sections.get(2));
        }
        for (SearchResultSection section : this._sections) {
            if (section.getSearchModel().getSearchModelData().getRowCount() != 0) continue;
            this.resetSizeAllocation(section, false);
        }
    }

    private int getSectionPosition(SearchResultSection section) {
        int position = 0;
        int i = 0;
        while (i < this._sections.size()) {
            if (this._sections.get(i) == section) {
                position = i;
                break;
            }
            ++i;
        }
        return position;
    }

    private void resetSizeAllocation(SearchResultSection section, boolean maximized) {
        if (this._sections.size() == 1) {
            this._mainPanel.revalidate();
        } else {
            int sectionPosition = this.getSectionPosition(section);
            if (this._sections.size() == 2) {
                if (maximized) {
                    if (sectionPosition == 0) {
                        if (this._sections.get(1).isExpanded()) {
                            this._mainSplitPane.setDividerLocation(this._mainSplitPane.getHeight() / 2);
                            this._mainSplitPane.setResizeWeight(0.5);
                        } else {
                            this._mainSplitPane.setDividerLocation(this._mainSplitPane.getHeight() - this._sections.get((int)1).getPreferredSize().height - 2);
                            this._mainSplitPane.setResizeWeight(1.0);
                        }
                    } else if (this._sections.get(0).isExpanded()) {
                        this._mainSplitPane.setDividerLocation(this._mainSplitPane.getHeight() / 2);
                        this._mainSplitPane.setResizeWeight(0.5);
                    } else {
                        this._mainSplitPane.setDividerLocation(this._sections.get((int)0).getPreferredSize().height + 2);
                        this._mainSplitPane.setResizeWeight(0.0);
                    }
                } else {
                    int newHeight = section.getPreferredSize().height;
                    if (sectionPosition == 0) {
                        if (this._sections.get(1).isExpanded()) {
                            this._mainSplitPane.setDividerLocation(newHeight + 2);
                            this._mainSplitPane.setResizeWeight(0.0);
                        } else {
                            this._mainSplitPane.setDividerLocation(newHeight + 2);
                            this._mainSplitPane.setResizeWeight(0.0);
                        }
                    } else if (this._sections.get(0).isExpanded()) {
                        this._mainSplitPane.setDividerLocation(this._mainSplitPane.getHeight() - newHeight + 2);
                        this._mainSplitPane.setResizeWeight(1.0);
                    } else {
                        this._mainSplitPane.setDividerLocation(newHeight + 2);
                        this._mainSplitPane.setResizeWeight(0.0);
                    }
                }
            } else if (sectionPosition == 0) {
                if (maximized) {
                    if (this._sections.get(1).isExpanded() && this._sections.get(2).isExpanded()) {
                        int desiredSize = this._mainSplitPane.getHeight() / 3;
                        this._mainSplitPane.setDividerLocation(desiredSize);
                        this._bottomSplitPane.setDividerLocation(desiredSize);
                        this._mainSplitPane.setResizeWeight(0.5);
                    } else if (!this._sections.get(1).isExpanded() && !this._sections.get(2).isExpanded()) {
                        int newHeight = this._sections.get((int)1).getPreferredSize().height * 2;
                        this._mainSplitPane.setDividerLocation(this._mainSplitPane.getHeight() - newHeight + 2);
                        this._mainSplitPane.setResizeWeight(1.0);
                    } else {
                        this._mainSplitPane.setDividerLocation(0.5);
                        this._mainSplitPane.setResizeWeight(0.5);
                    }
                } else if (this._sections.get(1).isExpanded()) {
                    this._mainSplitPane.setDividerLocation(section.getPreferredSize().height + 2);
                    this._mainSplitPane.setResizeWeight(0.0);
                } else if (this._sections.get(2).isExpanded()) {
                    this._mainSplitPane.setDividerLocation(section.getPreferredSize().height + 2);
                    this._bottomSplitPane.setDividerLocation(this._sections.get((int)1).getPreferredSize().height + 2);
                    this._mainSplitPane.setResizeWeight(0.0);
                } else {
                    this._mainSplitPane.setDividerLocation(section.getPreferredSize().height + 2);
                    this._bottomSplitPane.setResizeWeight(0.0);
                }
            } else if (sectionPosition == 1) {
                if (maximized) {
                    if (this._sections.get(0).isExpanded() && this._sections.get(2).isExpanded()) {
                        this._bottomSplitPane.setDividerLocation(0.5);
                        this._bottomSplitPane.setResizeWeight(0.5);
                        this._mainSplitPane.setResizeWeight(0.5);
                    } else if (!this._sections.get(0).isExpanded() && this._sections.get(2).isExpanded()) {
                        this._bottomSplitPane.setDividerLocation(0.5);
                        this._bottomSplitPane.setResizeWeight(0.5);
                    } else if (this._sections.get(0).isExpanded() && !this._sections.get(2).isExpanded()) {
                        this._mainSplitPane.setDividerLocation(0.5);
                        this._bottomSplitPane.setDividerLocation(this._bottomSplitPane.getHeight() - this._sections.get((int)2).getPreferredSize().height - 2);
                        this._bottomSplitPane.setResizeWeight(1.0);
                        this._mainSplitPane.setResizeWeight(0.5);
                    } else {
                        this._bottomSplitPane.setDividerLocation(this._bottomSplitPane.getHeight() - this._sections.get((int)2).getPreferredSize().height - 2);
                        this._bottomSplitPane.setResizeWeight(1.0);
                        this._mainSplitPane.setResizeWeight(0.0);
                    }
                } else if (this._sections.get(0).isExpanded() && this._sections.get(2).isExpanded()) {
                    this._bottomSplitPane.setDividerLocation(section.getPreferredSize().height + 2);
                    this._bottomSplitPane.setResizeWeight(0.0);
                    this._mainSplitPane.setResizeWeight(0.5);
                } else if (!this._sections.get(0).isExpanded() && this._sections.get(2).isExpanded()) {
                    this._bottomSplitPane.setDividerLocation(section.getPreferredSize().height + 2);
                    this._mainSplitPane.setResizeWeight(0.0);
                    this._bottomSplitPane.setResizeWeight(0.0);
                } else if (this._sections.get(0).isExpanded() && !this._sections.get(2).isExpanded()) {
                    this._mainSplitPane.setDividerLocation(this._mainSplitPane.getHeight() - section.getPreferredSize().height * 2);
                    this._bottomSplitPane.setDividerLocation(0.5);
                    this._mainSplitPane.setResizeWeight(1.0);
                    this._bottomSplitPane.setResizeWeight(0.5);
                } else {
                    this._mainSplitPane.setDividerLocation(this._sections.get((int)0).getPreferredSize().height + 2);
                    this._bottomSplitPane.setDividerLocation(this._sections.get((int)1).getPreferredSize().height + 2);
                    this._mainSplitPane.setResizeWeight(0.0);
                    this._bottomSplitPane.setResizeWeight(0.0);
                }
            } else if (maximized) {
                if (this._sections.get(1).isExpanded()) {
                    this._bottomSplitPane.setDividerLocation(0.5);
                    this._bottomSplitPane.setResizeWeight(0.5);
                } else if (this._sections.get(0).isExpanded()) {
                    this._mainSplitPane.setDividerLocation(0.5);
                    this._bottomSplitPane.setDividerLocation(this._sections.get((int)1).getPreferredSize().height + 2);
                    this._bottomSplitPane.setResizeWeight(0.0);
                } else {
                    this._mainSplitPane.setDividerLocation(this._sections.get((int)0).getPreferredSize().height + 2);
                    this._mainSplitPane.setResizeWeight(0.0);
                    this._bottomSplitPane.setDividerLocation(this._sections.get((int)1).getPreferredSize().height + 2);
                    this._bottomSplitPane.setResizeWeight(0.0);
                }
            } else if (this._sections.get(1).isExpanded()) {
                this._bottomSplitPane.setDividerLocation(this._bottomSplitPane.getHeight() - section.getPreferredSize().height - 2);
                this._bottomSplitPane.setResizeWeight(1.0);
            } else if (this._sections.get(0).isExpanded()) {
                this._mainSplitPane.setDividerLocation(this._mainSplitPane.getHeight() - section.getPreferredSize().height * 2);
                this._bottomSplitPane.setDividerLocation(0.5);
                this._mainSplitPane.setResizeWeight(1.0);
                this._bottomSplitPane.setResizeWeight(0.5);
            } else {
                this._mainSplitPane.setDividerLocation(section.getPreferredSize().height + 2);
                this._bottomSplitPane.setDividerLocation(section.getPreferredSize().height + 2);
                this._mainSplitPane.setResizeWeight(0.0);
                this._bottomSplitPane.setResizeWeight(0.0);
            }
        }
    }

    private static boolean hasData(SearchModel searchModel) {
        SearchModelData data;
        boolean retval = false;
        if (searchModel != null && (data = searchModel.getSearchModelData()) != null) {
            retval = data.getRowCount() > 0;
        }
        return retval;
    }

    private static boolean isMouseWithinHyperlink(JTable table, Point p) {
        int row = table.rowAtPoint(p);
        if (row != -1) {
            Rectangle hitRect;
            TableCellRenderer renderer = table.getCellRenderer(row, 0);
            Component comp = renderer.getTableCellRendererComponent(table, table.getModel().getValueAt(row, 0), true, true, row, 0);
            Rectangle cellRect = table.getCellRect(row, 0, true);
            Rectangle linkRect = null;
            if (comp instanceof JPanel) {
                Component[] comps;
                JPanel panel = (JPanel)comp;
                Component[] componentArray = comps = panel.getComponents();
                int n = 0;
                while (n < componentArray.length) {
                    Component c = componentArray[n];
                    if (c instanceof HyperlinkButton) {
                        linkRect = c.getBounds();
                        break;
                    }
                    ++n;
                }
            }
            return (hitRect = new Rectangle(cellRect.x, cellRect.y, linkRect.width + linkRect.x, linkRect.height)).contains(p);
        }
        return false;
    }

    private void invokeTopic(SearchResultsTopicWrapper topicWrapper) {
        try {
            try {
                HelpCenterWindow.getInstance().getWindow().setCursor(Cursor.getPredefinedCursor(3));
                HelpUtils.createHelpTopicEditor(topicWrapper.getTopic().getTarget().getURL().toString());
                HelpCenterWindow hcw = HelpCenterWindow.getInstance();
                hcw.setVisible(true);
                HelpCenterWindow.getGUI().requestFocus();
            }
            catch (MalformedURLException malformedURLException) {}
        }
        finally {
            HelpCenterWindow.getInstance().getWindow().setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void open() {
    }

    public Component getGUI() {
        return this._mainPanel;
    }

    public void update(Object observed, UpdateMessage change) {
    }

    static void mav$invokeTopic(SearchResultsEditor searchResultsEditor, SearchResultsTopicWrapper searchResultsTopicWrapper) {
        searchResultsEditor.invokeTopic(searchResultsTopicWrapper);
    }

    static void mav$resetSizeAllocation(SearchResultsEditor searchResultsEditor, SearchResultSection searchResultSection, boolean bl) {
        searchResultsEditor.resetSizeAllocation(searchResultSection, bl);
    }

    static boolean maS$hasData(SearchModel searchModel) {
        return SearchResultsEditor.hasData(searchModel);
    }

    static void wa$_swingWorker(SearchResultsEditor searchResultsEditor, SwingWorker swingWorker) {
        searchResultsEditor._swingWorker = swingWorker;
    }

    static SearchModel ra$_searchModel(SearchResultsEditor searchResultsEditor) {
        return searchResultsEditor._searchModel;
    }

    static void wa$_localResultSection(SearchResultsEditor searchResultsEditor, SearchResultSection searchResultSection) {
        searchResultsEditor._localResultSection = searchResultSection;
    }

    static SearchResultSection ra$_localResultSection(SearchResultsEditor searchResultsEditor) {
        return searchResultsEditor._localResultSection;
    }

    static List ra$_sections(SearchResultsEditor searchResultsEditor) {
        return searchResultsEditor._sections;
    }

    static SearchModel ra$_otnSearchModel(SearchResultsEditor searchResultsEditor) {
        return searchResultsEditor._otnSearchModel;
    }

    static String ra$_otnErrorText(SearchResultsEditor searchResultsEditor) {
        return searchResultsEditor._otnErrorText;
    }

    static SearchModel ra$_tahitiSearchModel(SearchResultsEditor searchResultsEditor) {
        return searchResultsEditor._tahitiSearchModel;
    }

    static String ra$_tahitiErrorText(SearchResultsEditor searchResultsEditor) {
        return searchResultsEditor._tahitiErrorText;
    }

    static void mav$createNeededSplitPanes(SearchResultsEditor searchResultsEditor) {
        searchResultsEditor.createNeededSplitPanes();
    }

    static void mav$addSearchResultSections(SearchResultsEditor searchResultsEditor) {
        searchResultsEditor.addSearchResultSections();
    }

    static void wa$_searchModel(SearchResultsEditor searchResultsEditor, SearchModel searchModel) {
        searchResultsEditor._searchModel = searchModel;
    }

    static void wa$_otnSearchModel(SearchResultsEditor searchResultsEditor, SearchModel searchModel) {
        searchResultsEditor._otnSearchModel = searchModel;
    }

    static void wa$_otnErrorText(SearchResultsEditor searchResultsEditor, String string) {
        searchResultsEditor._otnErrorText = string;
    }

    static void wa$_tahitiSearchModel(SearchResultsEditor searchResultsEditor, SearchModel searchModel) {
        searchResultsEditor._tahitiSearchModel = searchModel;
    }

    static void wa$_tahitiErrorText(SearchResultsEditor searchResultsEditor, String string) {
        searchResultsEditor._tahitiErrorText = string;
    }

    static boolean maS$isMouseWithinHyperlink(JTable jTable, Point point) {
        return SearchResultsEditor.isMouseWithinHyperlink(jTable, point);
    }

    final class 1
    extends SwingWorker {
        final List<SearchWorker> searchWorkers;
        boolean interrupted;
        private final /* synthetic */ UserQuery v$query;
        private final /* synthetic */ SearchProgress v$searchProgress;
        final /* synthetic */ SearchResultsEditor this$0;

        private void $init$() {
            this.searchWorkers = new ArrayList<SearchWorker>();
            this.interrupted = false;
        }

        /*
         * Unable to fully structure code
         */
        public Object construct() {
            if (this.v$query.includeLocal()) {
                searchWorker = new SearchWorker(this.v$query, null, null, SearchWorker.WorkerType.LOCAL);
                this.searchWorkers.add(searchWorker);
                searchWorker.startSearch();
            }
            if (this.v$query.includeOTN()) {
                searchWorker = new SearchWorker(this.v$query, null, null, SearchWorker.WorkerType.OTN);
                this.searchWorkers.add(searchWorker);
                searchWorker.startSearch();
            }
            if (this.v$query.includeTahiti()) {
                searchWorker = new SearchWorker(this.v$query, null, null, SearchWorker.WorkerType.TAHITI);
                this.searchWorkers.add(searchWorker);
                searchWorker.startSearch();
            }
            while (this.stillWorking() && !this.v$searchProgress.isStopped()) {
                try {
                    Thread.sleep(100);
                    continue;
                }
                catch (InterruptedException interuptEx) {
                    this.interrupted = true;
                    ** for (worker : this.searchWorkers)
                }
lbl-1000:
                // 1 sources

                {
                    worker.stopSearch();
                    continue;
                }
lbl25:
                // 1 sources

                var7_7 = "Done";
                return var7_7;
            }
            return "Done";
        }

        private boolean stillWorking() {
            boolean stillWorking = false;
            for (SearchWorker worker : this.searchWorkers) {
                if (worker.searchDone()) continue;
                stillWorking = true;
                break;
            }
            return stillWorking;
        }

        private void assignSearchModels() {
            for (SearchWorker worker : this.searchWorkers) {
                if (worker.getWorkerType() == SearchWorker.WorkerType.LOCAL) {
                    SearchResultsEditor.wa$_searchModel(this.this$0, worker.getSearchModel());
                    continue;
                }
                if (worker.getWorkerType() == SearchWorker.WorkerType.OTN) {
                    SearchResultsEditor.wa$_otnSearchModel(this.this$0, worker.getSearchModel());
                    SearchResultsEditor.wa$_otnErrorText(this.this$0, worker.getErrorText());
                    continue;
                }
                if (worker.getWorkerType() != SearchWorker.WorkerType.TAHITI) continue;
                SearchResultsEditor.wa$_tahitiSearchModel(this.this$0, worker.getSearchModel());
                SearchResultsEditor.wa$_tahitiErrorText(this.this$0, worker.getErrorText());
            }
        }

        public void finished() {
            if (this.interrupted) {
                SearchResultsEditor.wa$_swingWorker(this.this$0, null);
                this.v$searchProgress.finish();
                return;
            }
            this.assignSearchModels();
            SearchResultsEditor.wa$_swingWorker(this.this$0, null);
            if (this.v$searchProgress.isStopped()) {
                SearchResultsEditor.wa$_swingWorker(this.this$0, null);
                this.v$searchProgress.finish();
                return;
            }
            if (this.v$query.includeLocal()) {
                SearchResultsEditor.wa$_localResultSection(this.this$0, this.this$0.new SearchResultSection(StringUtils.stripMnemonic((String)HelpArb.getString(89)), SearchResultsEditor.ra$_searchModel(this.this$0)));
                if (SearchResultsEditor.maS$hasData(SearchResultsEditor.ra$_searchModel(this.this$0))) {
                    SearchResultSection.mav$copyDisplayRowSetData(SearchResultsEditor.ra$_localResultSection(this.this$0), 0);
                }
                SearchResultsEditor.ra$_sections(this.this$0).add(SearchResultsEditor.ra$_localResultSection(this.this$0));
            }
            if (this.v$query.includeOTN()) {
                SearchResultSection otnSearchResultsPanel = this.this$0.new SearchResultSection(StringUtils.stripMnemonic((String)HelpArb.getString(35)), SearchResultsEditor.ra$_otnSearchModel(this.this$0));
                if (SearchResultsEditor.maS$hasData(SearchResultsEditor.ra$_otnSearchModel(this.this$0))) {
                    SearchResultSection.mav$copyDisplayRowSetData(otnSearchResultsPanel, 0);
                }
                if (ModelUtil.hasLength((String)SearchResultsEditor.ra$_otnErrorText(this.this$0))) {
                    otnSearchResultsPanel.setError(SearchResultsEditor.ra$_otnErrorText(this.this$0));
                }
                SearchResultsEditor.ra$_sections(this.this$0).add(otnSearchResultsPanel);
            }
            if (this.v$query.includeTahiti()) {
                SearchResultSection tahitiSearchResultsPanel = this.this$0.new SearchResultSection(StringUtils.stripMnemonic((String)HelpArb.getString(0)), SearchResultsEditor.ra$_tahitiSearchModel(this.this$0));
                if (SearchResultsEditor.maS$hasData(SearchResultsEditor.ra$_tahitiSearchModel(this.this$0))) {
                    SearchResultSection.mav$copyDisplayRowSetData(tahitiSearchResultsPanel, 0);
                }
                if (ModelUtil.hasLength((String)SearchResultsEditor.ra$_tahitiErrorText(this.this$0))) {
                    tahitiSearchResultsPanel.setError(SearchResultsEditor.ra$_tahitiErrorText(this.this$0));
                }
                SearchResultsEditor.ra$_sections(this.this$0).add(tahitiSearchResultsPanel);
            }
            SearchResultsEditor.mav$createNeededSplitPanes(this.this$0);
            SearchResultsEditor.mav$addSearchResultSections(this.this$0);
            this.v$searchProgress.finish();
        }

        public 1(SearchResultsEditor searchResultsEditor, UserQuery userQuery, SearchProgress searchProgress) {
            this.v$searchProgress = searchProgress;
            this.v$query = userQuery;
            this.this$0 = searchResultsEditor;
            this.$init$();
        }
    }

    private class SearchResultsLabel
    extends JLabel {
        private int _total;
        private String _searchArea;

        public SearchResultsLabel(String searchArea) {
            super(searchArea + "  " + HelpArb.getString(51), (Icon)new RotatingIcon(OracleIcons.getIcon((String)"extras/accordion_open.png")), 10);
            super.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            this._searchArea = searchArea;
        }

        public void setTotal(int total) {
            this._total = total;
        }

        public void updateResultsLabel(int begin, int end) {
            this.setText(HelpArb.format(85, new Object[]{this._searchArea, begin, end, this._total}));
        }
    }

    private final class ResultTableCellRenderer
    extends JPanel
    implements TableCellRenderer {
        private final Color selectionHighlightColor;
        private final Border paddedItemBorder;
        private final Border descriptionBorder;
        private static final String FONT_DECLARATION = "<body style=\"font-family:Tahoma;font-size:11;";
        private static final String REGULAR_TEXT = "color:#666666\">";
        private static final String FOCUSED_TEXT = "color:#000000\">";
        private HyperlinkButton header;
        private JPanel spacerPanel;
        private JTextPane description;
        private GridBagConstraints constraints;
        private boolean showAllDescriptions;

        private void $init$() {
            this.selectionHighlightColor = new Color(216, 236, 253);
            this.paddedItemBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
            this.descriptionBorder = BorderFactory.createEmptyBorder(0, 20, 0, 5);
        }

        ResultTableCellRenderer(boolean showDescriptions) {
            this.$init$();
            this.showAllDescriptions = showDescriptions;
            this.header = new HyperlinkButton();
            this.header.setForeground(new Color(0, 48, 144));
            this.description = new JTextPane();
            this.description.setEditorKit(new HTMLEditorKit());
            this.description.setBorder(this.descriptionBorder);
            this.description.setEditable(false);
            this.description.setOpaque(false);
            this.setLayout(new GridBagLayout());
            this.constraints = new GridBagConstraints();
            this.constraints.gridx = 0;
            this.constraints.insets = new Insets(0, 0, 0, 5);
            this.constraints.weightx = 0.0;
            this.constraints.fill = 2;
            this.add((Component)this.header, this.constraints);
            this.spacerPanel = new JPanel();
            this.spacerPanel.setOpaque(false);
            this.constraints.gridx = 1;
            this.constraints.weightx = 1.0;
            this.add((Component)this.spacerPanel, this.constraints);
            this.constraints.gridx = 0;
            this.constraints.gridwidth = 2;
            this.constraints.gridheight = 2;
            this.constraints.weighty = 1.0;
            this.constraints.fill = 1;
            this.add((Component)this.description, this.constraints);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            SearchResultsTopicWrapper topicWrapper;
            if (value != null && (topicWrapper = (SearchResultsTopicWrapper)value) != null) {
                Topic topic = topicWrapper.getTopic();
                Icon icon = HelpUtils.getIconForTopic(topic);
                this.header.setIcon(icon);
                this.header.setText(topic.getLabel());
                this.header.setEnabled(true);
                if (isSelected || this.showAllDescriptions) {
                    this.add((Component)this.description, this.constraints);
                    StringBuffer sb = new StringBuffer();
                    sb.append(FONT_DECLARATION);
                    sb.append(hasFocus ? FOCUSED_TEXT : REGULAR_TEXT);
                    sb.append(topicWrapper.getDescription()).append("</body>");
                    this.description.setText(sb.toString());
                    this.description.setEnabled(true);
                } else {
                    this.remove(this.description);
                    this.description.setText(null);
                }
                this.setBorder(this.paddedItemBorder);
                this.setBackground(isSelected ? this.selectionHighlightColor : SystemColor.WHITE);
                int prefHeight = this.getPreferredSize().height;
                if (prefHeight != table.getRowHeight(row)) {
                    table.setRowHeight(row, prefHeight);
                }
            }
            return this;
        }
    }

    private static final class MyTableModel
    extends DefaultTableModel {
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        private MyTableModel() {
        }

        MyTableModel(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private class PressAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            JTable table = (JTable)e.getSource();
            int row = table.getSelectedRow();
            SearchResultsTopicWrapper topicWrapper = (SearchResultsTopicWrapper)table.getModel().getValueAt(row, 0);
            SearchResultsEditor.mav$invokeTopic(SearchResultsEditor.this, topicWrapper);
        }

        private PressAction() {
        }

        PressAction(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static class SearchResultsTopicWrapper {
        private Topic _topic;
        private String _description;
        private String _location;
        private static int MAX_DESCRIPTION_LEN = 100;

        public SearchResultsTopicWrapper(Topic topic) {
            this._topic = topic;
        }

        public SearchResultsTopicWrapper(Topic topic, String location) {
            this._topic = topic;
            this._location = location;
        }

        public Topic getTopic() {
            return this._topic;
        }

        public String getLocation() {
            return this._location;
        }

        public String getDescription() {
            if (this._description == null) {
                this._description = this.getDescription(this._topic);
            }
            return this._description;
        }

        private String getDescription(Topic topic) {
            String retval = null;
            if (topic instanceof MultipleTypeTopic) {
                retval = ((MultipleTypeTopic)topic).getDescription();
            }
            if (!ModelUtil.hasLength(retval)) {
                if (ModelUtil.hasLength((String)this._location)) {
                    retval = "<i>" + this._location + "</i><br>";
                }
                Target target = topic.getTarget();
                try {
                    URL url = target.getURL();
                    String textFromHTML = HelpUtils.getTagFromHTML(url, HTML.Tag.P, true, MAX_DESCRIPTION_LEN);
                    if (ModelUtil.hasLength((String)textFromHTML)) {
                        retval = retval + textFromHTML;
                    }
                }
                catch (MalformedURLException muex) {
                    // empty catch block
                }
            }
            return retval;
        }
    }

    private class SearchResultSection
    extends JPanel {
        private SearchModel _searchModel;
        private JTable _resultsTable;
        private SearchResultsLabel _resultsLabel;
        private int _resultCount;
        private PageControl _pageControl;
        private JScrollPane _scrollPane;
        private boolean _expanded;
        private boolean _expandable;
        private JPanel _pageControlPanel;
        private FakeAccordionPanel _header;

        public SearchResultSection(String searchArea, SearchModel searchModel) {
            this._searchModel = searchModel;
            this.setLayout(new BorderLayout());
            this.setBackground(SystemColor.WHITE);
            this.setBorder(new EmptyBorder(0, 0, 0, 0));
            this._resultsLabel = new SearchResultsLabel(searchArea);
            this._header = new FakeAccordionPanel(null);
            this._header.setLayout(new BorderLayout());
            this._header.add((Component)this._resultsLabel, "Center");
            this._expandable = this._expanded = SearchResultsEditor.maS$hasData(searchModel);
            this.setIconExpanded(this._expanded);
            this.add((Component)this._header, "North");
            this._resultsLabel.addMouseListener(new 1());
            if (SearchResultsEditor.maS$hasData(searchModel)) {
                this._resultsTable = new JTable();
                this._resultsTable.setBorder(BorderFactory.createEmptyBorder());
                this._resultsTable.setShowGrid(false);
                this._resultsTable.setAutoscrolls(true);
                this._resultsTable.setOpaque(true);
                this._resultsTable.setBackground(Color.WHITE);
                this._resultsTable.setTableHeader(null);
                this._resultsTable.setColumnSelectionAllowed(false);
                this._resultsTable.setSurrendersFocusOnKeystroke(true);
                this._resultsTable.setSelectionMode(0);
                this._resultsTable.addMouseListener(new 2());
                this._resultsTable.addMouseMotionListener(new 3());
                this._resultsTable.getInputMap().put(KeyStroke.getKeyStroke("SPACE"), "pressed");
                this._resultsTable.getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "pressed");
                this._resultsTable.getActionMap().put("pressed", new PressAction(null));
                this._scrollPane = new JScrollPane(this._resultsTable);
                this._scrollPane.setBorder(JavatoolsBorderFactory.createTopBottomBorder((Color)IdeConstants.COLOR_IDE_LINES, (int)1));
                this.add((Component)this._scrollPane, "Center");
            }
            this._resultCount = this.getRowCountFromSearchModel();
            this._pageControl = new PageControl(this._resultCount);
            this._pageControl.setOpaque(true);
            this._pageControlPanel = new JPanel(new BorderLayout());
            this._pageControlPanel.setOpaque(true);
            this._pageControlPanel.add((Component)this._pageControl, "Center");
            this.add((Component)this._pageControlPanel, "South");
        }

        private void toggleState() {
            if (this._expandable) {
                this._expanded ^= true;
                if (this._expanded) {
                    this._header.setExpanded(true);
                    this.add((Component)this._scrollPane, "Center");
                    this.add((Component)this._pageControlPanel, "South");
                } else {
                    this._header.setExpanded(false);
                    this.remove(this._scrollPane);
                    this.remove(this._pageControlPanel);
                }
                this.setIconExpanded(this._expanded);
                this._header.repaint();
                this.revalidate();
                SearchResultsEditor.mav$resetSizeAllocation(SearchResultsEditor.this, this, this._expanded);
            }
        }

        public SearchModel getSearchModel() {
            return this._searchModel;
        }

        public boolean isExpanded() {
            return this._expanded;
        }

        public void setError(String errorText) {
            JButton errorBtn = new JButton();
            errorBtn.setBorderPainted(false);
            errorBtn.setIcon(OracleIcons.getIcon((String)"exception.png"));
            errorBtn.setToolTipText(errorText);
            errorBtn.setOpaque(false);
            this._header.add((Component)errorBtn, "East");
        }

        private void setIconExpanded(boolean expanded) {
            double ratio = expanded ? 1.0 : 0.0;
            RotatingIcon rotatingIcon = (RotatingIcon)this._resultsLabel.getIcon();
            rotatingIcon.setRotation(Math.PI * ratio / 2.0);
        }

        private int getRowCountFromSearchModel() {
            int rowCount = ((OHJSearchModelData)this._searchModel.getSearchModelData()).getRowCount();
            return rowCount;
        }

        private DefaultTableModel createTableModel() {
            MyTableModel tableModel = new MyTableModel(null);
            tableModel.addColumn("text");
            return tableModel;
        }

        private TableColumnModel createTableColumnModel() {
            TableColumn tc = new TableColumn();
            tc.setCellRenderer(new ResultTableCellRenderer(true));
            DefaultTableColumnModel tcm = new DefaultTableColumnModel();
            tcm.addColumn(tc);
            return tcm;
        }

        private void copyDisplayRowSetData(int rowSet) {
            int firstRow;
            DefaultTableModel tableModel = this.createTableModel();
            int rowCount = this.getRowCountFromSearchModel();
            int endRow = firstRow = rowSet * 15;
            SearchModelData data = this._searchModel.getSearchModelData();
            int i = firstRow;
            while (i < firstRow + 15 && i < rowCount) {
                Topic topic = this._searchModel.getTopicForRow(i);
                String location = (String)data.getData(2, i);
                tableModel.addRow(new Object[]{new SearchResultsTopicWrapper(topic, location)});
                ++endRow;
                ++i;
            }
            this._resultsTable.setModel(tableModel);
            this._resultsTable.setColumnModel(this.createTableColumnModel());
            if (this._resultCount > 0) {
                this._resultsLabel.setTotal(this._resultCount);
                this._resultsLabel.updateResultsLabel(firstRow + 1, endRow);
            }
            String rowSetText = Integer.valueOf(rowSet + 1).toString();
            this._pageControl.selectButton(rowSetText);
        }

        static void mav$copyDisplayRowSetData(SearchResultSection searchResultSection, int n) {
            searchResultSection.copyDisplayRowSetData(n);
        }

        static void mav$toggleState(SearchResultSection searchResultSection) {
            searchResultSection.toggleState();
        }

        final class 1
        implements MouseListener {
            public void mouseClicked(MouseEvent e) {
                SearchResultSection.mav$toggleState(SearchResultSection.this);
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        }

        final class 2
        implements MouseListener {
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    this.pressRow(e);
                } else if (e.getClickCount() == 1 && SearchResultsEditor.maS$isMouseWithinHyperlink((JTable)e.getSource(), e.getPoint())) {
                    this.pressRow(e);
                }
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            private void pressRow(MouseEvent e) {
                JTable table = (JTable)e.getSource();
                int row = table.rowAtPoint(e.getPoint());
                SearchResultsTopicWrapper topicWrapper = (SearchResultsTopicWrapper)table.getModel().getValueAt(row, 0);
                SearchResultsEditor.mav$invokeTopic(SearchResultsEditor.this, topicWrapper);
            }
        }

        final class 3
        implements MouseMotionListener {
            public void mouseDragged(MouseEvent e) {
            }

            public void mouseMoved(MouseEvent e) {
                JTable table = (JTable)e.getSource();
                if (SearchResultsEditor.maS$isMouseWithinHyperlink(table, e.getPoint())) {
                    HelpCenterWindow.getInstance().getWindow().setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    HelpCenterWindow.getInstance().getWindow().setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }

        private final class PageControl
        extends JPanel {
            private PageActionListener _pageListener;
            private int _minPage;
            private int _maxPage;
            private int _totalPages;
            private List<JButton> _buttonList;
            private JButton _previousSetBtn;
            private JButton _nextSetBtn;
            private String _selectedButton;

            private void $init$() {
                this._pageListener = new PageActionListener(null);
                this._buttonList = new ArrayList<JButton>(10);
            }

            public PageControl(int rowCount) {
                this.$init$();
                this.setOpaque(true);
                this.setBorder(new EmptyBorder(0, 0, 0, 0));
                if (rowCount > 0 && rowCount <= 15) {
                    this._minPage = 1;
                    this._maxPage = 1;
                    this._totalPages = 1;
                } else if (rowCount > 15) {
                    this._totalPages = rowCount / 15;
                    int remainder = rowCount % 15;
                    if (remainder > 0) {
                        ++this._totalPages;
                    }
                }
                if (this._totalPages > 0) {
                    this.setLayout(new FlowLayout());
                    JLabel pageLabel = new JLabel(HelpArb.getString(55));
                    this.add(pageLabel);
                    int i = 0;
                    while (i < 10) {
                        JButton btn = new JButton();
                        btn.setBorder(new EmptyBorder(0, 0, 0, 0));
                        btn.setOpaque(false);
                        this.add(btn);
                        btn.addActionListener(this._pageListener);
                        this._buttonList.add(btn);
                        ++i;
                    }
                    this._previousSetBtn = new JButton();
                    this._previousSetBtn.setIcon((Icon)new ArrowIcon(6, 7));
                    this._previousSetBtn.setBorderPainted(false);
                    this._previousSetBtn.setBorder(new EmptyBorder(0, 0, 0, 0));
                    this.add(this._previousSetBtn);
                    this._previousSetBtn.addActionListener(this._pageListener);
                    this._nextSetBtn = new JButton();
                    this._nextSetBtn.setIcon((Icon)new ArrowIcon(6, 3));
                    this._nextSetBtn.setBorderPainted(false);
                    this._nextSetBtn.setBorder(new EmptyBorder(0, 0, 0, 0));
                    this.add(this._nextSetBtn);
                    this._nextSetBtn.addActionListener(this._pageListener);
                    this.handlePageButtons(1);
                }
            }

            public void handlePageButtons(int startPageNum) {
                int numButtonsToAdd = 0;
                numButtonsToAdd = this._totalPages <= 10 ? this._totalPages : Math.min(this._totalPages - startPageNum + 1, 10);
                this._minPage = startPageNum;
                this._maxPage = startPageNum - 1;
                int i = 0;
                while (i < 10) {
                    JButton btn = this._buttonList.get(i);
                    if (i < numButtonsToAdd) {
                        if (btn.getFont().isBold()) {
                            btn.setFont(btn.getFont().deriveFont(0));
                        }
                        btn.setText(Integer.toString(startPageNum + i));
                        if (btn.getText().equals(this._selectedButton)) {
                            btn.setFont(btn.getFont().deriveFont(1));
                        }
                        ++this._maxPage;
                        btn.setVisible(true);
                    } else {
                        btn.setVisible(false);
                    }
                    ++i;
                }
                this._previousSetBtn.setVisible(startPageNum > 1);
                this._nextSetBtn.setVisible(this._totalPages > this._maxPage);
            }

            public void selectButton(String text) {
                Component[] comps = this.getComponents();
                if (comps != null) {
                    Component[] componentArray = comps;
                    int n = 0;
                    while (n < componentArray.length) {
                        Component c = componentArray[n];
                        JButton btn = null;
                        if (c instanceof JButton) {
                            btn = (JButton)c;
                            Font font = btn.getFont();
                            if (btn.getText().equals(text)) {
                                btn.setFont(font.deriveFont(1));
                                this._selectedButton = text;
                            } else {
                                btn.setFont(font.deriveFont(0));
                            }
                        }
                        ++n;
                    }
                }
            }

            static JButton ra$_previousSetBtn(PageControl pageControl) {
                return pageControl._previousSetBtn;
            }

            static int ra$_minPage(PageControl pageControl) {
                return pageControl._minPage;
            }

            static JButton ra$_nextSetBtn(PageControl pageControl) {
                return pageControl._nextSetBtn;
            }

            static int ra$_maxPage(PageControl pageControl) {
                return pageControl._maxPage;
            }

            private class PageActionListener
            implements ActionListener {
                public void actionPerformed(ActionEvent e) {
                    JButton btn = (JButton)e.getSource();
                    if (btn == PageControl.ra$_previousSetBtn(PageControl.this)) {
                        int startPage = Math.max(PageControl.ra$_minPage(PageControl.this) - 10, 1);
                        PageControl.this.handlePageButtons(startPage);
                    } else if (btn == PageControl.ra$_nextSetBtn(PageControl.this)) {
                        int startPage = PageControl.ra$_maxPage(PageControl.this) + 1;
                        PageControl.this.handlePageButtons(startPage);
                    } else {
                        String text = btn.getText();
                        int rowset = Integer.parseInt(text);
                        SearchResultSection.mav$copyDisplayRowSetData(SearchResultSection.this, rowset - 1);
                    }
                }

                private PageActionListener() {
                }

                PageActionListener(1 var2_2) {
                    this();
                }

                public final class 1 {
                }
            }
        }
    }

    private static class FakeAccordionPanel
    extends JPanel {
        private boolean _expanded;

        private void $init$() {
            this._expanded = true;
        }

        public void paintComponent(Graphics g) {
            Painter painter = null;
            if (Themes.isThemed()) {
                String state = this._expanded ? "active" : "inactive";
                painter = Themes.getActiveTheme().getStateProperties("accordion", state).getPainter("bg");
            }
            if (painter != null) {
                painter.paint(g, 0, 0, this.getWidth(), this.getHeight());
            } else {
                super.paintComponent(g);
            }
        }

        public void setExpanded(boolean expanded) {
            this._expanded = expanded;
            this.repaint();
        }

        private FakeAccordionPanel() {
            this.$init$();
        }

        FakeAccordionPanel(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

