/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.util.ArrayList;
import java.util.Locale;
import oracle.help.common.View;
import oracle.help.common.navigator.searchNavigator.SearchModel;
import oracle.help.common.navigator.searchNavigator.SearchModelData;
import oracle.help.common.search.BooleanExpression;
import oracle.help.common.search.QueryStringBreaker;
import oracle.help.common.search.SearchExpression;
import oracle.help.common.search.StringExpression;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.navigator.searchNavigator.OHJSearchModelData;
import oracle.ide.searchbar.Provider;
import oracle.ide.searchbar.Result;
import oracle.ide.searchbar.ResultContext;
import oracle.ide.util.SwingWorker;
import oracle.javatools.ui.search.SearchProgress;
import oracle.jdevimpl.help.AbstractRSSQueryHandler;
import oracle.jdevimpl.help.HelpCenterWindow;
import oracle.jdevimpl.help.HelpSearchResult;
import oracle.jdevimpl.help.HelpUtils;
import oracle.jdevimpl.help.OTNQueryHandler;
import oracle.jdevimpl.help.OTNQueryView;
import oracle.jdevimpl.help.TahitiQueryHandler;
import oracle.jdevimpl.help.TahitiQueryView;
import oracle.jdevimpl.help.UserQuery;

final class SearchWorker {
    private UserQuery _userQuery;
    private ResultContext _resultContext;
    private SearchModel _searchModel;
    private SwingWorker _swingWorker;
    private SearchProgress _searchProgress;
    private WorkerType _workerType;
    private Provider _provider;
    private boolean _searchDone;
    private String _errorText;

    public SearchWorker(UserQuery userQuery, Provider provider, ResultContext resultContext, WorkerType workerType) {
        this._userQuery = userQuery;
        this._provider = provider;
        this._resultContext = resultContext;
        this._workerType = workerType;
    }

    public SearchWorker(UserQuery userQuery, WorkerType workerType, SearchProgress searchProgress) {
        this(userQuery, null, null, workerType);
        this._searchProgress = searchProgress;
    }

    public boolean searchDone() {
        return this._searchDone;
    }

    public WorkerType getWorkerType() {
        return this._workerType;
    }

    public SearchModel getSearchModel() {
        return this._searchModel;
    }

    public String getErrorText() {
        return this._errorText;
    }

    private boolean searchStopped() {
        if (this._resultContext != null) {
            return this._resultContext.canceled();
        }
        if (this._searchProgress != null) {
            return this._searchProgress.isStopped();
        }
        return false;
    }

    void stopSearch() {
        if (this._swingWorker != null) {
            this._swingWorker.interrupt();
        }
    }

    void startSearch() {
        this._swingWorker = new 1();
        this._swingWorker.start();
    }

    static UserQuery ra$_userQuery(SearchWorker searchWorker) {
        return searchWorker._userQuery;
    }

    static SearchModel ra$_searchModel(SearchWorker searchWorker) {
        return searchWorker._searchModel;
    }

    static ResultContext ra$_resultContext(SearchWorker searchWorker) {
        return searchWorker._resultContext;
    }

    static Provider ra$_provider(SearchWorker searchWorker) {
        return searchWorker._provider;
    }

    static void wa$_searchModel(SearchWorker searchWorker, SearchModel searchModel) {
        searchWorker._searchModel = searchModel;
    }

    static WorkerType ra$_workerType(SearchWorker searchWorker) {
        return searchWorker._workerType;
    }

    static void wa$_errorText(SearchWorker searchWorker, String string) {
        searchWorker._errorText = string;
    }

    static void wa$_swingWorker(SearchWorker searchWorker, SwingWorker swingWorker) {
        searchWorker._swingWorker = swingWorker;
    }

    static void wa$_searchDone(SearchWorker searchWorker, boolean bl) {
        searchWorker._searchDone = bl;
    }

    static boolean mav$searchStopped(SearchWorker searchWorker) {
        return searchWorker.searchStopped();
    }

    final class 1
    extends SwingWorker {
        public Object construct() {
            SearchRunnable searchRunnable = new SearchRunnable();
            searchRunnable.start();
            while (!searchRunnable.isDone() && !SearchWorker.mav$searchStopped(SearchWorker.this)) {
                try {
                    Thread.sleep(100);
                }
                catch (InterruptedException interuptEx) {
                    String string = "Done";
                    return string;
                }
            }
            if (SearchWorker.mav$searchStopped(SearchWorker.this) && SearchWorker.ra$_searchModel(SearchWorker.this) != null) {
                SearchWorker.ra$_searchModel(SearchWorker.this).stopSearch();
            }
            return "Done";
        }

        public void finished() {
            SearchWorker.wa$_swingWorker(SearchWorker.this, null);
            SearchWorker.wa$_searchDone(SearchWorker.this, true);
        }
    }

    private class SearchRunnable
    implements Runnable {
        private Thread _thread = new Thread((Runnable)this, "Searching Thread for Help");
        private boolean _done;

        public void start() {
            this._done = false;
            this._thread.start();
        }

        public boolean isDone() {
            return this._done;
        }

        public void run() {
            try {
                if (SearchWorker.ra$_resultContext(SearchWorker.this) != null) {
                    if (SearchWorker.ra$_workerType(SearchWorker.this) == WorkerType.OTN) {
                        OTNQueryHandler otnQueryHandler = new OTNQueryHandler();
                        otnQueryHandler.executeQuery(this.createStringSearchExpression(), SearchWorker.ra$_provider(SearchWorker.this), SearchWorker.ra$_resultContext(SearchWorker.this));
                    } else if (SearchWorker.ra$_workerType(SearchWorker.this) == WorkerType.TAHITI) {
                        TahitiQueryHandler tahitiQueryHandler = new TahitiQueryHandler();
                        tahitiQueryHandler.setSearchList(SearchWorker.ra$_userQuery(SearchWorker.this).getTahitiSearchList());
                        tahitiQueryHandler.executeQuery(this.createStringSearchExpression(), SearchWorker.ra$_provider(SearchWorker.this), SearchWorker.ra$_resultContext(SearchWorker.this));
                    } else if (SearchWorker.ra$_workerType(SearchWorker.this) == WorkerType.LOCAL) {
                        this.runLocalSearch();
                        this.putLocalSearchIntoResultContext();
                    }
                } else {
                    AbstractRSSQueryHandler rssQueryHandler = null;
                    if (SearchWorker.ra$_workerType(SearchWorker.this) == WorkerType.OTN) {
                        OTNQueryView otnQueryView = new OTNQueryView(null, null, null, null, null, null, null, null, null);
                        SearchWorker.wa$_searchModel(SearchWorker.this, new SearchModel((SearchModelData)new OHJSearchModelData(), new View[]{otnQueryView}));
                        rssQueryHandler = (OTNQueryHandler)((Object)otnQueryView.getViewData());
                    } else if (SearchWorker.ra$_workerType(SearchWorker.this) == WorkerType.TAHITI) {
                        TahitiQueryView tahitiQueryView = new TahitiQueryView(null, null, null, null, null, null, null, null, null);
                        tahitiQueryView.setSearchList(SearchWorker.ra$_userQuery(SearchWorker.this).getTahitiSearchList());
                        SearchWorker.wa$_searchModel(SearchWorker.this, new SearchModel((SearchModelData)new OHJSearchModelData(), new View[]{tahitiQueryView}));
                        rssQueryHandler = (TahitiQueryHandler)((Object)tahitiQueryView.getViewData());
                    }
                    if (SearchWorker.ra$_workerType(SearchWorker.this) == WorkerType.OTN || SearchWorker.ra$_workerType(SearchWorker.this) == WorkerType.TAHITI) {
                        StringExpression searchExpr = new StringExpression(SearchWorker.ra$_userQuery(SearchWorker.this).getQueryText(), false);
                        SearchWorker.ra$_searchModel(SearchWorker.this).startSearch((SearchExpression)searchExpr);
                        SearchWorker.wa$_errorText(SearchWorker.this, rssQueryHandler.getErrorText());
                    } else {
                        this.runLocalSearch();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this._done = true;
        }

        private void runLocalSearch() {
            try {
                SearchWorker.wa$_searchModel(SearchWorker.this, HelpCenterWindow.getSearchModel());
                if (SearchWorker.ra$_userQuery(SearchWorker.this).getSearchType() != 2) {
                    boolean allWords = SearchWorker.ra$_userQuery(SearchWorker.this).getSearchType() == 0;
                    ArrayList wordsArrayList = new ArrayList();
                    QueryStringBreaker.breakQueryString((String)SearchWorker.ra$_userQuery(SearchWorker.this).getQueryText(), (Locale)StaticLocaleContext.getLocale(), wordsArrayList, (boolean)SearchWorker.ra$_userQuery(SearchWorker.this).getCaseSensitive());
                    String[] words = new String[wordsArrayList.size()];
                    wordsArrayList.toArray(words);
                    SearchWorker.ra$_searchModel(SearchWorker.this).startSearch(words, allWords, SearchWorker.ra$_userQuery(SearchWorker.this).getCaseSensitive());
                    ((OHJSearchModelData)SearchWorker.ra$_searchModel(SearchWorker.this).getSearchModelData()).sort(0, false);
                } else {
                    SearchExpression expr = BooleanExpression.buildExpressionTree((String)SearchWorker.ra$_userQuery(SearchWorker.this).getQueryText(), (boolean)SearchWorker.ra$_userQuery(SearchWorker.this).getCaseSensitive());
                    if (expr != null) {
                        SearchWorker.ra$_searchModel(SearchWorker.this).startSearch(expr);
                        ((OHJSearchModelData)SearchWorker.ra$_searchModel(SearchWorker.this).getSearchModelData()).sort(0, false);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private void putLocalSearchIntoResultContext() {
            SearchModelData data;
            if (SearchWorker.ra$_searchModel(SearchWorker.this) != null && (data = SearchWorker.ra$_searchModel(SearchWorker.this).getSearchModelData()) != null && data.getRowCount() > 0) {
                int rowcount = data.getRowCount();
                int i = 0;
                while (i < rowcount) {
                    if (SearchWorker.ra$_resultContext(SearchWorker.this).canceled()) break;
                    String location = (String)data.getData(2, i);
                    HelpSearchResult result = new HelpSearchResult(SearchWorker.ra$_searchModel(SearchWorker.this).getTopicForRow(i), location);
                    this.addResult(SearchWorker.ra$_provider(SearchWorker.this), SearchWorker.ra$_resultContext(SearchWorker.this), result, rowcount - i);
                    ++i;
                }
            }
        }

        private SearchExpression createStringSearchExpression() {
            StringExpression searchExpr = new StringExpression(SearchWorker.ra$_userQuery(SearchWorker.this).getQueryText(), false);
            return searchExpr;
        }

        private void addResult(Provider provider, ResultContext resultContext, HelpSearchResult searchResult, int weight) {
            Result result = new Result.ResultBuilder(provider, (Object)searchResult).displayIcon(HelpUtils.getIconForTopic(searchResult.getResultTopic())).displayText(searchResult.getResultTopic().getLabel()).displayLocation(searchResult.getLocation()).weight(weight).build();
            resultContext.add(result);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WorkerType
    extends Enum<WorkerType> {
        private static final /* synthetic */ WorkerType[] $v;
        public static final /* enum */ WorkerType LOCAL;
        public static final /* enum */ WorkerType OTN;
        public static final /* enum */ WorkerType TAHITI;

        public static WorkerType valueOf(String string) {
            return Enum.valueOf(WorkerType.class, string);
        }

        public static final WorkerType[] values() {
            return (WorkerType[])$v.clone();
        }

        static {
            WorkerType[] workerTypeArray = new WorkerType[3];
            workerTypeArray[2] = TAHITI = new WorkerType("TAHITI", 2);
            workerTypeArray[1] = OTN = new WorkerType("OTN", 1);
            workerTypeArray[0] = LOCAL = new WorkerType("LOCAL", 0);
            $v = workerTypeArray;
        }

        private WorkerType(String string2, int n2) {
        }
    }
}

