/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.net.URLFactory;
import oracle.jdevimpl.help.AbstractRSSQueryHandler;
import oracle.jdevimpl.help.HelpSearchResult;
import oracle.jdevimpl.help.TahitiSearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TahitiQueryHandler
extends AbstractRSSQueryHandler {
    public static final String URL_BEGINNING = "http://tahiti-stage.us.oracle.com/pls/";
    public static final String URL_ENDING = "/search?";
    private List<String> _searchList;

    void setSearchList(List<String> searchList) {
        this._searchList = searchList;
    }

    protected String createQueryString(String searchText) {
        String queryString = "word=" + searchText + "&format=rss";
        return this.htmlEncodeString(queryString);
    }

    @Override
    protected List<URL> createSearchURLs(String searchText) {
        ArrayList<URL> urlList = new ArrayList<URL>(2);
        for (String section : this._searchList) {
            String urlString = URL_BEGINNING + section + URL_ENDING;
            try {
                URL url = new URL(urlString);
                url = URLFactory.replaceQueryPart((URL)url, (String)this.createQueryString(searchText));
                urlList.add(url);
            }
            catch (MalformedURLException muex) {
                muex.printStackTrace();
            }
        }
        return urlList;
    }

    @Override
    protected HelpSearchResult createSearchResult(String title, String link, String description) {
        return new TahitiSearchResult(title, link, description);
    }
}

