/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;

class TimedSocket {
    private static final int POLL_DELAY = 100;

    private static Socket getSocket(InetAddress addr, int port, int delay) throws InterruptedIOException, IOException {
        Socket sock;
        SocketThread st;
        block4: {
            st = new SocketThread(addr, port);
            st.start();
            int timer = 0;
            sock = null;
            do {
                if (st.isConnected()) break block4;
                if (st.isError()) {
                    throw st.getException();
                }
                try {
                    Thread.sleep(100);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            } while ((timer += 100) <= delay);
            throw new InterruptedIOException("Could not connect for " + delay + " milliseconds");
        }
        sock = st.getSocket();
        return sock;
    }

    static Socket getSocket(String host, int port, int delay) throws InterruptedIOException, IOException {
        InetAddress inetAddr = InetAddress.getByName(host);
        return TimedSocket.getSocket(inetAddr, port, delay);
    }

    static Socket getSocket(URL url, int delay) throws InterruptedIOException, IOException {
        String host = url.getHost();
        if (host == null) {
            return null;
        }
        InetAddress inetAddr = InetAddress.getByName(host);
        int port = url.getPort();
        if (port <= 0) {
            return null;
        }
        return TimedSocket.getSocket(inetAddr, port, delay);
    }

    public static void main(String[] args) throws Exception {
        try {
            Socket s = TimedSocket.getSocket("192.168.0.3", 80, 5000);
            s.close();
            System.out.println("connected");
        }
        catch (IOException ioe) {
            System.out.println("time out");
        }
    }

    TimedSocket() {
    }

    static class SocketThread
    extends Thread {
        private volatile Socket m_connection;
        private String m_host;
        private InetAddress m_inet;
        private int m_port;
        private IOException m_exception;

        private void $init$() {
            this.m_connection = null;
            this.m_host = null;
            this.m_inet = null;
            this.m_port = 0;
            this.m_exception = null;
        }

        public SocketThread(String host, int port) {
            this.$init$();
            this.m_host = host;
            this.m_port = port;
        }

        public SocketThread(InetAddress inetAddr, int port) {
            this.$init$();
            this.m_inet = inetAddr;
            this.m_port = port;
        }

        public void run() {
            Socket sock = null;
            try {
                sock = this.m_host != null ? new Socket(this.m_host, this.m_port) : new Socket(this.m_inet, this.m_port);
            }
            catch (IOException ioe) {
                this.m_exception = ioe;
                return;
            }
            this.m_connection = sock;
        }

        public boolean isConnected() {
            return this.m_connection != null;
        }

        public boolean isError() {
            return this.m_exception != null;
        }

        public Socket getSocket() {
            return this.m_connection;
        }

        public IOException getException() {
            return this.m_exception;
        }
    }
}

