/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.help;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.help.common.IndirectTarget;
import oracle.help.common.SimpleTopic;
import oracle.help.common.Target;
import oracle.help.common.View;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.ParserFactory;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;
import oracle.help.engine.DataEngine;
import oracle.help.library.Book;
import oracle.jdevimpl.help.CueCardCategory;
import oracle.jdevimpl.help.CueCardSet;

public class XMLCueCardEngine
extends DataEngine {
    private Book _book;
    private String _basePath;
    private List _categoryList;
    public static final String TAG_CUE_CARDS = "cueCards";
    public static final String TAG_CUE_CARD_GROUP = "cardGroup";
    public static final String TAG_CUE_CARD_LIST = "cardList";
    public static final String TAG_CARD = "card";
    public static final String TAG_ID = "id";
    public static final String ROADMAP_ID = "roadmapId";
    public static final String TAG_STEP_LIST = "stepList";
    public static final String TAG_STEP = "step";
    public static final String TAG_TARGET = "target";
    public static final String TAG_TEXT = "text";

    private void $init$() {
        this._categoryList = new ArrayList();
    }

    public XMLCueCardEngine() {
        this.$init$();
    }

    public Object createDataObject(View view, String basePath, URL url, String encoding) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("Null parameter passed to DataEngine constructor");
        }
        BufferedReader r = this._getBufferedReader(url, encoding);
        return this.createDataObject(view, basePath, r);
    }

    public Object createDataObject(View view, String basePath, BufferedReader reader) throws IOException {
        this._book = null;
        this._basePath = basePath;
        if (view != null) {
            this._book = view.getBook();
        }
        Parser parser = ParserFactory.createParser((Reader)reader);
        XMLNode xmlRoot = parser.getRoot();
        this._handleCueCards(xmlRoot.getFirstChild());
        CueCardCategory[] cueCardCategories = null;
        int numCategories = this._categoryList.size();
        if (numCategories > 0) {
            cueCardCategories = this._categoryList.toArray(new CueCardCategory[numCategories]);
        }
        return cueCardCategories;
    }

    private void _handleCueCards(XMLNode xmlNode) throws XMLParseException {
        if (xmlNode == null) {
            throw new XMLParseException("No toplevel tag");
        }
        if (!xmlNode.getTokenValue().equalsIgnoreCase(TAG_CUE_CARDS)) {
            throw new XMLParseException("Toplevel tag is not cueCards: " + xmlNode.getTokenValue());
        }
        xmlNode = xmlNode.getFirstChild();
        while (xmlNode != null) {
            if (xmlNode.getTokenValue().equalsIgnoreCase(TAG_CUE_CARD_GROUP)) {
                this._handleCueCardGroup(xmlNode);
            }
            xmlNode = xmlNode.getNextSibling();
        }
    }

    private void _handleCueCardGroup(XMLNode xmlNode) throws XMLParseException {
        if (xmlNode == null) {
            throw new XMLParseException("No cardGroup tag");
        }
        if (!xmlNode.getTokenValue().equalsIgnoreCase(TAG_CUE_CARD_GROUP)) {
            throw new XMLParseException("tag is not cueCardGroup: " + xmlNode.getTokenValue());
        }
        XMLNode categoryNode = xmlNode.getFirstChild();
        if (!categoryNode.getTokenValue().equalsIgnoreCase(TAG_TEXT)) {
            throw new XMLParseException("tag is not text: " + categoryNode.getTokenValue());
        }
        CueCardCategory cueCardCategory = new CueCardCategory(categoryNode.getString());
        this._categoryList.add(cueCardCategory);
        XMLNode cardListNode = categoryNode.getNextSibling();
        if (!cardListNode.getTokenValue().equalsIgnoreCase(TAG_CUE_CARD_LIST)) {
            throw new XMLParseException("tag is not cardList: " + cardListNode.getTokenValue());
        }
        this._handleCardList(cardListNode, cueCardCategory);
    }

    private void _handleCardList(XMLNode xmlNode, CueCardCategory cueCardCategory) throws XMLParseException {
        xmlNode = xmlNode.getFirstChild();
        while (xmlNode != null) {
            if (xmlNode.getTokenValue().equalsIgnoreCase(TAG_CARD)) {
                this._handleCard(xmlNode, cueCardCategory);
            }
            xmlNode = xmlNode.getNextSibling();
        }
    }

    private void _handleCard(XMLNode xmlNode, CueCardCategory cueCardCategory) throws XMLParseException {
        String id = null;
        String displayText = null;
        String roadmapId = null;
        List stepList = null;
        xmlNode = xmlNode.getFirstChild();
        while (xmlNode != null) {
            if (xmlNode.getTokenValue().equalsIgnoreCase(TAG_ID)) {
                id = xmlNode.getString();
            } else if (xmlNode.getTokenValue().equalsIgnoreCase(TAG_TEXT)) {
                displayText = xmlNode.getString();
            } else if (xmlNode.getTokenValue().equalsIgnoreCase(ROADMAP_ID)) {
                roadmapId = xmlNode.getString();
            } else if (xmlNode.getTokenValue().equalsIgnoreCase(TAG_STEP_LIST)) {
                stepList = this._handleStepList(xmlNode);
            }
            xmlNode = xmlNode.getNextSibling();
        }
        CueCardSet cueCardSet = new CueCardSet(id, displayText, roadmapId, stepList);
        cueCardCategory.addCueCardSet(cueCardSet);
    }

    private List _handleStepList(XMLNode xmlNode) throws XMLParseException {
        if (!xmlNode.getTokenValue().equalsIgnoreCase(TAG_STEP_LIST)) {
            throw new XMLParseException("Tag is not stepList: " + xmlNode.getTokenValue());
        }
        ArrayList stepList = new ArrayList();
        xmlNode = xmlNode.getFirstChild();
        while (xmlNode != null) {
            if (xmlNode.getTokenValue().equalsIgnoreCase(TAG_STEP)) {
                this._handleStep(xmlNode, stepList);
            }
            xmlNode = xmlNode.getNextSibling();
        }
        return stepList;
    }

    private void _handleStep(XMLNode xmlNode, List stepList) throws XMLParseException {
        String targetLoc = null;
        String displayText = null;
        xmlNode = xmlNode.getFirstChild();
        while (xmlNode != null) {
            if (xmlNode.getTokenValue().equalsIgnoreCase(TAG_TARGET)) {
                targetLoc = xmlNode.getString();
            } else if (xmlNode.getTokenValue().equalsIgnoreCase(TAG_TEXT)) {
                displayText = xmlNode.getString();
            }
            xmlNode = xmlNode.getNextSibling();
        }
        SimpleTopic topic = new SimpleTopic(displayText, this._book);
        IndirectTarget target = new IndirectTarget(this._book, targetLoc);
        topic.setTarget((Target)target);
        stepList.add(topic);
    }
}

