/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.externaltools;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.ide.extension.ExtensionRegistry;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolBaseProperties;
import oracle.ide.externaltools.ExternalToolEvent;
import oracle.ide.externaltools.ExternalToolListener;
import oracle.ide.externaltools.ExternalToolScanner;
import oracle.ide.externaltools.ExternalToolType;
import oracle.ide.externaltools.ExternalToolVetoException;
import oracle.ide.externaltools.macro.MacroRegistry;
import oracle.ideimpl.externaltools.ExternalToolsHook;
import oracle.javatools.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExternalToolManager {
    private final List<ExternalToolScanner> _scanners;
    private final List<ExternalToolListener> _listeners;
    private boolean _loadedDeclarativeScanners;

    private void $init$() {
        this._scanners = new ArrayList<ExternalToolScanner>();
        this._listeners = new CopyOnWriteArrayList<ExternalToolListener>();
        this._loadedDeclarativeScanners = false;
    }

    protected ExternalToolManager() {
        this.$init$();
    }

    public static final ExternalToolManager getExternalToolManager() {
        try {
            ExternalToolManager manager;
            InitialContext ic = new InitialContext();
            ExternalToolManager externalToolManager = manager = (ExternalToolManager)ic.lookup("ide/external-tool-manager");
            return externalToolManager;
        }
        catch (NamingException ne) {
            ExternalToolManager externalToolManager = null;
            return externalToolManager;
        }
    }

    public final void addExternalToolListener(ExternalToolListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        this._listeners.add(listener);
    }

    public final void removeExternalToolListener(ExternalToolListener listener) {
        this._listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fireToolWillStart(ExternalToolEvent event) throws ExternalToolVetoException {
        if (event == null) {
            throw new NullPointerException("event is null");
        }
        ExternalToolManager externalToolManager = this;
        synchronized (externalToolManager) {
            for (ExternalToolListener l : this._listeners) {
                l.toolWillStart(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fireToolStarted(ExternalToolEvent event) {
        if (event == null) {
            throw new NullPointerException("event is null");
        }
        ExternalToolManager externalToolManager = this;
        synchronized (externalToolManager) {
            for (ExternalToolListener l : this._listeners) {
                l.toolStarted(event);
            }
        }
    }

    public void registerScanner(ExternalToolScanner scanner) {
        this._scanners.add(scanner);
    }

    public void unregisterScanner(ExternalToolScanner scanner) {
        this._scanners.remove(scanner);
    }

    public List<ExternalToolScanner> getScanners() {
        if (!this._loadedDeclarativeScanners) {
            try {
                ExternalToolsHook hook = (ExternalToolsHook)ExtensionRegistry.getExtensionRegistry().getHook(ExternalToolsHook.NAME);
                this._scanners.addAll(hook.getDeclaredExternalTools().getScanners());
            }
            finally {
                this._loadedDeclarativeScanners = true;
            }
        }
        return Collections.unmodifiableList(this._scanners);
    }

    public abstract MacroRegistry getMacroRegistry();

    public abstract void registerType(ExternalToolType var1);

    public abstract void unregisterType(ExternalToolType var1);

    public abstract int getRegisteredTypeCount();

    public abstract Iterator<ExternalToolType> getRegisteredTypes();

    public final Iterator<ExternalTool> getAllExternalTools() {
        return this.tools().iterator();
    }

    public abstract Collection<ExternalTool> tools();

    public final Iterator<ExternalTool> getExternalToolsByType(ExternalToolType type) {
        return this.toolsOfType(type).iterator();
    }

    public abstract Collection<ExternalTool> toolsOfType(ExternalToolType var1);

    public abstract void addExternalTool(ExternalTool var1);

    public abstract void removeExternalTool(ExternalTool var1);

    public abstract ExternalTool invokeCreateWizard(Component var1, ExternalToolType var2);

    public abstract boolean invokeEditDialog(Component var1, ExternalTool var2);

    public ExternalToolType getType(ExternalTool tool) {
        Class toolTypeClass = tool.getType();
        Iterator<ExternalToolType> i = this.getRegisteredTypes();
        while (i.hasNext()) {
            ExternalToolType type = i.next();
            if (!type.getClass().equals(toolTypeClass)) continue;
            return type;
        }
        return null;
    }

    @NotNull
    public static Set<String> scannerTags(Collection<ExternalTool> tools) {
        if (tools == null) {
            return Collections.emptySet();
        }
        HashSet<String> existingScannerTags = new HashSet<String>();
        for (ExternalTool tool : tools) {
            ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(tool);
            String tag = props.getScannerTag();
            if (tag == null) continue;
            existingScannerTags.add(props.getScannerTag());
        }
        return Collections.unmodifiableSet(existingScannerTags);
    }
}

