/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.externaltools.macro;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.ide.externaltools.ExternalToolType;
import oracle.ide.externaltools.macro.MacroExpander;
import oracle.ide.externaltools.macro.MacroRegistry;
import oracle.ide.externaltools.macro.ParameterizedMacro;
import oracle.javatools.controls.completionfield.FieldInsightProvider;

class MacroFieldInsightProvider
implements FieldInsightProvider {
    private final MacroRegistry m_registry;
    private final ExternalToolType m_type;
    private final boolean m_onlyDirectories;

    MacroFieldInsightProvider(MacroRegistry registry, ExternalToolType type, boolean onlyDirectories) {
        this.m_registry = registry;
        this.m_type = type;
        this.m_onlyDirectories = onlyDirectories;
    }

    public ListCellRenderer getCellRenderer() {
        return new MacroInsightListCellRenderer();
    }

    public boolean handlesInsight(Document doc, int pos) {
        String incompleteMacro = this.getIncompleteMacro(doc, pos);
        return incompleteMacro != null;
    }

    public Object[] getInsightData(Document doc, int pos) {
        String incompleteMacro = this.getIncompleteMacro(doc, pos);
        if (incompleteMacro != null) {
            ArrayList<MacroExpander> alMacros = new ArrayList<MacroExpander>();
            for (MacroExpander macro : this.m_registry.getMacros()) {
                if (!this.isValidMacro(macro) || incompleteMacro != "" && !macro.getMacro().startsWith(incompleteMacro)) continue;
                alMacros.add(macro);
            }
            Object[] macros = new MacroExpander[alMacros.size()];
            alMacros.toArray(macros);
            return macros;
        }
        return null;
    }

    public void completeInsight(Document doc, int caretPos, Object insightObject) {
        try {
            MacroExpander selectedMacro = (MacroExpander)insightObject;
            int endMacro = -1;
            String str = doc.getText(caretPos, doc.getLength() - caretPos);
            int i = caretPos;
            while (i < doc.getLength()) {
                char c = str.charAt(i - caretPos);
                if (c == '}' || Character.isWhitespace(c)) {
                    endMacro = i;
                    break;
                }
                ++i;
            }
            if (endMacro == -1) {
                endMacro = doc.getLength() - 1;
            }
            str = doc.getText(0, caretPos);
            int startMacro = -1;
            int i2 = caretPos - 1;
            while (i2 >= 0) {
                char c = str.charAt(i2);
                if (c == '{') {
                    startMacro = i2;
                    break;
                }
                --i2;
            }
            if (startMacro == -1) {
                startMacro = 0;
            }
            doc.remove(startMacro + 1, endMacro - startMacro);
            doc.insertString(startMacro + 1, selectedMacro.getMacro() + "}", null);
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    public boolean isAutoPopupChar(char c) {
        return c == '.' || c == '{';
    }

    private boolean isValidMacro(MacroExpander macro) {
        if (macro instanceof ParameterizedMacro) {
            return false;
        }
        if (this.m_type == null || macro.isAvailableForType(this.m_type)) {
            if (this.m_onlyDirectories && macro.isDirectoryMacro()) {
                return true;
            }
            if (!this.m_onlyDirectories) {
                return true;
            }
        }
        return false;
    }

    private String getIncompleteMacro(Document doc, int caretPos) {
        try {
            int startMacro = -1;
            int i = caretPos - 1;
            while (i >= 0) {
                char c = doc.getText(i, 1).charAt(0);
                if (Character.isWhitespace(c) || c == '}') break;
                if (c == '{' && i > 0 && doc.getText(i - 1, 1).charAt(0) == '$') {
                    startMacro = i - 1;
                    break;
                }
                --i;
            }
            if (startMacro > -1) {
                int startMoniker = startMacro + 2;
                if (startMoniker < caretPos) {
                    String string = doc.getText(startMoniker, caretPos - startMoniker);
                    return string;
                }
                String string = "";
                return string;
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
        return null;
    }

    private static class MacroInsightListCellRenderer
    extends JPanel
    implements ListCellRenderer {
        private DefaultListCellRenderer m_macroLabel = new DefaultListCellRenderer();
        private DefaultListCellRenderer m_nameLabel = new DefaultListCellRenderer();

        MacroInsightListCellRenderer() {
            this.m_nameLabel.setHorizontalAlignment(4);
            this.m_nameLabel.setForeground(UIManager.getColor("controlShadow"));
            this.setLayout(new GridBagLayout());
            this.add((Component)this.m_macroLabel, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 18, 2, new Insets(0, 0, 0, 0), 15, 0));
            this.add((Component)this.m_nameLabel, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 12, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        public Component getListCellRendererComponent(JList lst, Object o, int row, boolean isSelected, boolean cellHasFocus) {
            if (o instanceof MacroExpander) {
                MacroExpander macro = (MacroExpander)o;
                this.m_macroLabel.setText("${" + macro.getMacro() + "}");
                this.m_nameLabel.setText(macro.getShortLabel());
                if (isSelected) {
                    this.m_macroLabel.setBackground(lst.getSelectionBackground());
                    this.m_nameLabel.setBackground(lst.getSelectionBackground());
                    this.m_macroLabel.setForeground(lst.getSelectionForeground());
                    this.m_nameLabel.setForeground(lst.getSelectionForeground());
                } else {
                    this.m_macroLabel.setBackground(lst.getBackground());
                    this.m_macroLabel.setForeground(lst.getForeground());
                    this.m_nameLabel.setBackground(lst.getBackground());
                    this.m_nameLabel.setForeground(lst.getForeground());
                }
            }
            return this;
        }
    }
}

