/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools;

import java.awt.Window;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.PropertyResolver;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolBaseProperties;
import oracle.ide.externaltools.ExternalToolManager;
import oracle.ide.externaltools.ToolRunException;
import oracle.ideimpl.externaltools.MenuManager;
import oracle.ideimpl.externaltools.Util;
import oracle.javatools.dialogs.ExceptionDialog;

final class ExternalToolAction {
    private static final String EXTERNAL_TOOL_PROPERTY = "externalToolInstance";
    private static final Controller s_externalToolController = new ETController(null);

    private ExternalToolAction() {
    }

    static ExternalTool getExternalTool(IdeAction action) {
        return (ExternalTool)action.getValue(EXTERNAL_TOOL_PROPERTY);
    }

    static IdeAction getExternalToolAction(int cmdId, ExternalTool tool) {
        IdeAction action = IdeAction.get((int)cmdId);
        if (ExternalToolAction.getExternalTool(action) == null) {
            ETPropertyResolver resolver = new ETPropertyResolver(tool, null);
            action.addPropertyResolver((PropertyResolver)resolver);
            action.putValue("Category", (Object)IdeMainWindow.ACTION_CATEGORY_TOOLS);
            action.addController(s_externalToolController);
        }
        return action;
    }

    private static final class ETController
    implements Controller {
        public boolean handleEvent(IdeAction action, Context context) {
            ExternalTool tool = ExternalToolAction.getExternalTool(action);
            if (tool != null) {
                try {
                    tool.run(ExternalToolManager.getExternalToolManager(), context);
                }
                catch (ToolRunException e) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)e);
                }
            }
            return true;
        }

        public boolean update(IdeAction action, Context context) {
            ExternalTool tool = ExternalToolAction.getExternalTool(action);
            boolean enabled = MenuManager.isToolEnabledInContext(tool, context);
            action.setEnabled(enabled);
            return true;
        }

        private ETController() {
        }

        ETController(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static final class ETPropertyResolver
    extends PropertyResolver {
        private final ExternalTool _tool;
        private final ExternalToolBaseProperties _props;

        private ETPropertyResolver(ExternalTool tool) {
            this._tool = tool;
            this._props = ExternalToolBaseProperties.getInstance(tool);
        }

        public Object get(String propertyName) {
            if ("SmallIcon".equals(propertyName)) {
                return Util.getToolIcon(this._tool, Context.newIdeContext());
            }
            if ("MnemonicKey".equals(propertyName)) {
                String toolName = this._props.getCaption();
                if (toolName != null) {
                    int code = StringUtils.getMnemonicKeyCode((String)toolName);
                    return code;
                }
            } else if ("Name".equals(propertyName)) {
                String toolName = this._props.getCaption();
                if (toolName != null) {
                    return StringUtils.stripMnemonic((String)toolName);
                }
            } else {
                if ("ShortDescription".equals(propertyName)) {
                    return this._props.getToolTipText();
                }
                if (ExternalToolAction.EXTERNAL_TOOL_PROPERTY.equals(propertyName)) {
                    return this._tool;
                }
            }
            return null;
        }

        ETPropertyResolver(ExternalTool externalTool, 1 var2_2) {
            this(externalTool);
        }

        public final class 1 {
        }
    }
}

