/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolManager;
import oracle.ide.externaltools.ExternalToolType;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExternalToolList
extends HashStructureAdapter {
    private static final Logger LOG = Logger.getLogger(ExternalToolList.class.getName());
    private static final String KEY_EXTERNAL_TOOLS = "oracle.ideimpl.externaltools.ExternalToolList";
    private static final String KEY_TOOLS = "external-tools";
    private static final String KEY_TOOL_TYPE = "type";
    private static final String KEY_TOOL_PROPS = "properties";

    private ExternalToolList(HashStructure hs) {
        super(hs);
    }

    public static ExternalToolList getInstance(PropertyStorage ps) {
        return new ExternalToolList(ExternalToolList.findOrCreate((PropertyStorage)ps, (String)KEY_EXTERNAL_TOOLS));
    }

    public List<ExternalTool> tools() {
        ListStructure ls = this.getHashStructure().getListStructure(KEY_TOOLS);
        if (ls == null) {
            return Collections.emptyList();
        }
        ArrayList<ExternalTool> tools = new ArrayList<ExternalTool>(ls.size());
        for (Object o : ls) {
            HashStructure hs = (HashStructure)o;
            ExternalTool tool = this.hashStructureToTool(hs);
            if (tool == null) continue;
            tools.add(tool);
        }
        return tools;
    }

    private ExternalTool hashStructureToTool(HashStructure hs) {
        String typeId = hs.getString(KEY_TOOL_TYPE);
        if (typeId == null) {
            LOG.warning("External tool has no type: " + hs);
            return null;
        }
        ExternalToolType type = this.findType(typeId);
        if (type == null) {
            LOG.fine("External tool of type " + typeId + " ignored, because its creator is not registered.");
            return null;
        }
        HashStructure data = hs.getOrCreateHashStructure(KEY_TOOL_PROPS);
        ExternalTool tool = type.createExternalTool();
        tool.setData(data);
        return tool;
    }

    private ExternalToolType findType(String typeId) {
        Iterator<ExternalToolType> i = ExternalToolManager.getExternalToolManager().getRegisteredTypes();
        while (i.hasNext()) {
            ExternalToolType type = i.next();
            if (!type.getClass().getName().equals(typeId)) continue;
            return type;
        }
        return null;
    }

    public void add(ExternalTool tool) {
        if (tool == null) {
            throw new NullPointerException("tool is null");
        }
        ListStructure ls = this.getOrCreateListStructure();
        ls.add((Object)this.toolToHashStructure(tool));
    }

    public void add(int index, ExternalTool tool) {
        if (tool == null) {
            throw new NullPointerException("tool is null");
        }
        ListStructure ls = this.getOrCreateListStructure();
        ls.add(index, (Object)this.toolToHashStructure(tool));
    }

    public boolean remove(ExternalTool tool) {
        int index = this.findToolIndex(tool);
        if (index == -1) {
            return false;
        }
        ListStructure ls = this.getListStructure();
        if (ls == null) {
            return false;
        }
        ls.remove(index);
        return true;
    }

    public void moveUp(ExternalTool tool) {
        this.shift(tool, true);
    }

    public void moveDown(ExternalTool tool) {
        this.shift(tool, false);
    }

    private void shift(ExternalTool tool, boolean up) {
        ListStructure list = this.getListStructure();
        int index = this.findToolIndexOrFail(tool);
        if (up && index == 0) {
            throw new IllegalStateException("Already at top:" + tool);
        }
        if (!up && index >= list.size() - 1) {
            throw new IllegalStateException("Already at bottom:" + tool);
        }
        Object o = list.remove(index);
        list.add(index + (up ? -1 : 1), o);
    }

    private int findToolIndexOrFail(ExternalTool tool) {
        int index = this.findToolIndex(tool);
        if (index == -1) {
            throw new IllegalArgumentException("Not in list: " + tool);
        }
        return index;
    }

    private int findToolIndex(ExternalTool tool) {
        ListStructure ls = this.getListStructure();
        if (ls == null) {
            return -1;
        }
        int i = 0;
        while (i < ls.size()) {
            HashStructure hs = (HashStructure)ls.get(i);
            if (tool.equals(this.hashStructureToTool(hs))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private HashStructure toolToHashStructure(ExternalTool tool) {
        HashStructure hs = HashStructure.newInstance();
        hs.putString(KEY_TOOL_TYPE, this.getTypeId(tool));
        hs.putHashStructure(KEY_TOOL_PROPS, tool.getData());
        return hs;
    }

    private String getTypeId(ExternalTool tool) {
        return tool.getType().getName();
    }

    private ListStructure getListStructure() {
        return this.getHashStructure().getListStructure(KEY_TOOLS);
    }

    private ListStructure getOrCreateListStructure() {
        return this.getHashStructure().getOrCreateListStructure(KEY_TOOLS);
    }
}

