/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools;

import java.awt.Component;
import javax.swing.JMenuItem;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolBaseProperties;
import oracle.ide.externaltools.IntegrationPoint;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.view.View;
import oracle.ideimpl.externaltools.ExternalToolAddin;
import oracle.ideimpl.externaltools.MenuManager;

final class ExternalToolsContextMenuListener
implements ContextMenuListener {
    private ExternalToolAddin getExternalToolAddin() {
        return (ExternalToolAddin)AddinManager.getAddinManager().getAddin(ExternalToolAddin.class);
    }

    private MenuManager getMenuManager() {
        return this.getExternalToolAddin().getMenuManager();
    }

    public void menuWillShow(ContextMenu popup) {
        for (ExternalTool t : this.getExternalToolAddin().tools()) {
            boolean isRightView;
            ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(t);
            boolean bl = isRightView = props.isIntegrated(IntegrationPoint.NAVIGATOR_MENU) && popup.getContext().getView() instanceof NavigatorWindow || props.isIntegrated(IntegrationPoint.CODE_EDITOR_MENU) && this.isCodeEditor(popup.getContext().getView());
            if (!isRightView || !MenuManager.isToolEnabledInContext(t, popup.getContext())) continue;
            IdeAction action = this.getMenuManager().getIdeActionForTool(t);
            JMenuItem item = popup.createMenuItem((ToggleAction)action);
            float section = MenuConstants.SECTION_TOOLS_EXTERNAL_TOOLS;
            if (this.isCodeEditor(popup.getContext().getView())) {
                section += 0.05f;
            }
            popup.add((Component)item, section);
        }
    }

    private boolean isCodeEditor(View view) {
        return view != null && "oracle.ide.ceditor.CodeEditor".equals(view.getClass().getName());
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    ExternalToolsContextMenuListener() {
    }
}

