/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.externaltools.Availability;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolBaseProperties;
import oracle.ide.externaltools.IntegrationPoint;
import oracle.ide.keyboard.DefaultKeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.externaltools.ExternalToolAction;
import oracle.ideimpl.externaltools.ExternalToolAddin;
import oracle.javatools.controls.JMenuSorter;

final class MenuManager {
    private ExternalToolAddin m_externalToolAddin;
    private ArrayList m_menuItems;
    private ArrayList m_mainToolBarItems;
    private ToolKeyStrokeContext m_keyStrokeContext;
    private static final int EXTERNAL_TOOLS_CMD_ID = Ide.findCmdID((String)"ExternalTools");

    MenuManager(ExternalToolAddin eta) {
        this.m_externalToolAddin = eta;
    }

    private void deregisterAction(ExternalTool t) {
        IdeAction action = this.getIdeActionForTool(t);
        if (action != null) {
            IdeAction.remove((int)action.getCommandId());
        }
    }

    private void removeMenu(ExternalTool t) {
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(t);
        if (this.m_menuItems != null && props.isIntegrated(IntegrationPoint.TOOLS_MENU)) {
            IdeAction action = this.getIdeActionForTool(t);
            for (JMenuItem b : this.m_menuItems) {
                if (b.getAction() != action) continue;
                Ide.getMenubar().remove((Component)b, oracle.ide.controller.MenuManager.getJMenu((String)"Tools"));
                b.setAction(null);
                this.m_menuItems.remove(b);
                if (this.m_menuItems.size() != 0) break;
                this.m_menuItems = null;
                break;
            }
        }
    }

    private void removeToolBarItems(ExternalTool t) {
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(t);
        if (this.m_mainToolBarItems != null && props.isIntegrated(IntegrationPoint.MAIN_TOOLBAR)) {
            IdeAction action = this.getIdeActionForTool(t);
            for (JMenuItem b : this.m_mainToolBarItems) {
                if (b.getAction() != action) continue;
                Ide.getToolbar().remove((Component)b);
                b.setAction(null);
                this.m_mainToolBarItems.remove(b);
                if (this.m_mainToolBarItems.size() == 0) {
                    this.m_mainToolBarItems = null;
                }
                Ide.getToolbar().invalidate();
                Ide.getToolbar().validate();
                Ide.getToolbar().repaint();
                break;
            }
        }
    }

    private void addMenu(ExternalTool t) {
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(t);
        if (props.isIntegrated(IntegrationPoint.TOOLS_MENU)) {
            if (this.m_menuItems == null) {
                this.m_menuItems = new ArrayList();
            }
            JMenu toolsMenu = oracle.ide.controller.MenuManager.getJMenu((String)"Tools");
            IdeAction action = this.getIdeActionForTool(t);
            JMenuItem item = Ide.getMenubar().createMenuItem((ToggleAction)action);
            this.m_menuItems.add(item);
            Ide.getMenubar().add((Component)item, toolsMenu, MenuConstants.SECTION_TOOLS_EXTERNAL_TOOLS);
            if (JMenuSorter.isSorted((JMenu)toolsMenu)) {
                JMenuSorter.registerExclusionGroup((JMenu)toolsMenu, (Component)item);
            }
        }
    }

    private void createMenus() {
        for (ExternalTool tool : this.m_externalToolAddin.tools()) {
            this.addMenu(tool);
        }
    }

    private void deregisterActions() {
        for (ExternalTool tool : this.m_externalToolAddin.tools()) {
            this.deregisterAction(tool);
        }
    }

    private void removeMenus() {
        if (this.m_menuItems == null) {
            return;
        }
        JMenu toolsMenu = oracle.ide.controller.MenuManager.getJMenu((String)"Tools");
        for (JMenuItem mi : this.m_menuItems) {
            mi.setAction(null);
            Ide.getMenubar().remove((Component)mi, toolsMenu);
        }
        this.m_menuItems = null;
    }

    private void addToolBarItem(ExternalTool t, boolean repaint) {
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(t);
        if (props.isIntegrated(IntegrationPoint.MAIN_TOOLBAR)) {
            if (this.m_mainToolBarItems == null) {
                this.m_mainToolBarItems = new ArrayList();
            }
            IdeAction action = this.getIdeActionForTool(t);
            this.m_mainToolBarItems.add(Ide.getToolbar().add((ToggleAction)action));
            if (repaint) {
                Ide.getToolbar().validate();
                Ide.getToolbar().repaint();
            }
        }
    }

    private void createToolBarItems() {
        this.m_mainToolBarItems = new ArrayList();
        boolean needMainSep = true;
        for (ExternalTool t : this.m_externalToolAddin.tools()) {
            ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(t);
            if (!props.isIntegrated(IntegrationPoint.MAIN_TOOLBAR)) continue;
            if (needMainSep) {
                Ide.getToolbar().addSeparator();
                Component c = Ide.getToolbar().getComponentAtIndex(Ide.getToolbar().getComponentCount() - 1);
                this.m_mainToolBarItems.add(c);
                needMainSep = false;
            }
            this.addToolBarItem(t, false);
        }
        if (!needMainSep) {
            Ide.getToolbar().validate();
            Ide.getToolbar().repaint();
        }
    }

    private void removeToolBarItems() {
        if (this.m_mainToolBarItems != null) {
            for (Component item : this.m_mainToolBarItems) {
                Ide.getToolbar().remove(item);
                if (!(item instanceof AbstractButton)) continue;
                ((AbstractButton)item).setAction(null);
            }
            Ide.getToolbar().invalidate();
            Ide.getToolbar().validate();
            Ide.getToolbar().repaint();
            this.m_mainToolBarItems = null;
        }
    }

    IdeAction getIdeActionForTool(ExternalTool t) {
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(t);
        String strippedTitle = "ExternalTool." + StringUtils.stripMnemonic((String)props.getCaption()).replace(' ', '_');
        return ExternalToolAction.getExternalToolAction(Ide.findOrCreateCmdID((String)strippedTitle), t);
    }

    private IdeAction getExternalToolsAction() {
        return IdeAction.find((int)EXTERNAL_TOOLS_CMD_ID);
    }

    void addToolsMenuItem() {
        JMenu toolsMenu = oracle.ide.controller.MenuManager.getJMenu((String)"Tools");
        JMenuItem editItem = Ide.getMenubar().createMenuItem((ToggleAction)this.getExternalToolsAction(), 1.0f);
        Ide.getMenubar().add((Component)editItem, toolsMenu, MenuConstants.SECTION_TOOLS_EXTERNAL_TOOLS);
        if (JMenuSorter.isSorted((JMenu)toolsMenu)) {
            JMenuSorter.registerExclusionGroup((JMenu)toolsMenu, (Component)editItem);
        }
    }

    void addItem(ExternalTool t) {
        this.addMenu(t);
        this.addToolBarItem(t, true);
        this.deinstallKeystrokes();
        this.installKeystrokes();
    }

    void removeItem(ExternalTool t) {
        this.removeMenu(t);
        this.removeToolBarItems(t);
        this.deinstallKeystrokes();
        this.deregisterAction(t);
        this.installKeystrokes();
    }

    void installItems() {
        this.createMenus();
        this.createToolBarItems();
        this.installKeystrokes();
    }

    void uninstallItems() {
        this.removeMenus();
        this.removeToolBarItems();
        this.deinstallKeystrokes();
        this.deregisterActions();
    }

    private void installKeystrokes() {
        this.m_keyStrokeContext = new ToolKeyStrokeContext(null);
        Ide.getKeyStrokeContextRegistry().addContext((KeyStrokeContext)this.m_keyStrokeContext);
        Ide.getSettings().getKeyStrokeOptions().solvePostponedMaps();
    }

    private void deinstallKeystrokes() {
        if (this.m_keyStrokeContext != null) {
            Ide.getKeyStrokeContextRegistry().removeContext((KeyStrokeContext)this.m_keyStrokeContext);
        }
    }

    private static boolean isValidElement(Element e) {
        return e != null && e instanceof Locatable && ((Locatable)e).getURL() != null;
    }

    static boolean isToolEnabledInContext(ExternalTool tool, Context ctx) {
        Object e = ctx.getElement() != null ? ctx.getElement() : ctx.getNode();
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(tool);
        if (props.getAvailability() == Availability.ALWAYS) {
            return true;
        }
        if (props.getAvailability() == Availability.ANY_SELECTION) {
            return MenuManager.isValidElement(e);
        }
        if (props.getAvailability() == Availability.SELECTED_TYPES && MenuManager.isValidElement(e)) {
            URL u = ((Locatable)e).getURL();
            String fileExtension = URLFileSystem.getSuffix((URL)u);
            List<String> types = props.getAvailableTypes();
            DocumentExtensions de = (DocumentExtensions)Ide.getSettings().getData("document-extensions-options");
            boolean caseSensitive = URLFileSystem.isLocalFileSystemCaseSensitive();
            if (de != null) {
                Collection c = de.getDocuments();
                for (DocumentExtensions.DocRecord record : c) {
                    if (!types.contains(record.getDocClassName())) continue;
                    for (DocumentExtensions.ExtInfo extInfo : record.getExtensions()) {
                        String thisExtension = extInfo.getExtension();
                        if ((!caseSensitive || !thisExtension.equals(fileExtension)) && (caseSensitive || !thisExtension.equalsIgnoreCase(fileExtension))) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    static ExternalToolAddin ra$m_externalToolAddin(MenuManager menuManager) {
        return menuManager.m_externalToolAddin;
    }

    static IdeAction mav$getExternalToolsAction(MenuManager menuManager) {
        return menuManager.getExternalToolsAction();
    }

    private class ToolKeyStrokeContext
    extends DefaultKeyStrokeContext {
        public String getName() {
            return "ToolManager";
        }

        public Set getAllActions(boolean global) {
            if (global) {
                HashSet<IdeAction> set = new HashSet<IdeAction>();
                for (ExternalTool t : MenuManager.ra$m_externalToolAddin(MenuManager.this).tools()) {
                    set.add(MenuManager.this.getIdeActionForTool(t));
                }
                set.add(MenuManager.mav$getExternalToolsAction(MenuManager.this));
                return set;
            }
            return null;
        }

        protected void addGlobalKeyStrokes(KeyStrokeMap map) {
        }

        private ToolKeyStrokeContext() {
        }

        ToolKeyStrokeContext(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

