/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import oracle.ide.externaltools.Availability;
import oracle.ide.externaltools.ExternalProgramToolProperties;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolBaseProperties;
import oracle.ide.externaltools.ExternalToolFactory;
import oracle.ide.externaltools.ExternalToolManager;
import oracle.ide.externaltools.ExternalToolScanner;
import oracle.ide.externaltools.IntegrationPoint;
import oracle.ide.natives.NativeHandler;
import oracle.ide.natives.registry.Registry;
import oracle.ide.natives.registry.RegistryException;
import oracle.ide.natives.registry.RegistryKey;
import oracle.ide.natives.registry.RegistryNotAvailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WindowsToolScanner
implements ExternalToolScanner {
    private static final String[][] REGISTRY_APPS = new String[][]{{"Dreamweaver.exe", "Dreamweaver"}, {"cvsnt.exe", "CVS for NT"}, {"firefox.exe", "Mozilla Firefox"}, {"IEXPLORE.EXE", "Internet Explorer"}, {"msdev.exe", "Microsoft Visual Studio"}, {"TextPad.exe", "TextPad"}, {"Winword.exe", "Word"}, {"winzip32.exe", "WinZip"}, {"wordpad.exe", "Wordpad"}};

    @Override
    public String getId() {
        return "windowsimpl";
    }

    @Override
    public boolean canScan() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().indexOf("windows") >= 0;
    }

    @Override
    public ExternalTool[] findTools(Collection<ExternalTool> existingTools) {
        Set<String> existingScannerTags = ExternalToolManager.scannerTags(existingTools);
        ArrayList<ExternalTool> tools = new ArrayList<ExternalTool>();
        String systemRoot = System.getenv("SYSTEMROOT");
        File f = new File(systemRoot);
        if (f.exists()) {
            File notepad;
            File explorer = new File(f, "explorer.exe");
            if (explorer.exists()) {
                this.addWindowsTool(tools, existingScannerTags, "Explore Directory", explorer.getPath(), "\"${file.dir}\"");
            }
            if ((notepad = new File(f, "notepad.exe")).exists()) {
                this.addWindowsTool(tools, existingScannerTags, "Notepad", notepad.getPath(), "\"${file.path}\"");
            }
            int i = 0;
            while (i < REGISTRY_APPS.length) {
                this.findRegistryApp(tools, existingScannerTags, REGISTRY_APPS[i][0], REGISTRY_APPS[i][1], "\"${file.path}\"");
                ++i;
            }
            return tools.toArray(new ExternalTool[tools.size()]);
        }
        return new ExternalTool[0];
    }

    private void findRegistryApp(List tools, Collection scannerTags, String exeName, String caption, String args) {
        try {
            Registry r = NativeHandler.getRegistry();
            try {
                RegistryKey hklm = r.getLocalMachineKey();
                RegistryKey appPath = hklm.openKey("Software\\Microsoft\\Windows\\CurrentVersion\\App Paths\\" + exeName, 131097L);
                try {
                    File f;
                    String path = appPath.getStringValue(null);
                    if (path != null && (f = new File(path)).exists()) {
                        this.addWindowsTool(tools, scannerTags, caption, f.getPath(), args);
                    }
                }
                finally {
                    appPath.close();
                }
            }
            catch (RegistryException re) {
                re.printStackTrace();
            }
        }
        catch (RegistryNotAvailableException rnae) {
            rnae.printStackTrace();
        }
    }

    private void addWindowsTool(Collection<ExternalTool> tools, Collection<String> scannerTags, String caption, String path, String arguments) {
        String scannerTag = this.getId() + "." + caption;
        if (scannerTags.contains(scannerTag)) {
            return;
        }
        ExternalTool tool = this.createWindowsTool(caption, path, arguments);
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(tool);
        props.setScannerTag(scannerTag);
        tools.add(tool);
    }

    private ExternalTool createWindowsTool(String caption, String path, String arguments) {
        ExternalTool tool = ExternalToolFactory.getInstance().createProgramTool();
        ExternalToolBaseProperties baseProps = ExternalToolBaseProperties.getInstance(tool);
        ExternalProgramToolProperties programProperties = ExternalProgramToolProperties.getInstance(tool);
        programProperties.setExecutable(path);
        programProperties.setArguments(arguments);
        baseProps.setCaption(caption);
        baseProps.setAvailability(Availability.ANY_SELECTION);
        IntegrationPoint[] integrationPointArray = IntegrationPoint.values();
        int n = 0;
        while (n < integrationPointArray.length) {
            IntegrationPoint p = integrationPointArray[n];
            baseProps.setIntegrated(p, true);
            ++n;
        }
        baseProps.setIconURL(ExternalToolManager.getExternalToolManager().getType(tool).getDefaultIconURL(tool));
        baseProps.setSaveAllBeforeRun(true);
        baseProps.setLogOutput(false);
        return tool;
    }
}

