/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.ReentrantWizard;
import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardListener;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.WizardValidateListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolBaseProperties;
import oracle.ide.externaltools.ExternalToolManager;
import oracle.ide.externaltools.ExternalToolOptionsEnvironment;
import oracle.ide.externaltools.ExternalToolOptionsPage;
import oracle.ide.externaltools.ExternalToolType;
import oracle.ide.externaltools.macro.MacroPicker;
import oracle.ide.externaltools.macro.MacroRegistry;
import oracle.ide.externaltools.macro.MacroTextField;
import oracle.ide.help.HelpSystem;
import oracle.ideimpl.externaltools.ExternalToolsArb;
import oracle.ideimpl.externaltools.ui.AvailabilityPanel;
import oracle.ideimpl.externaltools.ui.IntegrationPanel;
import oracle.ideimpl.externaltools.ui.ToolDisplayPanel;
import oracle.ideimpl.externaltools.ui.ToolTypePanel;
import oracle.javatools.dialogs.ExceptionDialog;

public class ExternalToolsWizard
implements ExternalToolOptionsEnvironment {
    private BaseWizard m_wizard;
    private final Map m_typePages;
    private ExternalToolManager m_manager;
    private List m_existingTools;
    private ToolTypePanel m_typePanel;
    private ToolDisplayPanel m_displayPanel;
    private IntegrationPanel m_integPanel;
    private AvailabilityPanel m_availPanel;
    private RealtimeValidationHandler m_rtValidationHandler;
    private WizardPageHandler m_pageHandler;
    private ExternalTool m_tool;
    private ExternalToolType m_type;
    private boolean m_editMode;
    private Map m_pageMap;
    private Map m_reversePageMap;
    private WizardPage m_currentPage;

    private void $init$() {
        this.m_typePages = new HashMap();
        this.m_rtValidationHandler = new RealtimeValidationHandler(null);
        this.m_pageHandler = new WizardPageHandler(null);
        this.m_editMode = false;
        this.m_pageMap = new HashMap();
        this.m_reversePageMap = new HashMap();
    }

    void setExternalTool(ExternalTool tool) {
        this.m_tool = tool;
    }

    public void setUserCanFinishNow(boolean canFinish) {
        if (this.m_wizard instanceof Wizard) {
            ((Wizard)this.m_wizard).setMustFinish(canFinish ^ true);
        }
    }

    public ExternalToolType getType() {
        return this.m_type;
    }

    public ExternalTool getTool() {
        return this.m_tool;
    }

    private ExternalToolOptionsPage[] getTypePages(ExternalToolType type) {
        ExternalToolOptionsPage[] pages = (ExternalToolOptionsPage[])this.m_typePages.get(type);
        if (pages == null) {
            pages = type.getOptionsPages();
            this.m_typePages.put(type, pages);
        }
        return pages;
    }

    void setType(ExternalToolType newType) {
        this.m_type = newType;
        Iterator<ExternalToolType> i = this.m_manager.getRegisteredTypes();
        while (i.hasNext()) {
            ExternalToolType type = i.next();
            ExternalToolOptionsPage[] pages = this.getTypePages(type);
            int j = 0;
            while (j < pages.length) {
                if (type != newType) {
                    this.getWizardPageForOptionsPage(pages[j]).setEnabled(false);
                }
                ++j;
            }
        }
        ExternalToolOptionsPage[] newTypePages = this.getTypePages(newType);
        int i2 = 0;
        while (i2 < newTypePages.length) {
            this.getWizardPageForOptionsPage(newTypePages[i2]).setEnabled(true);
            ++i2;
        }
    }

    private ExternalToolOptionsPage getCurrentOptionsPage() {
        return this.getOptionsPageForWizardPage(this.m_wizard.getPageAt(this.m_wizard.getCurrentPageIndex()));
    }

    private ExternalToolOptionsPage getOptionsPageForWizardPage(WizardPage wp) {
        return (ExternalToolOptionsPage)this.m_reversePageMap.get(wp);
    }

    private WizardPage getWizardPageForOptionsPage(ExternalToolOptionsPage etop) {
        return (WizardPage)this.m_pageMap.get(etop);
    }

    public ExternalTool runEditWizard(List existingTools, ExternalToolManager mgr, Component parent, ExternalTool tool) {
        block5: {
            this.m_manager = mgr;
            this.m_editMode = true;
            this.m_wizard = new ReentrantWizard();
            this.m_wizard.setLogoImage(this.wizardImage());
            this.m_existingTools = existingTools;
            this.m_tool = tool;
            this.m_type = mgr.getType(tool);
            ExternalToolOptionsPage[] pages = this.getTypePages(mgr.getType(tool));
            this.addOptionsPages(this.m_wizard, pages, true);
            if (pages != null && pages.length > 0) {
                this.m_currentPage = (WizardPage)this.m_pageMap.get(pages[0]);
                pages[0].loadOptions(tool, false);
            }
            this.m_displayPanel = new ToolDisplayPanel();
            ImageWizardPage iwp = this.createPage(this.m_displayPanel);
            this.m_wizard.addPage((WizardPage)iwp);
            this.m_integPanel = new IntegrationPanel();
            iwp = this.createPage(this.m_integPanel);
            this.m_wizard.addPage((WizardPage)iwp);
            this.m_availPanel = new AvailabilityPanel();
            iwp = this.createPage(this.m_availPanel);
            this.m_wizard.addPage((WizardPage)iwp);
            this.m_wizard.addWizardListener((WizardListener)new WizardHandler(null));
            WizardDialog dlg = this.createWizardDialog(this.m_wizard, parent, ExternalToolsArb.getString(5));
            try {
                if (!dlg.runDialog()) break block5;
                ExternalTool externalTool = this.m_tool;
                return externalTool;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                dlg.dispose();
                this.m_editMode = false;
            }
        }
        return null;
    }

    private Image wizardImage() {
        return new ImageIcon(ExternalToolsWizard.class.getResource("wizard.png")).getImage();
    }

    public ExternalTool runCreateWizard(List existingTools, ExternalToolManager mgr, Component parent, ExternalToolType type) {
        block10: {
            this.m_manager = mgr;
            this.m_wizard = new Wizard();
            this.m_wizard.setLogoImage(this.wizardImage());
            this.m_existingTools = existingTools;
            if (mgr.getRegisteredTypeCount() <= 0) {
                throw new IllegalStateException("No registered tool types!");
            }
            if (type == null && mgr.getRegisteredTypeCount() > 1) {
                this.m_typePanel = new ToolTypePanel();
                ImageWizardPage iwp = this.createPage(this.m_typePanel);
                this.m_currentPage = iwp;
                this.m_wizard.addPage((WizardPage)iwp);
                this.m_typePanel.loadOptions(null, true);
                boolean firstType = true;
                Iterator<ExternalToolType> i = mgr.getRegisteredTypes();
                while (i.hasNext()) {
                    ExternalToolType thisType = i.next();
                    ExternalToolOptionsPage[] pages = this.getTypePages(thisType);
                    this.addOptionsPages(this.m_wizard, pages, firstType);
                    firstType = false;
                }
            } else {
                if (type == null && mgr.getRegisteredTypeCount() == 1) {
                    type = mgr.getRegisteredTypes().next();
                }
                if (type == null) {
                    throw new IllegalStateException("type is null");
                }
                this.setExternalTool(type.createExternalTool());
                this.m_type = type;
                ExternalToolOptionsPage[] pages = this.getTypePages(type);
                this.addOptionsPages(this.m_wizard, pages, true);
            }
            this.m_displayPanel = new ToolDisplayPanel();
            ImageWizardPage iwp = this.createPage(this.m_displayPanel);
            this.m_wizard.addPage((WizardPage)iwp);
            this.m_integPanel = new IntegrationPanel();
            iwp = this.createPage(this.m_integPanel);
            this.m_wizard.addPage((WizardPage)iwp);
            this.m_availPanel = new AvailabilityPanel();
            iwp = this.createPage(this.m_availPanel);
            this.m_wizard.addPage((WizardPage)iwp);
            this.m_wizard.addWizardListener((WizardListener)new WizardHandler(null));
            this.pageSelected(this.m_wizard.getPageAt(0));
            WizardDialog dlg = this.createWizardDialog(this.m_wizard, parent, ExternalToolsArb.getString(92));
            try {
                if (!dlg.runDialog()) break block10;
                ExternalTool externalTool = this.m_tool;
                return externalTool;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                dlg.dispose();
            }
        }
        return null;
    }

    private void addOptionsPages(BaseWizard wizard, ExternalToolOptionsPage[] optionsPages, boolean enabled) {
        if (optionsPages != null) {
            int j = 0;
            while (j < optionsPages.length) {
                ExternalToolOptionsPage thisPage = optionsPages[j];
                ImageWizardPage iwp = this.createPage(thisPage);
                wizard.addPage((WizardPage)iwp);
                iwp.setEnabled(enabled);
                ++j;
            }
        }
    }

    private ImageWizardPage createPage(ExternalToolOptionsPage optionsPage) {
        ImageWizardPage iwp = new ImageWizardPage((Component)optionsPage.getGUI(), null, optionsPage.getPageName());
        iwp.addWizardValidateListener((WizardValidateListener)this.m_pageHandler);
        iwp.setInitialFocus(optionsPage.getInitialFocus());
        this.m_pageMap.put(optionsPage, iwp);
        this.m_reversePageMap.put(iwp, optionsPage);
        optionsPage.setEnvironment(this);
        if (optionsPage.getHelpTopicID() != null && HelpSystem.getHelpSystem() != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)iwp.getContent(), optionsPage.getHelpTopicID());
        }
        return iwp;
    }

    private final WizardDialog createWizardDialog(BaseWizard baseWiz, Component parent, String title) {
        Frame f;
        Dialog d = DialogUtil.getAncestorDialog((Component)parent);
        WizardDialog dialog = d != null ? new WizardDialog(baseWiz, d, true) : ((f = DialogUtil.getAncestorFrame((Component)parent)) != null ? new WizardDialog(baseWiz, f, true) : new WizardDialog(baseWiz, (Frame)Ide.getMainWindow(), true));
        dialog.setWizardTitle(title);
        return dialog;
    }

    public boolean isUniqueToolName(String name) {
        if (this.m_existingTools != null) {
            for (ExternalTool tool : this.m_existingTools) {
                ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(tool);
                String nameNoMnemonic = StringUtils.stripMnemonic((String)name);
                String toolNameNoMnemonic = StringUtils.stripMnemonic((String)props.getCaption());
                if (!toolNameNoMnemonic.equals(nameNoMnemonic)) continue;
                return false;
            }
        }
        return true;
    }

    private void pageSelected(WizardPage wp) {
        if (this.m_currentPage != null) {
            ExternalToolOptionsPage optionsPage = this.getOptionsPageForWizardPage(this.m_currentPage);
            optionsPage.removePropertyChangeListener("isComplete", this.m_rtValidationHandler);
        }
        this.m_currentPage = wp;
        if (this.m_currentPage != null) {
            ExternalToolOptionsPage optionsPage = this.getOptionsPageForWizardPage(this.m_currentPage);
            optionsPage.addPropertyChangeListener("isComplete", this.m_rtValidationHandler);
            this.m_currentPage.setCanAdvance(optionsPage.isComplete());
            optionsPage.loadOptions(this.m_tool, this.m_editMode ^ true);
        }
    }

    public String makeUniqueName(String name) {
        String newName;
        int i = 1;
        while (!this.isUniqueToolName(newName = name + " " + i++)) {
        }
        return newName;
    }

    public MacroRegistry getMacroRegistry() {
        return this.m_manager.getMacroRegistry();
    }

    public MacroPicker getMacroPicker(boolean onlyDirectories) {
        return this.getMacroRegistry().getPicker(null, onlyDirectories);
    }

    public MacroTextField getMacroTextField(boolean onlyDirectories) {
        return this.getMacroRegistry().getTextField(null, onlyDirectories);
    }

    public ExternalToolsWizard() {
        this.$init$();
    }

    static WizardPage ra$m_currentPage(ExternalToolsWizard externalToolsWizard) {
        return externalToolsWizard.m_currentPage;
    }

    static ExternalToolOptionsPage mav$getCurrentOptionsPage(ExternalToolsWizard externalToolsWizard) {
        return externalToolsWizard.getCurrentOptionsPage();
    }

    static ExternalToolOptionsPage mav$getOptionsPageForWizardPage(ExternalToolsWizard externalToolsWizard, WizardPage wizardPage) {
        return externalToolsWizard.getOptionsPageForWizardPage(wizardPage);
    }

    static ExternalTool ra$m_tool(ExternalToolsWizard externalToolsWizard) {
        return externalToolsWizard.m_tool;
    }

    static boolean ra$m_editMode(ExternalToolsWizard externalToolsWizard) {
        return externalToolsWizard.m_editMode;
    }

    static void mav$pageSelected(ExternalToolsWizard externalToolsWizard, WizardPage wizardPage) {
        externalToolsWizard.pageSelected(wizardPage);
    }

    private class RealtimeValidationHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent pce) {
            ExternalToolsWizard.ra$m_currentPage(ExternalToolsWizard.this).setCanAdvance(ExternalToolsWizard.mav$getCurrentOptionsPage(ExternalToolsWizard.this).isComplete());
        }

        private RealtimeValidationHandler() {
        }

        RealtimeValidationHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class WizardPageHandler
    implements WizardValidateListener {
        public void wizardValidatePage(WizardEvent we) {
            try {
                WizardPage page = we.getPage();
                if (page == null) {
                    return;
                }
                ExternalToolOptionsPage optionsPage = ExternalToolsWizard.mav$getOptionsPageForWizardPage(ExternalToolsWizard.this, page);
                if (optionsPage.validateOptions()) {
                    optionsPage.saveOptions(ExternalToolsWizard.ra$m_tool(ExternalToolsWizard.this), ExternalToolsWizard.ra$m_editMode(ExternalToolsWizard.this) ^ true);
                } else if (we instanceof Cancelable) {
                    ((Cancelable)we).cancel();
                }
            }
            catch (RuntimeException re) {
                ExceptionDialog.showExceptionDialog((Component)we.getPage().getContent(), (Throwable)re);
            }
        }

        private WizardPageHandler() {
        }

        WizardPageHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class WizardHandler
    implements WizardListener {
        public void wizardApplyState(WizardEvent we) {
        }

        public void wizardCanceled(WizardEvent we) {
        }

        public void wizardFinished(WizardEvent we) {
        }

        public void wizardSelectionChanged(WizardEvent we) {
            ExternalToolsWizard.mav$pageSelected(ExternalToolsWizard.this, we.getPage());
        }

        private WizardHandler() {
        }

        WizardHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

