/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolBaseProperties;
import oracle.ide.externaltools.ExternalToolOptionsEnvironment;
import oracle.ide.externaltools.ExternalToolOptionsPage;
import oracle.ide.model.ImageNode;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.externaltools.ExternalToolsArb;
import oracle.ideimpl.externaltools.Util;
import oracle.javatools.controls.FileField;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class ToolDisplayPanel
extends JPanel
implements ExternalToolOptionsPage {
    private static final int MAX_CAPTION = 70;
    private static final int STD_ICON_WIDTH = 16;
    private static final int STD_ICON_HEIGHT = 16;
    private GridBagLayout gridBagLayout1;
    private JLabel m_hintText;
    private JLabel m_labCaption;
    private JTextField m_tfCaption;
    private JLabel m_labCaptionHint;
    private JLabel m_labToolTip;
    private JTextField m_tfToolTip;
    private JLabel m_lblIconLocation;
    private JTextField m_tfIconLocation;
    private JButton m_btnBrowse;
    private JButton m_defaultIconButton;
    private JLabel m_labPreviewLabel;
    private JLabel m_labPreview;
    private transient ExternalToolOptionsEnvironment m_env;

    private void $init$() {
        this.gridBagLayout1 = new GridBagLayout();
        this.m_hintText = new JLabel();
        this.m_labCaption = new JLabel();
        this.m_tfCaption = new JTextField();
        this.m_labCaptionHint = new JLabel();
        this.m_labToolTip = new JLabel();
        this.m_tfToolTip = new JTextField();
        this.m_lblIconLocation = new JLabel();
        this.m_tfIconLocation = new FileField();
        this.m_btnBrowse = new JButton();
        this.m_defaultIconButton = new JButton();
        this.m_labPreviewLabel = new JLabel();
        this.m_labPreview = new JLabel();
    }

    public ToolDisplayPanel() {
        this.$init$();
        this.jbInit();
        this.m_defaultIconButton.addActionListener(new 1());
        this.m_btnBrowse.addActionListener(new 2());
        3 dl = new 3();
        this.m_tfCaption.getDocument().addDocumentListener(dl);
        this.m_tfIconLocation.getDocument().addDocumentListener(new 4());
    }

    public String getHelpTopicID() {
        return "f1_idedexternaltools3_html";
    }

    private void updatePreviewIcon() {
        URL u;
        Icon icon;
        this.m_labPreview.setIcon(IdeIcons.getIcon((int)23));
        String iconURL = this.m_tfIconLocation.getText();
        if (iconURL.trim().length() != 0 && (icon = Util.getIcon(u = URLFactory.newURL((String)iconURL))) != null) {
            this.m_labPreview.setIcon(icon);
        }
    }

    private void updatePreviewText() {
        try {
            this.m_labPreview.setText(StringUtils.stripMnemonic((String)this.m_tfCaption.getText()));
            int mnemonic = StringUtils.getMnemonicKeyCode((String)this.m_tfCaption.getText());
            this.m_labPreview.setDisplayedMnemonic(mnemonic);
        }
        catch (RuntimeException re) {
            ExceptionDialog.showExceptionDialog((Component)this, (Throwable)re);
        }
    }

    public Component getInitialFocus() {
        return this.m_tfCaption;
    }

    public void saveOptions(ExternalTool t, boolean b) {
        ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(t);
        props.setToolTipText(this.m_tfToolTip.getText().trim().length() == 0 ? null : this.m_tfToolTip.getText());
        String iconURL = this.m_tfIconLocation.getText();
        if (iconURL.trim().length() == 0) {
            props.setIconURL(null);
        } else {
            props.setIconURL(URLFactory.newURL((String)iconURL));
        }
        props.setCaption(this.m_tfCaption.getText());
    }

    public void loadOptions(ExternalTool t, boolean b) {
        if (t == null) {
            this.m_tfCaption.setText("");
            this.m_tfToolTip.setText("");
            this.m_tfIconLocation.setText("");
            this.m_labPreview.setText(" ");
            this.m_labPreview.setIcon(null);
            this.m_labPreview.setDisplayedMnemonic(0);
        } else {
            ExternalToolBaseProperties props = ExternalToolBaseProperties.getInstance(t);
            this.m_tfCaption.setText(props.getCaption());
            this.m_tfToolTip.setText(props.getToolTipText() == null ? "" : props.getToolTipText());
            URL iconURL = props.getIconURL();
            if (iconURL != null) {
                if ("file".equals(iconURL.getProtocol())) {
                    this.m_tfIconLocation.setText(URLFileSystem.getPlatformPathName((URL)iconURL));
                } else {
                    this.m_tfIconLocation.setText(iconURL.toString());
                }
            } else {
                iconURL = this.m_env.getType().getDefaultIconURL(t);
                this.m_tfIconLocation.setText(iconURL.toString());
            }
            this.updatePreviewIcon();
            this.updatePreviewText();
        }
    }

    public boolean validateOptions() {
        URL iconURL = URLFactory.newURL((String)this.m_tfIconLocation.getText());
        if (iconURL != null) {
            if (iconURL.getProtocol().startsWith("ide.fileicon")) {
                String path = URLFileSystem.getPath((URL)iconURL);
                URL base = URLFactory.newFileURL((String)path);
                if (!URLFileSystem.isRegularFile((URL)base)) {
                    this.m_tfIconLocation.requestFocus();
                    this.m_tfIconLocation.selectAll();
                    MessageDialog.error((Component)this, (Object)ExternalToolsArb.getString(88), (String)ExternalToolsArb.getString(110), null);
                    return false;
                }
                return true;
            }
            ImageIcon icon = new ImageIcon(iconURL);
            if (icon == null || icon.getImageLoadStatus() != 8) {
                this.m_tfIconLocation.requestFocus();
                this.m_tfIconLocation.selectAll();
                MessageDialog.error((Component)this, (Object)ExternalToolsArb.getString(88), (String)ExternalToolsArb.getString(110), null);
                return false;
            }
            if (icon.getIconWidth() > 16 || icon.getIconHeight() > 16) {
                this.m_tfIconLocation.requestFocus();
                this.m_tfIconLocation.selectAll();
                MessageDialog.error((Component)this, (Object)ExternalToolsArb.format(33, String.valueOf(16), String.valueOf(16)), (String)ExternalToolsArb.getString(65), null);
                return false;
            }
        }
        return true;
    }

    private void doBrowseIcon() {
        URL url = this.m_tfIconLocation.getText().trim().length() == 0 ? URLFactory.newFileURL((String)Ide.getProductHomeDirectory()) : URLFactory.newFileURL((String)this.m_tfIconLocation.getText());
        URLChooser urc = URLFileSystem.exists((URL)url) ? DialogUtil.newURLChooser((URL)url) : DialogUtil.newURLChooser();
        urc.setSelectionMode(0);
        URLFilter imageFilter = ImageNode.getImageURLFilter();
        urc.setURLFilter(imageFilter);
        if (urc.showOpenDialog((Component)this, ExternalToolsArb.getString(64)) == 0) {
            URL result = urc.getSelectedURL();
            if ("file".equals(result.getProtocol())) {
                this.m_tfIconLocation.setText(URLFileSystem.getPlatformPathName((URL)result));
            } else {
                this.m_tfIconLocation.setText(result.toString());
            }
        }
    }

    private void jbInit() {
        this.setLayout(this.gridBagLayout1);
        this.m_hintText.setText("<html>" + ExternalToolsArb.getString(100) + "</html>");
        ResourceUtils.resLabel((JLabel)this.m_labCaption, (Component)this.m_tfCaption, (String)ExternalToolsArb.getString(53));
        this.m_labCaptionHint.setText(ExternalToolsArb.getString(102));
        ResourceUtils.resLabel((JLabel)this.m_labToolTip, (Component)this.m_tfToolTip, (String)ExternalToolsArb.getString(36));
        ResourceUtils.resLabel((JLabel)this.m_lblIconLocation, (Component)this.m_tfIconLocation, (String)ExternalToolsArb.getString(115));
        ResourceUtils.resButton((AbstractButton)this.m_btnBrowse, (String)ExternalToolsArb.getString(31));
        ResourceUtils.resButton((AbstractButton)this.m_defaultIconButton, (String)ExternalToolsArb.getString(11));
        ResourceUtils.resLabel((JLabel)this.m_labPreviewLabel, (Component)this.m_labPreview, (String)ExternalToolsArb.getString(66));
        this.m_labPreview.setBorder(BorderFactory.createCompoundBorder(this.m_tfCaption.getBorder(), BorderFactory.createEmptyBorder(1, 0, 1, 0)));
        this.m_tfCaption.setDocument(new LimitedLengthDocument(70));
        this.add((Component)this.m_hintText, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)this.m_labCaption, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_tfCaption, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_labCaptionHint, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(2, 0, 5, 0), 0, 0));
        this.add((Component)this.m_labToolTip, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_tfToolTip, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_lblIconLocation, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_tfIconLocation, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_btnBrowse, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 5, 0), 0, 0));
        this.add((Component)this.m_defaultIconButton, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.m_labPreviewLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 0, 5, 0), 0, 0));
        this.add((Component)this.m_labPreview, new GridBagConstraints(0, 10, 2, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public String getPageName() {
        return ExternalToolsArb.getString(113);
    }

    public boolean isComplete() {
        return this.m_tfCaption.getText().trim().length() > 0;
    }

    public JComponent getGUI() {
        return this;
    }

    public void setEnvironment(ExternalToolOptionsEnvironment env) {
        this.m_env = env;
    }

    static ExternalToolOptionsEnvironment ra$m_env(ToolDisplayPanel toolDisplayPanel) {
        return toolDisplayPanel.m_env;
    }

    static JTextField ra$m_tfIconLocation(ToolDisplayPanel toolDisplayPanel) {
        return toolDisplayPanel.m_tfIconLocation;
    }

    static void mav$doBrowseIcon(ToolDisplayPanel toolDisplayPanel) {
        toolDisplayPanel.doBrowseIcon();
    }

    static void mav$updatePreviewText(ToolDisplayPanel toolDisplayPanel) {
        toolDisplayPanel.updatePreviewText();
    }

    static void mav$updatePreviewIcon(ToolDisplayPanel toolDisplayPanel) {
        toolDisplayPanel.updatePreviewIcon();
    }

    final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            try {
                URL u = ToolDisplayPanel.ra$m_env(ToolDisplayPanel.this).getType().getDefaultIconURL(ToolDisplayPanel.ra$m_env(ToolDisplayPanel.this).getTool());
                if ("file".equals(u.getProtocol())) {
                    ToolDisplayPanel.ra$m_tfIconLocation(ToolDisplayPanel.this).setText(URLFileSystem.getPlatformPathName((URL)u));
                } else {
                    ToolDisplayPanel.ra$m_tfIconLocation(ToolDisplayPanel.this).setText(u.toString());
                }
            }
            catch (RuntimeException re) {
                ExceptionDialog.showExceptionDialog((Component)ToolDisplayPanel.this, (Throwable)re);
            }
        }
    }

    final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            try {
                ToolDisplayPanel.mav$doBrowseIcon(ToolDisplayPanel.this);
            }
            catch (RuntimeException re) {
                ExceptionDialog.showExceptionDialog((Component)ToolDisplayPanel.this, (Throwable)re);
            }
        }
    }

    final class 3
    implements DocumentListener {
        protected void doIt() {
            try {
                ToolDisplayPanel.mav$updatePreviewText(ToolDisplayPanel.this);
                boolean isComplete = ToolDisplayPanel.this.isComplete();
                ToolDisplayPanel.this.firePropertyChange("isComplete", isComplete ^ true, isComplete);
            }
            catch (RuntimeException re) {
                ExceptionDialog.showExceptionDialog((Component)ToolDisplayPanel.this.getGUI(), (Throwable)re);
            }
        }

        public void changedUpdate(DocumentEvent de) {
            this.doIt();
        }

        public void insertUpdate(DocumentEvent de) {
            this.doIt();
        }

        public void removeUpdate(DocumentEvent de) {
            this.doIt();
        }
    }

    final class 4
    implements DocumentListener {
        public void changedUpdate(DocumentEvent de) {
            ToolDisplayPanel.mav$updatePreviewIcon(ToolDisplayPanel.this);
        }

        public void insertUpdate(DocumentEvent de) {
            ToolDisplayPanel.mav$updatePreviewIcon(ToolDisplayPanel.this);
        }

        public void removeUpdate(DocumentEvent de) {
            ToolDisplayPanel.mav$updatePreviewIcon(ToolDisplayPanel.this);
        }
    }

    private static class LimitedLengthDocument
    extends PlainDocument {
        private int m_maxLength;

        LimitedLengthDocument(int maxLength) {
            this.m_maxLength = maxLength;
        }

        public void insertString(int off, String str, AttributeSet as) throws BadLocationException {
            if (str == null) {
                str = "";
            }
            if (this.getLength() + str.length() <= this.m_maxLength) {
                super.insertString(off, str, as);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

