/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.button.ButtonBar;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.controls.WaitCursor;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolManager;
import oracle.ide.externaltools.ExternalToolScanner;
import oracle.ide.help.HelpSystem;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.externaltools.ExternalToolList;
import oracle.ideimpl.externaltools.ExternalToolsArb;
import oracle.ideimpl.externaltools.Util;
import oracle.ideimpl.externaltools.ui.ExternalToolsWizard;
import oracle.javatools.controls.SimpleListModel;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public final class ToolListPanel
extends JPanel {
    private GridBagLayout gbl;
    private JLabel cmdLabel;
    private JScrollPane cmdScrollPane;
    private JList cmdList;
    private JButton btnMoveUp;
    private JButton btnMoveDown;
    private JButton btnRemoveCommand;
    private JButton btnAddCommand;
    private JButton btnEditCommand;
    private JButton btnFindTools;
    private ButtonBar bbAddRemove;
    private ButtonBar bbMoveUpDown;
    private transient ExternalToolManager m_manager;
    private transient ExternalToolList _listCopy;
    private boolean m_dialogChanges;
    public static final String COMMIT_PENDING_PROPERTY = "commitPending";

    private void $init$() {
        this.gbl = new GridBagLayout();
        this.cmdLabel = new JLabel();
        this.cmdScrollPane = new JScrollPane();
        this.cmdList = new JList();
        this.btnMoveUp = new JButton();
        this.btnMoveDown = new JButton();
        this.btnRemoveCommand = new JButton();
        this.btnAddCommand = new JButton();
        this.btnEditCommand = new JButton();
        this.btnFindTools = new JButton();
        this.bbAddRemove = new ButtonBar();
        this.bbMoveUpDown = new ButtonBar();
        this.m_dialogChanges = false;
    }

    public ToolListPanel() {
        this.$init$();
        this.jbInit();
        if (HelpSystem.getHelpSystem() != null) {
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_idedexternaltools_html");
        }
        this.cmdList.addListSelectionListener(new 1());
        this.cmdList.setCellRenderer(new ListRenderer(null));
        this.cmdList.addMouseListener(new 2());
        this.cmdList.addKeyListener(new 3());
    }

    private void fireCommitPending() {
        if (!this.m_dialogChanges) {
            this.m_dialogChanges = true;
            super.firePropertyChange(COMMIT_PENDING_PROPERTY, false, true);
        }
    }

    public boolean isCommitPending() {
        return this.m_dialogChanges;
    }

    public void runDialog(Component parent, Runnable commitRunnable) {
        this.btnFindTools.setVisible(false);
        for (ExternalToolScanner thisScanner : this.m_manager.getScanners()) {
            if (!thisScanner.canScan()) continue;
            this.btnFindTools.setVisible(true);
            break;
        }
        JEWTDialog jd = JEWTDialog.createDialog((Component)parent, (String)ExternalToolsArb.getString(97), (int)7);
        jd.setResizable(true);
        jd.setOKButtonEnabled(this.isCommitPending());
        jd.setContent((Component)this);
        jd.pack();
        Dimension prefSize = jd.getPreferredSize();
        jd.setPreferredSize(new Dimension(Math.max(500, prefSize.width), Math.max(350, prefSize.height)));
        4 pcl = new 4(this, jd);
        this.addPropertyChangeListener(COMMIT_PENDING_PROPERTY, pcl);
        5 vcl = null;
        if (commitRunnable != null) {
            vcl = new 5(this, commitRunnable);
            jd.addVetoableChangeListener((VetoableChangeListener)vcl);
        }
        jd.addWindowListener((WindowListener)new 6(this, jd));
        jd.runDialog();
        this.removePropertyChangeListener(COMMIT_PENDING_PROPERTY, pcl);
        if (vcl != null) {
            jd.removeVetoableChangeListener((VetoableChangeListener)vcl);
        }
        jd.dispose();
    }

    private void autoCheckToolScanners() {
        List validScanners = this.getValidAutoScanners();
        if (!validScanners.isEmpty()) {
            boolean doScan = MessageDialog.confirm((Component)this, (Object)ExternalToolsArb.getString(10), (String)ExternalToolsArb.getString(62), null);
            try {
                if (doScan) {
                    this.scanForTools(validScanners);
                }
            }
            finally {
                this.disableAutoScan(validScanners);
            }
        }
    }

    private void scanForTools(List scanners) {
        WaitCursor wc = new WaitCursor((Component)this);
        wc.show();
        7 r = new 7(this, scanners, wc);
        Thread t = new Thread((Runnable)r, "External Tool Scanner");
        t.start();
    }

    private void runDefaultToolsDialog(List tools) {
        this.getListModel().addAll(tools);
        this.fireCommitPending();
        this.cmdList.requestFocus();
        if (tools.size() > 0) {
            this.cmdList.setSelectionInterval(this.cmdList.getModel().getSize() - tools.size(), this.cmdList.getModel().getSize() - 1);
        }
    }

    private List getValidAutoScanners() {
        ArrayList<ExternalToolScanner> scanners = new ArrayList<ExternalToolScanner>();
        for (ExternalToolScanner scanner : this.m_manager.getScanners()) {
            if (scanner.getId() == null) {
                Logger.getLogger(ToolListPanel.class.getName()).log(Level.SEVERE, "ExternalToolScanner " + scanner + " is illegally returning null from getId()", new IllegalStateException());
                continue;
            }
            if (!this.isAutoScanEnabled(scanner) || !scanner.canScan()) continue;
            scanners.add(scanner);
        }
        return Collections.unmodifiableList(scanners);
    }

    private boolean isAutoScanEnabled(ExternalToolScanner scanner) {
        return Ide.getDTCache().getBoolean(this.getKey(scanner), true);
    }

    private void disableAutoScan(List scanners) {
        for (ExternalToolScanner scanner : scanners) {
            Ide.getDTCache().putBoolean(this.getKey(scanner), Boolean.FALSE);
        }
    }

    private String getKey(ExternalToolScanner scanner) {
        StringBuffer b = new StringBuffer(31 + scanner.getId().length());
        b.append("externaltools.scanners.");
        b.append(scanner.getId());
        b.append(".enabled");
        return b.toString();
    }

    public void setToolManager(ExternalToolManager mgr) {
        this.m_manager = mgr;
        ExternalToolList tools = ExternalToolList.getInstance((PropertyStorage)Preferences.getPreferences());
        this._listCopy = (ExternalToolList)((Object)tools.copyTo(null));
        this.cmdList.setModel(new ListModel(this._listCopy));
        if (this._listCopy.tools().size() > 0) {
            this.cmdList.setSelectedIndex(0);
        }
        this.commandListSelectionChanged();
    }

    public ExternalToolList getTools() {
        return this._listCopy;
    }

    private void jbInit() {
        Icon upIcon = OracleIcons.getIcon((String)"up.png");
        Icon downIcon = OracleIcons.getIcon((String)"down.png");
        this.bbAddRemove.setOrientation(0);
        this.bbAddRemove.setAlignment(4);
        this.bbMoveUpDown.setOrientation(1);
        this.bbMoveUpDown.setAlignment(0);
        ButtonListener bl = new ButtonListener(null);
        this.setLayout(this.gbl);
        ResourceUtils.resLabel((JLabel)this.cmdLabel, (Component)this.cmdList, (String)ExternalToolsArb.getString(24));
        this.cmdScrollPane.setPreferredSize(new Dimension(0, 0));
        this.btnMoveUp.setIcon(upIcon);
        this.btnMoveUp.setMargin(new Insets(1, 1, 1, 1));
        this.btnMoveUp.addActionListener(bl);
        this.btnMoveUp.setToolTipText(ExternalToolsArb.getString(8));
        this.btnMoveDown.setIcon(downIcon);
        this.btnMoveDown.setMargin(new Insets(1, 1, 1, 1));
        this.btnMoveDown.addActionListener(bl);
        this.btnMoveDown.setToolTipText(ExternalToolsArb.getString(56));
        ResourceUtils.resButton((AbstractButton)this.btnRemoveCommand, (String)ExternalToolsArb.getString(106));
        this.btnRemoveCommand.addActionListener(bl);
        ResourceUtils.resButton((AbstractButton)this.btnAddCommand, (String)ExternalToolsArb.getString(81));
        this.btnAddCommand.addActionListener(bl);
        ResourceUtils.resButton((AbstractButton)this.btnEditCommand, (String)ExternalToolsArb.getString(42));
        this.btnEditCommand.addActionListener(bl);
        ResourceUtils.resButton((AbstractButton)this.btnFindTools, (String)ExternalToolsArb.getString(22));
        this.btnFindTools.addActionListener(bl);
        this.bbAddRemove.add((Component)this.btnFindTools);
        this.bbAddRemove.add((Component)this.btnAddCommand);
        this.bbAddRemove.add((Component)this.btnEditCommand);
        this.bbAddRemove.add((Component)this.btnRemoveCommand);
        this.bbMoveUpDown.add((Component)this.btnMoveUp);
        this.bbMoveUpDown.add((Component)this.btnMoveDown);
        this.cmdList.setModel(new SimpleListModel());
        this.cmdList.setSelectionMode(2);
        this.add((Component)this.cmdLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.cmdScrollPane.getViewport().add((Component)this.cmdList, null);
        this.add((Component)this.cmdScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.bbMoveUpDown, new GridBagConstraints(1, 1, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.bbAddRemove, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0));
    }

    private void commandListSelectionChanged() {
        if (this.cmdList.getSelectedIndices().length > 1) {
            this.btnRemoveCommand.setEnabled(true);
            this.btnEditCommand.setEnabled(false);
            this.btnMoveUp.setEnabled(false);
            this.btnMoveDown.setEnabled(false);
        } else {
            int sel = this.cmdList.getSelectedIndex();
            this.btnMoveUp.setEnabled(sel > 0);
            this.btnMoveDown.setEnabled(sel != -1 && sel < this.cmdList.getModel().getSize() - 1);
            if (sel == -1) {
                this.btnRemoveCommand.setEnabled(false);
                this.btnEditCommand.setEnabled(false);
            } else {
                this.btnRemoveCommand.setEnabled(true);
                this.btnEditCommand.setEnabled(true);
            }
        }
    }

    private ListModel getListModel() {
        return (ListModel)this.cmdList.getModel();
    }

    private void doAddCommand() {
        ExternalTool tool = new ExternalToolsWizard().runCreateWizard(this._listCopy.tools(), this.m_manager, this, null);
        if (tool != null) {
            this.getListModel().add(tool);
            this.cmdList.setSelectedIndex(this.getListModel().getSize() - 1);
            this.cmdList.ensureIndexIsVisible(this.getListModel().getSize() - 1);
        }
        this.fireCommitPending();
    }

    private void doEditCommand() {
        ExternalTool tool = (ExternalTool)this.cmdList.getSelectedValue();
        if (tool != null) {
            new ExternalToolsWizard().runEditWizard(this._listCopy.tools(), this.m_manager, this, tool);
            this.getListModel().refreshTool(this.cmdList.getSelectedIndex());
            this.fireCommitPending();
        }
    }

    private void doRemoveCommand() {
        this.removeSelectedItems(this.cmdList);
        if (this.cmdList.getModel().getSize() == 0) {
            this.commandListSelectionChanged();
        }
        this.fireCommitPending();
    }

    void removeSelectedItems(JList list) {
        boolean singleSelection;
        int[] selectedIndices = list.getSelectedIndices();
        this.getListModel().removeItems(selectedIndices);
        boolean bl = singleSelection = selectedIndices.length == 1;
        if (singleSelection) {
            int selectIndex = selectedIndices[0];
            if (selectIndex < list.getModel().getSize()) {
                list.setSelectedIndex(selectIndex);
            } else if (list.getModel().getSize() > 0) {
                list.setSelectedIndex(list.getModel().getSize() - 1);
            }
        } else {
            list.getSelectionModel().clearSelection();
        }
    }

    void moveSelectionUp(JList list) {
        int sel = list.getSelectedIndex();
        this.getListModel().moveUp(this._listCopy.tools().get(sel));
        list.setSelectedIndex(sel - 1);
    }

    void moveSelectionDown(JList list) {
        int sel = list.getSelectedIndex();
        this.getListModel().moveDown(this._listCopy.tools().get(sel));
        list.setSelectedIndex(sel + 1);
    }

    private void doMoveToolUp() {
        this.moveSelectionUp(this.cmdList);
        this.fireCommitPending();
    }

    private void doMoveToolDown() {
        this.moveSelectionDown(this.cmdList);
        this.fireCommitPending();
    }

    private void doFindTools() {
        this.scanForTools(this.m_manager.getScanners());
    }

    static JButton ra$btnAddCommand(ToolListPanel toolListPanel) {
        return toolListPanel.btnAddCommand;
    }

    static void mav$doAddCommand(ToolListPanel toolListPanel) {
        toolListPanel.doAddCommand();
    }

    static JButton ra$btnRemoveCommand(ToolListPanel toolListPanel) {
        return toolListPanel.btnRemoveCommand;
    }

    static void mav$doRemoveCommand(ToolListPanel toolListPanel) {
        toolListPanel.doRemoveCommand();
    }

    static JButton ra$btnMoveUp(ToolListPanel toolListPanel) {
        return toolListPanel.btnMoveUp;
    }

    static void mav$doMoveToolUp(ToolListPanel toolListPanel) {
        toolListPanel.doMoveToolUp();
    }

    static JButton ra$btnMoveDown(ToolListPanel toolListPanel) {
        return toolListPanel.btnMoveDown;
    }

    static void mav$doMoveToolDown(ToolListPanel toolListPanel) {
        toolListPanel.doMoveToolDown();
    }

    static JButton ra$btnEditCommand(ToolListPanel toolListPanel) {
        return toolListPanel.btnEditCommand;
    }

    static void mav$doEditCommand(ToolListPanel toolListPanel) {
        toolListPanel.doEditCommand();
    }

    static JButton ra$btnFindTools(ToolListPanel toolListPanel) {
        return toolListPanel.btnFindTools;
    }

    static void mav$doFindTools(ToolListPanel toolListPanel) {
        toolListPanel.doFindTools();
    }

    static ExternalToolList ra$_listCopy(ToolListPanel toolListPanel) {
        return toolListPanel._listCopy;
    }

    static void mav$autoCheckToolScanners(ToolListPanel toolListPanel) {
        toolListPanel.autoCheckToolScanners();
    }

    static void mav$commandListSelectionChanged(ToolListPanel toolListPanel) {
        toolListPanel.commandListSelectionChanged();
    }

    static JList ra$cmdList(ToolListPanel toolListPanel) {
        return toolListPanel.cmdList;
    }

    static void mav$runDefaultToolsDialog(ToolListPanel toolListPanel, List list) {
        toolListPanel.runDefaultToolsDialog(list);
    }

    final class 1
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent lse) {
            try {
                ToolListPanel.mav$commandListSelectionChanged(ToolListPanel.this);
            }
            catch (RuntimeException re) {
                ExceptionDialog.showExceptionDialog((Component)ToolListPanel.this, (Throwable)re);
            }
        }
    }

    final class 2
    extends MouseAdapter {
        public void mouseClicked(MouseEvent me) {
            try {
                if (me.getClickCount() == 2 && me.getButton() == 1 && ToolListPanel.ra$cmdList(ToolListPanel.this).getSelectedValue() != null) {
                    ToolListPanel.mav$doEditCommand(ToolListPanel.this);
                }
            }
            catch (RuntimeException re) {
                ExceptionDialog.showExceptionDialog((Component)ToolListPanel.this, (Throwable)re);
            }
        }
    }

    final class 3
    extends KeyAdapter {
        public void keyReleased(KeyEvent ke) {
            try {
                if (ke.getKeyCode() == 127 && ToolListPanel.ra$cmdList(ToolListPanel.this).getSelectedValue() != null) {
                    ToolListPanel.mav$doRemoveCommand(ToolListPanel.this);
                }
            }
            catch (RuntimeException re) {
                ExceptionDialog.showExceptionDialog((Component)ToolListPanel.this, (Throwable)re);
            }
        }
    }

    final class 4
    implements PropertyChangeListener {
        private final /* synthetic */ JEWTDialog v$jd;
        final /* synthetic */ ToolListPanel this$0;

        public void propertyChange(PropertyChangeEvent pce) {
            this.v$jd.setOKButtonEnabled(this.this$0.isCommitPending());
        }

        public 4(ToolListPanel toolListPanel, JEWTDialog jEWTDialog) {
            this.v$jd = jEWTDialog;
            this.this$0 = toolListPanel;
        }
    }

    final class 5
    implements VetoableChangeListener {
        private final /* synthetic */ Runnable v$commitRunnable;
        final /* synthetic */ ToolListPanel this$0;

        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                try {
                    this.v$commitRunnable.run();
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Component)this.this$0, (Throwable)re);
                    throw new PropertyVetoException("", pce);
                }
            }
        }

        public 5(ToolListPanel toolListPanel, Runnable runnable) {
            this.v$commitRunnable = runnable;
            this.this$0 = toolListPanel;
        }
    }

    final class 6
    extends WindowAdapter {
        private final /* synthetic */ JEWTDialog v$jd;
        final /* synthetic */ ToolListPanel this$0;

        public void windowOpened(WindowEvent e) {
            ToolListPanel.mav$autoCheckToolScanners(this.this$0);
            this.v$jd.removeWindowListener((WindowListener)this);
        }

        public 6(ToolListPanel toolListPanel, JEWTDialog jEWTDialog) {
            this.v$jd = jEWTDialog;
            this.this$0 = toolListPanel;
        }
    }

    final class 7
    implements Runnable {
        private final /* synthetic */ List v$scanners;
        private final /* synthetic */ WaitCursor v$wc;
        final /* synthetic */ ToolListPanel this$0;

        public void run() {
            ArrayList<ExternalTool> tools = new ArrayList<ExternalTool>();
            try {
                try {
                    for (ExternalToolScanner scanner : this.v$scanners) {
                        ExternalTool[] scannerTools = scanner.findTools(ToolListPanel.ra$_listCopy(this.this$0).tools());
                        int j = 0;
                        while (j < scannerTools.length) {
                            tools.add(scannerTools[j]);
                            ++j;
                        }
                    }
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Component)this.this$0, (Throwable)re);
                }
            }
            finally {
                SwingUtilities.invokeLater(new 1());
            }
            if (tools.size() == 0) {
                SwingUtilities.invokeLater(new 2());
            } else {
                SwingUtilities.invokeLater(new 3(this, tools));
            }
        }

        public 7(ToolListPanel toolListPanel, List list, WaitCursor waitCursor) {
            this.v$wc = waitCursor;
            this.v$scanners = list;
            this.this$0 = toolListPanel;
        }

        static WaitCursor ra$v$wc(7 var0) {
            return var0.v$wc;
        }

        final class 1
        implements Runnable {
            public void run() {
                7.ra$v$wc(7.this).hide();
                7.ra$v$wc(7.this).dispose();
            }
        }

        final class 2
        implements Runnable {
            public void run() {
                MessageDialog.information((Component)7.this.this$0, (Object)ExternalToolsArb.getString(32), (String)ExternalToolsArb.getString(84), null);
            }
        }

        final class 3
        implements Runnable {
            private final /* synthetic */ List v$tools;
            final /* synthetic */ 7 this$0;

            public void run() {
                ToolListPanel.mav$runDefaultToolsDialog(this.this$0.this$0, Collections.unmodifiableList(this.v$tools));
            }

            public 3(7 var1_1, List list) {
                this.v$tools = list;
                this.this$0 = var1_1;
            }
        }
    }

    private class ButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            try {
                JButton button = (JButton)e.getSource();
                if (ToolListPanel.ra$btnAddCommand(ToolListPanel.this) == button) {
                    ToolListPanel.mav$doAddCommand(ToolListPanel.this);
                } else if (ToolListPanel.ra$btnRemoveCommand(ToolListPanel.this) == button) {
                    ToolListPanel.mav$doRemoveCommand(ToolListPanel.this);
                } else if (ToolListPanel.ra$btnMoveUp(ToolListPanel.this) == button) {
                    ToolListPanel.mav$doMoveToolUp(ToolListPanel.this);
                } else if (ToolListPanel.ra$btnMoveDown(ToolListPanel.this) == button) {
                    ToolListPanel.mav$doMoveToolDown(ToolListPanel.this);
                } else if (ToolListPanel.ra$btnEditCommand(ToolListPanel.this) == button) {
                    ToolListPanel.mav$doEditCommand(ToolListPanel.this);
                } else if (ToolListPanel.ra$btnFindTools(ToolListPanel.this) == button) {
                    ToolListPanel.mav$doFindTools(ToolListPanel.this);
                }
                if (button.isEnabled()) {
                    button.requestFocus();
                }
            }
            catch (RuntimeException re) {
                ExceptionDialog.showExceptionDialog((Component)ToolListPanel.this, (Throwable)re);
            }
        }

        private ButtonListener() {
        }

        ButtonListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private static class ListRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            if (value instanceof ExternalTool) {
                ExternalTool tool = (ExternalTool)value;
                this.setIcon(Util.getToolIcon(tool, Context.newIdeContext()));
            }
            return c;
        }

        private ListRenderer() {
        }

        ListRenderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }

    private static class ListModel
    extends AbstractListModel {
        private final ExternalToolList _tools;

        ListModel(ExternalToolList tools) {
            this._tools = tools;
        }

        public void removeItems(int[] indices) {
            int newSize;
            int oldSize = this.getSize();
            List<ExternalTool> tools = this._tools.tools();
            int i = 0;
            while (i < indices.length) {
                this._tools.remove(tools.get(indices[i]));
                ++i;
            }
            int start = newSize = this.getSize();
            int end = oldSize - 1;
            this.fireIntervalRemoved(start, end);
            this.fireContentsChanged(this, 0, newSize);
        }

        public void remove(int index) {
            ExternalTool tool = this._tools.tools().get(index);
            this._tools.remove(tool);
            this.fireIntervalRemoved(this, index, index);
        }

        public void fireIntervalRemoved(int start, int end) {
            super.fireIntervalRemoved(this, start, end);
        }

        public void fireIntervalAdded(int start, int end) {
            super.fireIntervalAdded(this, start, end);
        }

        public void addAll(List tools) {
            int size = this.getSize();
            for (ExternalTool tool : tools) {
                this._tools.add(tool);
            }
            this.fireIntervalAdded(size, size + tools.size() - 1);
        }

        public void add(int index, ExternalTool tool) {
            this._tools.add(index, tool);
            this.fireIntervalAdded(this, index, index);
        }

        public void add(ExternalTool tool) {
            this._tools.add(tool);
            int size = this._tools.tools().size();
            this.fireIntervalAdded(this, size - 1, size - 1);
        }

        public void refreshTool(int index) {
            this.fireContentsChanged(this, index, index);
        }

        public void moveUp(ExternalTool tool) {
            this._tools.moveUp(tool);
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }

        public void moveDown(ExternalTool tool) {
            this._tools.moveDown(tool);
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }

        public int getSize() {
            return this._tools.tools().size();
        }

        public Object getElementAt(int index) {
            return this._tools.tools().get(index);
        }
    }
}

