/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.EventHandler;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolManager;
import oracle.ide.externaltools.ExternalToolOptionsEnvironment;
import oracle.ide.externaltools.ExternalToolOptionsPage;
import oracle.ide.externaltools.ExternalToolType;
import oracle.ide.model.Displayable;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.externaltools.ExternalToolsArb;
import oracle.ideimpl.externaltools.ui.ExternalToolsWizard;
import oracle.javatools.dialogs.ExceptionDialog;

public class ToolTypePanel
extends JPanel
implements ExternalToolOptionsPage {
    private GridBagLayout gridBagLayout1;
    private JLabel m_hintLabel;
    private JLabel m_toolTypeLabel;
    private JComboBox m_toolTypeCombo;
    private JLabel m_descriptionLabel;
    private boolean m_populated;
    private transient ExternalToolsWizard m_wizard;

    private void $init$() {
        this.gridBagLayout1 = new GridBagLayout();
        this.m_hintLabel = new JLabel();
        this.m_toolTypeLabel = new JLabel();
        this.m_toolTypeCombo = new JComboBox();
        this.m_descriptionLabel = new JLabel();
        this.m_populated = false;
    }

    public ToolTypePanel() {
        this.$init$();
        this.jbInit();
        this.m_toolTypeCombo.addActionListener(EventHandler.create(ActionListener.class, this, "comboChanged"));
        this.m_toolTypeCombo.setRenderer(new DisplayableComboRenderer(null));
    }

    public Component getInitialFocus() {
        return this.m_toolTypeCombo;
    }

    public String getHelpTopicID() {
        return "f1_idedexternaltools1_html";
    }

    private void loadTypes() {
        try {
            InitialContext context = new InitialContext();
            ExternalToolManager manager = (ExternalToolManager)context.lookup("jdeveloper/external-tool-manager");
            Iterator<ExternalToolType> i = manager.getRegisteredTypes();
            while (i.hasNext()) {
                ExternalToolType type = i.next();
                this.m_toolTypeCombo.addItem(type);
            }
        }
        catch (NamingException ne) {
            ExceptionDialog.showExceptionDialog((Component)this, (Throwable)ne);
        }
    }

    public void comboChanged() {
        Object selection = this.m_toolTypeCombo.getSelectedItem();
        if (selection instanceof ExternalToolType) {
            this.m_descriptionLabel.setText("<html>" + ((ExternalToolType)selection).getLongLabel() + "</html>");
        }
    }

    private void jbInit() {
        this.setLayout(this.gridBagLayout1);
        this.m_hintLabel.setText(ExternalToolsArb.getString(0));
        ResourceUtils.resLabel((JLabel)this.m_toolTypeLabel, (Component)this.m_toolTypeCombo, (String)ExternalToolsArb.getString(67));
        this.m_descriptionLabel.setVerticalAlignment(1);
        this.add((Component)this.m_hintLabel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add((Component)this.m_toolTypeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 12), 0, 0));
        this.add((Component)this.m_toolTypeCombo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_descriptionLabel, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setEnvironment(ExternalToolOptionsEnvironment env) {
        this.m_wizard = (ExternalToolsWizard)env;
    }

    public JComponent getGUI() {
        return this;
    }

    public String getPageName() {
        return ExternalToolsArb.getString(82);
    }

    public boolean isComplete() {
        return true;
    }

    public boolean validateOptions() {
        return true;
    }

    public void saveOptions(ExternalTool tool, boolean isCreateMode) {
        if (isCreateMode) {
            ExternalToolType type = (ExternalToolType)this.m_toolTypeCombo.getSelectedItem();
            if (tool == null || ExternalToolManager.getExternalToolManager().getType(tool) != type) {
                this.m_wizard.setType(type);
                this.m_wizard.setExternalTool(type.createExternalTool());
            }
        }
    }

    public void loadOptions(ExternalTool tool, boolean isCreateMode) {
        if (!this.m_populated) {
            this.loadTypes();
            this.m_populated = true;
        }
    }

    private static class DisplayableComboRenderer
    extends BasicComboBoxRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Displayable) {
                this.setText(((Displayable)value).getShortLabel());
                Icon i = ((Displayable)value).getIcon();
                if (i != null) {
                    this.setIcon(i);
                }
            }
            return c;
        }

        private DisplayableComboRenderer() {
        }

        DisplayableComboRenderer(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

