/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.daf.java;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.daf.model.DafEdge;
import oracle.javatools.daf.model.DafGraph;
import oracle.javatools.daf.model.DafNode;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeParameter;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.util.Usages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DafJavaClassUsages
extends Usages {
    private DafGraph graph;
    private String primaryClassName;
    private DafNode ofClassNode;
    private String ofClassNodeName;
    private Map<String, DafNode> inClassNodeMap;
    private Collection<DafEdge> refEdges;

    DafJavaClassUsages(DafGraph graph, String primaryClassName, DafNode ofClassNode, String ofClassNodeName, Map<String, DafNode> inClassNodeMap, Collection<DafEdge> refEdges) {
        this.graph = graph;
        this.primaryClassName = primaryClassName;
        this.ofClassNode = ofClassNode;
        this.ofClassNodeName = ofClassNodeName;
        this.inClassNodeMap = inClassNodeMap;
        this.refEdges = refEdges;
    }

    public void declareClass(SourceClass s) {
    }

    public void declareConstructor(SourceMethod s) {
    }

    public void declareEnumConstant(SourceEnumConstant s) {
    }

    public void declareField(SourceFieldVariable s) {
    }

    public void declareLocalVariable(SourceLocalVariable s) {
    }

    public void declareMethod(SourceMethod s) {
    }

    public void declareParameter(SourceFormalParameter s) {
    }

    public void declareTypeParameter(SourceTypeParameter s) {
        this.handleTypeReference((JavaType)s, (SourceElement)s, s.getStartOffset());
    }

    public void useFieldInDocComment(SourceDocReference s, JavaField field) {
    }

    public void useFieldInExpression(SourceExpression s, JavaField field) {
    }

    public void useLocalVariableInExpression(SourceExpression s, JavaLocalVariable local) {
    }

    public void useMethodInDocComment(SourceDocReference s, JavaMethod method) {
    }

    public void useMethodInExpression(SourceInvokeExpression s, JavaMethod method) {
    }

    public void useParameterInDocComment(SourceDocReference s, JavaLocalVariable parameter) {
    }

    public void useParameterInExpression(SourceExpression s, JavaLocalVariable parameter) {
    }

    public void useTypeInAnnotation(SourceAnnotation s, JavaType type) {
        this.handleTypeReference(type, (SourceElement)s, s.getStartOffset());
    }

    public void useTypeInDocComment(SourceDocReference s, JavaType type) {
        this.handleTypeReference(type, (SourceElement)s, s.getStartOffset());
    }

    public void useTypeInExpression(SourceExpression s, JavaType type) {
        this.handleTypeReference(type, (SourceElement)s, s.getStartOffset());
    }

    public void useTypeInClassExtends(SourceTypeReference s, JavaType type) {
        this.handleTypeReference(type, (SourceElement)s, s.getStartOffset());
    }

    public void useTypeInFieldDecl(SourceTypeReference s, JavaType type) {
        this.handleTypeReference(type, (SourceElement)s, s.getStartOffset());
    }

    public void useTypeInInstanceof(SourceTypeReference s, JavaType type) {
        this.handleTypeReference(type, (SourceElement)s, s.getStartOffset());
    }

    public void useTypeInLocalVariableDecl(SourceTypeReference s, JavaType type) {
        this.handleTypeReference(type, (SourceElement)s, s.getStartOffset());
    }

    public void useTypeInMiscellaneous(SourceTypeReference s, JavaType type) {
        this.handleTypeReference(type, (SourceElement)s, s.getStartOffset());
    }

    public void useTypeInNarrowImport(SourceImport s, JavaType type) {
        this.handleTypeReference(type, (SourceElement)s, s.getStartOffset());
    }

    public void useTypeInCreator(SourceTypeReference s, JavaType type) {
        this.handleTypeReference(type, (SourceElement)s, s.getStartOffset());
    }

    public void useTypeInParameter(SourceTypeReference s, JavaType type) {
        this.handleTypeReference(type, (SourceElement)s, s.getStartOffset());
    }

    public void useTypeInReturnType(SourceTypeReference s, JavaType type) {
        this.handleTypeReference(type, (SourceElement)s, s.getStartOffset());
    }

    public void useTypeInThrows(SourceTypeReference s, JavaType type) {
        this.handleTypeReference(type, (SourceElement)s, s.getStartOffset());
    }

    public void useTypeInTypecast(SourceTypeReference s, JavaType type) {
        this.handleTypeReference(type, (SourceElement)s, s.getStartOffset());
    }

    private DafNode findContainingClassNode(SourceElement ref) {
        SourceElement element = ref;
        while (element != null) {
            if (element instanceof ClassSym) {
                ClassSym classSym = (ClassSym)element;
                String name = classSym.getVMName().replace('/', '.');
                return this.inClassNodeMap.get(name);
            }
            element = element.getParent();
        }
        return this.inClassNodeMap.get(this.primaryClassName);
    }

    private void handleTypeReference(JavaType type, SourceElement ref, int offset) {
        if (type.isPrimitive()) {
            return;
        }
        DafNode containingNode = this.findContainingClassNode(ref);
        if (containingNode == null) {
            return;
        }
        String typeName = type.getRawName();
        if (typeName.equals(this.ofClassNodeName)) {
            DafEdge edge = this.graph.getOwningInstance().newDafEdge((CharSequence)"oracle.jdevimpl.daf.java.ReferenceEdgeType");
            edge.setFromNode(containingNode);
            edge.setToNode(this.ofClassNode);
            edge.put((CharSequence)"off.a", (CharSequence)Integer.toString(offset));
            this.refEdges.add(edge);
        }
    }
}

