/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.daf.java;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import oracle.ide.daf.AbstractDafProjectNode;
import oracle.ide.daf.DafJavaProjectNode;
import oracle.ide.daf.DafProjectNode;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.daf.model.DafGraph;
import oracle.javatools.daf.model.DafNode;
import oracle.javatools.daf.model.DafUrlNode;
import oracle.javatools.daf.util.FString;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.JavaModel;
import oracle.jdeveloper.model.JavaProject;
import oracle.ojc.compiler.DepInfo;

public class DafJavaImpl {
    public static final String ROOT_NODE_KEY = "oracle.javatools.daf.java.RootNode";
    public static final String CLASS_PATH = "classpath.attr";
    public static final String SOURCE_PATH = "sourcepath.attr";
    public static final String CDI_FILE_NAME = "cdi_file_name";

    public static DepInfo getDepInfo(DafGraph graph) {
        DafNode rootNode = DafJavaImpl.getDafJavaRootNode(graph);
        if (rootNode == null) {
            return null;
        }
        File cdiFile = DafJavaImpl.getCdiFile(rootNode);
        DepInfo depInfo = DafJavaImpl.readDepInfo(cdiFile);
        if (depInfo != null && !depInfo.hasNameReferences()) {
            return null;
        }
        return depInfo;
    }

    public static DafNode getDafJavaRootNode(DafGraph graph) {
        DafNode rootNode = graph.getRootNode();
        if (rootNode instanceof DafJavaProjectNode || rootNode instanceof DafProjectNode) {
            return rootNode;
        }
        return null;
    }

    public static boolean useCdiInfo(DepInfo depInfo, DafUrlNode urlNode) {
        long urlNodeLastModified = urlNode.isDirty() ? urlNode.getDirtyTimestamp() : urlNode.getTimestamp();
        return DafJavaImpl.useCdiInfo(depInfo, urlNodeLastModified);
    }

    public static boolean useCdiInfo(DepInfo depInfo, URL url) {
        File file = new File(url.getPath());
        return DafJavaImpl.useCdiInfo(depInfo, file.lastModified());
    }

    private static boolean useCdiInfo(DepInfo depInfo, long urlLastModified) {
        boolean useCdi = false;
        if (depInfo != null) {
            long depInfoModified = depInfo.getLastModified();
            useCdi = depInfoModified > 0L && urlLastModified > 0L && depInfoModified >= urlLastModified;
        }
        return useCdi;
    }

    public static JavaModel getJavaManager(DafNode rootNode) {
        if (ROOT_NODE_KEY.equals(rootNode.getString((CharSequence)ROOT_NODE_KEY))) {
            String classPath = rootNode.getString((CharSequence)CLASS_PATH);
            String sourcePath = rootNode.getString((CharSequence)SOURCE_PATH);
            if (classPath != null && sourcePath != null) {
                URLPath urlClassPath = URLPath.newURLPathFromString((String)classPath);
                URLPath urlSourcePath = URLPath.newURLPathFromString((String)sourcePath);
                return JavaModel.getInstance((URLPath)urlSourcePath, (URLPath)urlClassPath);
            }
        } else if (rootNode instanceof AbstractDafProjectNode) {
            AbstractDafProjectNode projectNode = (AbstractDafProjectNode)rootNode;
            Project project = projectNode.getProject();
            if (project == null) {
                return null;
            }
            return JavaManager.getInstance((Project)project);
        }
        return null;
    }

    private static File getCdiFile(DafNode dafRootNode) {
        File cdiFile = null;
        if (ROOT_NODE_KEY.equals(dafRootNode.getString((CharSequence)ROOT_NODE_KEY))) {
            FString cdiFileName = dafRootNode.get((CharSequence)CDI_FILE_NAME);
            if (cdiFileName != null) {
                cdiFile = new File(cdiFileName.toString());
            }
        } else if (dafRootNode instanceof AbstractDafProjectNode) {
            AbstractDafProjectNode dafProjectRootNode = (AbstractDafProjectNode)dafRootNode;
            Project project = dafProjectRootNode.getProject();
            cdiFile = DafJavaImpl.getCdiFileFromProject(project, false);
        }
        if (cdiFile != null && cdiFile.exists()) {
            return cdiFile;
        }
        return null;
    }

    private static File getCdiFileFromProject(Project prj, boolean javac_depinfo) {
        String ext = javac_depinfo ? ".cdi_javac" : ".cdi";
        URL prjURL = prj.getURL();
        URL outURL = JavaProject.getInstance((Project)prj).getOutputDirectory();
        if (outURL != null) {
            String outPathName = new File(outURL.getPath()).getPath();
            String prjPathName = URLFileSystem.getFileName((URL)prjURL);
            return new File(outPathName, DafJavaImpl.replaceExt(prjPathName, ext));
        }
        String prjPathName = URLFileSystem.getPlatformPathName((URL)prjURL);
        return new File(DafJavaImpl.replaceExt(prjPathName, ext));
    }

    private static String replaceExt(String name, String newExt) {
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            lastDot = name.length();
        }
        if (name.indexOf(File.separatorChar, lastDot) < 0) {
            name = name.substring(0, lastDot);
        }
        return name + newExt;
    }

    private static DepInfo readDepInfo(File cdiFile) {
        if (cdiFile == null) {
            return null;
        }
        try {
            DepInfo depInfo = new DepInfo();
            depInfo.read(cdiFile);
            DepInfo depInfo2 = depInfo;
            return depInfo2;
        }
        catch (IOException ex) {
            DepInfo depInfo = null;
            return depInfo;
        }
    }

    public static void getMethodName(JavaMethod oneMethod, StringBuffer buf) {
        if (oneMethod.isConstructor()) {
            JavaClass owningClass = oneMethod.getOwningClass();
            buf.append(owningClass.getName());
        } else {
            buf.append(oneMethod.getName());
        }
        buf.append('(');
        JavaType[] parameterTypes = oneMethod.getParameterTypes();
        boolean emitComma = false;
        int x = 0;
        while (x < parameterTypes.length) {
            if (parameterTypes[x] != null) {
                if (emitComma) {
                    buf.append(", ");
                }
                buf.append(parameterTypes[x].getRawName());
                emitComma = true;
            }
            ++x;
        }
        buf.append(")");
    }
}

