/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.daf.java;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.daf.java.DafJavaImpl;
import oracle.javatools.daf.model.DafEdge;
import oracle.javatools.daf.model.DafGraph;
import oracle.javatools.daf.model.DafNode;
import oracle.javatools.parser.java.v2.internal.symbol.ClassSym;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaField;
import oracle.javatools.parser.java.v2.model.JavaLocalVariable;
import oracle.javatools.parser.java.v2.model.JavaMember;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceEnumConstant;
import oracle.javatools.parser.java.v2.model.SourceFieldVariable;
import oracle.javatools.parser.java.v2.model.SourceFormalParameter;
import oracle.javatools.parser.java.v2.model.SourceHasName;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeParameter;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.doc.SourceDocReference;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceInvokeExpression;
import oracle.javatools.parser.java.v2.util.Usages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DafJavaMemberUsages
extends Usages {
    private DafGraph graph;
    private String primaryClassName;
    private DafNode toMemberNode;
    private String toMemberName;
    private Map<String, DafNode> fromClassNodeMap;
    private Collection<DafEdge> refEdges;

    DafJavaMemberUsages(DafGraph graph, String primaryClassName, DafNode toMemberNode, String toMemberName, Map<String, DafNode> fromClassNodeMap, Collection<DafEdge> refEdges) {
        this.graph = graph;
        this.primaryClassName = primaryClassName;
        this.toMemberNode = toMemberNode;
        this.toMemberName = toMemberName;
        this.fromClassNodeMap = fromClassNodeMap;
        this.refEdges = refEdges;
    }

    public void declareClass(SourceClass s) {
    }

    public void declareConstructor(SourceMethod s) {
    }

    public void declareEnumConstant(SourceEnumConstant s) {
    }

    public void declareField(SourceFieldVariable s) {
    }

    public void declareLocalVariable(SourceLocalVariable s) {
    }

    public void declareMethod(SourceMethod s) {
    }

    public void declareParameter(SourceFormalParameter s) {
    }

    public void declareTypeParameter(SourceTypeParameter s) {
    }

    public void useFieldInDocComment(SourceDocReference s, JavaField field) {
    }

    public void useFieldInExpression(SourceExpression s, JavaField field) {
        int offset = s.getStartOffset();
        if (s instanceof SourceHasName) {
            SourceName sourceName = ((SourceHasName)s).getNameElement();
            offset = sourceName.getStartOffset();
        }
        this.handleFieldReference(field, (SourceElement)s, offset);
    }

    public void useLocalVariableInExpression(SourceExpression s, JavaLocalVariable local) {
    }

    public void useMethodInDocComment(SourceDocReference s, JavaMethod method) {
    }

    public void useMethodInExpression(SourceInvokeExpression s, JavaMethod method) {
        int offset = s.getStartOffset();
        if (s instanceof SourceHasName) {
            SourceName sourceName = ((SourceHasName)s).getNameElement();
            offset = sourceName.getStartOffset();
        }
        this.handleMethodReference(method, (SourceElement)s, offset);
    }

    public void useParameterInDocComment(SourceDocReference s, JavaLocalVariable parameter) {
    }

    public void useParameterInExpression(SourceExpression s, JavaLocalVariable parameter) {
    }

    public void useTypeInAnnotation(SourceAnnotation s, JavaType type) {
    }

    public void useTypeInDocComment(SourceDocReference s, JavaType type) {
    }

    public void useTypeInExpression(SourceExpression s, JavaType type) {
    }

    public void useTypeInClassExtends(SourceTypeReference s, JavaType type) {
    }

    public void useTypeInFieldDecl(SourceTypeReference s, JavaType type) {
    }

    public void useTypeInInstanceof(SourceTypeReference s, JavaType type) {
    }

    public void useTypeInLocalVariableDecl(SourceTypeReference s, JavaType type) {
    }

    public void useTypeInMiscellaneous(SourceTypeReference s, JavaType type) {
    }

    public void useTypeInNarrowImport(SourceImport s, JavaType type) {
    }

    public void useTypeInCreator(SourceTypeReference s, JavaType type) {
    }

    public void useTypeInParameter(SourceTypeReference s, JavaType type) {
    }

    public void useTypeInReturnType(SourceTypeReference s, JavaType type) {
    }

    public void useTypeInThrows(SourceTypeReference s, JavaType type) {
    }

    public void useTypeInTypecast(SourceTypeReference s, JavaType type) {
    }

    private DafNode findContainingClassNode(SourceElement ref) {
        SourceElement element = ref;
        while (element != null) {
            if (element instanceof ClassSym) {
                ClassSym classSym = (ClassSym)element;
                String name = classSym.getVMName().replace('/', '.');
                return this.fromClassNodeMap.get(name);
            }
            element = element.getParent();
        }
        return this.fromClassNodeMap.get(this.primaryClassName);
    }

    private void handleMethodReference(JavaMethod method, SourceElement ref, int offset) {
        if (method.isSynthetic()) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        DafJavaImpl.getMethodName(method, buf);
        this.handleMemberReference(ref, (JavaMember)method, buf.toString(), offset);
    }

    private void handleFieldReference(JavaField field, SourceElement ref, int offset) {
        if (field.isSynthetic()) {
            return;
        }
        this.handleMemberReference(ref, (JavaMember)field, field.getName(), offset);
    }

    private void handleMemberReference(SourceElement ref, JavaMember member, String memberName, int offset) {
        DafNode containingNode = this.findContainingClassNode(ref);
        if (containingNode == null) {
            return;
        }
        JavaClass parentClass = member.getOwningClass();
        StringBuffer buf = new StringBuffer(parentClass.getQualifiedName());
        buf.append('.');
        buf.append(memberName);
        if (this.toMemberName.equals(buf.toString())) {
            DafEdge edge = this.graph.getOwningInstance().newDafEdge((CharSequence)"oracle.jdevimpl.daf.java.ReferenceEdgeType");
            edge.setFromNode(containingNode);
            edge.setToNode(this.toMemberNode);
            edge.put((CharSequence)"off.a", (CharSequence)Integer.toString(offset));
            this.refEdges.add(edge);
        }
    }
}

