/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.daf.java;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import oracle.javatools.daf.java.DafJavaQueriesImpl;
import oracle.javatools.daf.model.DafAttributes;
import oracle.javatools.daf.model.DafEdge;
import oracle.javatools.daf.model.DafGraph;
import oracle.javatools.daf.model.DafItem;
import oracle.javatools.daf.model.DafNode;
import oracle.javatools.daf.model.DafUrlNode;
import oracle.javatools.daf.query.EdgeCriteria;
import oracle.javatools.daf.query.NodeCriteria;
import oracle.javatools.daf.query.SimpleEdgeCriteria;
import oracle.javatools.daf.query.SimpleNodeCriteria;
import oracle.ojc.compiler.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DafJavaQueries {
    public static Collection<DafNode> getPackages(DafGraph graph) {
        return DafJavaQueriesImpl.getNodes(graph, "oracle.jdevimpl.daf.java.PackageNodeType", "pck.a", null);
    }

    public static SimpleNodeCriteria getPackages() {
        return DafJavaQueriesImpl.getNodeCriteria("oracle.jdevimpl.daf.java.PackageNodeType", null, null);
    }

    public static DafNode getPackage(DafGraph graph, String fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        Collection<DafNode> result = DafJavaQueriesImpl.getNodes(graph, "oracle.jdevimpl.daf.java.PackageNodeType", "pck.a", fullyQualifiedName);
        if (result.size() == 1) {
            return result.iterator().next();
        }
        return null;
    }

    public static SimpleNodeCriteria getPackage(String fullyQualifiedName) {
        if (fullyQualifiedName == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        return DafJavaQueriesImpl.getNodeCriteria("oracle.jdevimpl.daf.java.PackageNodeType", "pck.a", fullyQualifiedName);
    }

    public static String getPackageName(DafNode packageNode) {
        if (packageNode == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        if (!DafJavaQueries.isPackageNode(packageNode)) {
            return null;
        }
        return packageNode.getString((CharSequence)"pck.a");
    }

    public static DafNode getPackage(DafGraph graph, DafNode node) {
        if (DafJavaQueries.isPackageNode(node)) {
            return node;
        }
        DafNode classNode = null;
        if (DafJavaQueries.isClassNode((DafAttributes)node)) {
            classNode = node;
        } else if (DafJavaQueries.isMemberNode((DafAttributes)node)) {
            classNode = DafJavaQueries.getClass(graph, node);
        }
        if (classNode != null) {
            SimpleEdgeCriteria criteria = new SimpleEdgeCriteria();
            criteria.setEdgeType((CharSequence)"oracle.jdevimpl.daf.java.ClassPackageEdgeType");
            criteria.setFromNode(classNode);
            Collection result = graph.getEdges((EdgeCriteria)criteria);
            if (result.size() == 1) {
                return ((DafEdge)result.iterator().next()).getToNode();
            }
        }
        return null;
    }

    public static Collection<DafEdge> getClassPackageEdges(DafGraph graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        SimpleEdgeCriteria criteria = new SimpleEdgeCriteria();
        criteria.setEdgeType((CharSequence)"oracle.jdevimpl.daf.java.ClassPackageEdgeType");
        return graph.getEdges((EdgeCriteria)criteria);
    }

    public static Collection<DafNode> getClasses(DafGraph graph) {
        return DafJavaQueriesImpl.getNodes(graph, "oracle.jdevimpl.daf.java.ClassNodeType", "cls.a", null);
    }

    public static SimpleNodeCriteria getClasses() {
        return DafJavaQueriesImpl.getNodeCriteria("oracle.jdevimpl.daf.java.ClassNodeType", null, null);
    }

    public static Collection<DafNode> getClasses(DafGraph graph, DafUrlNode urlNode) {
        if (graph == null || urlNode == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        SimpleNodeCriteria criteria = new SimpleNodeCriteria();
        criteria.setContainingURL(urlNode.getURL());
        criteria.setNodeType((CharSequence)"oracle.jdevimpl.daf.java.ClassNodeType");
        DafNode.requireNonStub((DafItem.DafCriteria)criteria);
        Collection nodes = graph.getNodes((NodeCriteria)criteria);
        return nodes;
    }

    public static Collection<DafNode> getClasses(DafGraph graph, DafNode packageNode) {
        if (graph == null || packageNode == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        SimpleEdgeCriteria criteria = new SimpleEdgeCriteria();
        criteria.setEdgeType((CharSequence)"oracle.jdevimpl.daf.java.ClassPackageEdgeType");
        criteria.setToNode(packageNode);
        Collection edges = graph.getEdges((EdgeCriteria)criteria);
        ArrayList<DafNode> nodes = new ArrayList<DafNode>(edges.size());
        for (DafEdge edge : edges) {
            nodes.add(edge.getFromNode());
        }
        return nodes;
    }

    public static DafNode getClass(DafGraph graph, DafNode memberNode) {
        if (!DafJavaQueries.isMemberNode((DafAttributes)memberNode)) {
            return null;
        }
        return DafJavaQueries.getClass(graph, DafJavaQueries.getClassName((DafAttributes)memberNode));
    }

    public static DafNode getClass(DafGraph graph, String fullyQualifiedClassName) {
        if (fullyQualifiedClassName == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        Collection<DafNode> result = DafJavaQueriesImpl.getNodes(graph, "oracle.jdevimpl.daf.java.ClassNodeType", "cls.a", fullyQualifiedClassName);
        if (result.size() == 1) {
            return result.iterator().next();
        }
        return null;
    }

    public static SimpleNodeCriteria getClass(String fullyQualifiedClassName) {
        if (fullyQualifiedClassName == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        return DafJavaQueriesImpl.getNodeCriteria("oracle.jdevimpl.daf.java.ClassNodeType", "cls.a", fullyQualifiedClassName);
    }

    public static DafNode getSuperClass(DafGraph graph, String fullyQualifiedClassName) {
        if (graph == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        SimpleEdgeCriteria criteria = DafJavaQueries.getSuperClass(fullyQualifiedClassName);
        Collection result = graph.getEdges((EdgeCriteria)criteria);
        if (result.size() == 1) {
            return ((DafEdge)result.iterator().next()).getToNode();
        }
        return null;
    }

    public static SimpleEdgeCriteria getSuperClass(String fullyQualifiedClassName) {
        if (fullyQualifiedClassName == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        SimpleEdgeCriteria criteria = new SimpleEdgeCriteria();
        criteria.setEdgeType((CharSequence)"oracle.jdevimpl.daf.java.ClassSuperEdgeType");
        SimpleNodeCriteria toNodeCriteria = DafJavaQueries.getClass(fullyQualifiedClassName);
        criteria.setFromNode((NodeCriteria)toNodeCriteria);
        return criteria;
    }

    public static Collection<DafNode> getInterfaces(DafGraph graph, String fullyQualifiedClassName) {
        if (graph == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        SimpleEdgeCriteria criteria = DafJavaQueries.getInterfaces(fullyQualifiedClassName);
        Collection result = graph.getEdges((EdgeCriteria)criteria);
        ArrayList<DafNode> interfaceNodes = new ArrayList<DafNode>();
        for (DafEdge interfaceEdge : result) {
            interfaceNodes.add(interfaceEdge.getToNode());
        }
        return interfaceNodes;
    }

    public static SimpleEdgeCriteria getInterfaces(String fullyQualifiedClassName) {
        if (fullyQualifiedClassName == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        SimpleEdgeCriteria criteria = new SimpleEdgeCriteria();
        criteria.setEdgeType((CharSequence)"oracle.jdevimpl.daf.java.ClassInterfaceEdgeType");
        SimpleNodeCriteria toNodeCriteria = DafJavaQueries.getClass(fullyQualifiedClassName);
        criteria.setFromNode((NodeCriteria)toNodeCriteria);
        return criteria;
    }

    public static Collection<DafNode> getInnerClasses(DafGraph graph, String fullyQualifiedClassName) {
        SimpleEdgeCriteria criteria = DafJavaQueries.getInnerClasses(fullyQualifiedClassName);
        Collection edges = graph.getEdges((EdgeCriteria)criteria);
        ArrayList<DafNode> nodes = new ArrayList<DafNode>();
        for (DafEdge edge : edges) {
            nodes.add(edge.getFromNode());
        }
        return nodes;
    }

    public static SimpleEdgeCriteria getInnerClasses(String fullyQualifiedClassName) {
        SimpleEdgeCriteria criteria = new SimpleEdgeCriteria();
        criteria.setEdgeType((CharSequence)"oracle.jdevimpl.daf.java.InnerClassEdgeType");
        SimpleNodeCriteria toNodeCriteria = DafJavaQueries.getClass(fullyQualifiedClassName);
        criteria.setToNode((NodeCriteria)toNodeCriteria);
        return criteria;
    }

    public static Collection<DafNode> getClassMembers(DafGraph graph, String fullyQualifiedClassName) {
        return DafJavaQueriesImpl.getClassMembers(graph, fullyQualifiedClassName);
    }

    public static SimpleNodeCriteria getClassMembers(String fullyQualifiedClassName) {
        return DafJavaQueriesImpl.getClassMembers(fullyQualifiedClassName);
    }

    public static DafNode getClassField(DafGraph graph, String fullyQualifiedClassName, String fieldName) {
        if (graph == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        SimpleNodeCriteria criteria = DafJavaQueries.getClassField(fullyQualifiedClassName, fieldName);
        Collection result = graph.getNodes((NodeCriteria)criteria);
        if (result.size() == 1) {
            return (DafNode)result.iterator().next();
        }
        return null;
    }

    public static SimpleNodeCriteria getClassField(String fullyQualifiedClassName, String fieldName) {
        return DafJavaQueriesImpl.getClassField(fullyQualifiedClassName, fieldName);
    }

    public static DafNode getClassMethod(DafGraph graph, String fullyQualifiedClassName, String methodSignature) {
        if (graph == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        SimpleNodeCriteria criteria = DafJavaQueriesImpl.getClassMethod(fullyQualifiedClassName, methodSignature);
        Collection result = graph.getNodes((NodeCriteria)criteria);
        if (result.size() == 1) {
            return (DafNode)result.iterator().next();
        }
        return null;
    }

    public static DafNode getClassMethod(DafGraph graph, String fullyQualifiedClassName, String methodName, String[] fullyQualifiedArgTypes) {
        if (graph == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        String methodSignature = DafJavaQueries.getMethodSignature(methodName, fullyQualifiedArgTypes);
        SimpleNodeCriteria criteria = DafJavaQueriesImpl.getClassMethod(fullyQualifiedClassName, methodSignature);
        Collection result = graph.getNodes((NodeCriteria)criteria);
        if (result.size() == 1) {
            return (DafNode)result.iterator().next();
        }
        return null;
    }

    public static DafNode getClassMethod(DafGraph graph, String fullyQualifiedClassName, String methodName, String fullyQualifiedReturnType, String[] fullyQualifiedArgTypes) {
        return DafJavaQueries.getClassMethod(graph, fullyQualifiedClassName, methodName, fullyQualifiedArgTypes);
    }

    public static SimpleNodeCriteria getClassMethod(String fullyQualifiedClassName, String methodSignature) {
        return DafJavaQueriesImpl.getClassMethod(fullyQualifiedClassName, methodSignature);
    }

    public static SimpleNodeCriteria getClassMethod(String fullyQualifiedClassName, String methodName, String[] fullyQualifiedArgTypes) {
        String methodSignature = DafJavaQueries.getMethodSignature(methodName, fullyQualifiedArgTypes);
        return DafJavaQueriesImpl.getClassMethod(fullyQualifiedClassName, methodSignature);
    }

    public static SimpleNodeCriteria getClassMethod(String fullyQualifiedClassName, String methodName, String fullyQualifiedReturnType, String[] fullyQualifiedArgTypes) {
        return DafJavaQueries.getClassMethod(fullyQualifiedClassName, methodName, fullyQualifiedArgTypes);
    }

    public static int getDeclarationOffset(DafNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        if (!(DafJavaQueries.isClassNode((DafAttributes)node) || DafJavaQueries.isMemberNode((DafAttributes)node) || DafJavaQueries.isSymbolNode(node))) {
            return -1;
        }
        String offsetString = node.getString((CharSequence)"off.a");
        if (offsetString == null) {
            return -1;
        }
        int offset = -1;
        try {
            offset = Integer.parseInt(offsetString);
        }
        catch (NumberFormatException e) {
            int n = -1;
            return n;
        }
        return offset;
    }

    public static int[] getDeclarationLineColumn(DafNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        if (!DafJavaQueries.isClassNode((DafAttributes)node) && !DafJavaQueries.isMemberNode((DafAttributes)node)) {
            return null;
        }
        String lineColumnString = node.getString((CharSequence)"lcl.a");
        if (lineColumnString == null) {
            return null;
        }
        try {
            int pos = Integer.valueOf(lineColumnString);
            int[] nArray = new int[]{Scanner.positionToLine((int)pos), Scanner.positionToColumn((int)pos) + 1};
            return nArray;
        }
        catch (NumberFormatException ex) {
            int[] nArray = null;
            return nArray;
        }
    }

    public static boolean isDeclarationOffsetBased(DafNode node) {
        if (!(DafJavaQueries.isClassNode((DafAttributes)node) || DafJavaQueries.isMemberNode((DafAttributes)node) || DafJavaQueries.isSymbolNode(node))) {
            return false;
        }
        return node.getString((CharSequence)"off.a") != null;
    }

    public static Collection<DafEdge> getClassReferences(DafGraph graph, DafNode toClassNode) {
        return DafJavaQueriesImpl.getClassReferences(graph, toClassNode);
    }

    public static Collection<DafEdge> getMemberReferences(DafGraph graph, DafNode toMemberNode) {
        return DafJavaQueriesImpl.getMemberReferences(graph, toMemberNode);
    }

    public static String getClassName(DafAttributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        return attributes.getString((CharSequence)"cls.a");
    }

    public static String getMemberName(DafAttributes memberNode, boolean fullyQualified) {
        if (DafJavaQueries.isMemberNode(memberNode)) {
            if (fullyQualified) {
                StringBuffer buf = new StringBuffer();
                buf.append(memberNode.getString((CharSequence)"cls.a"));
                buf.append('.');
                buf.append(memberNode.getString((CharSequence)"mbn.a"));
                return buf.toString();
            }
            return memberNode.getString((CharSequence)"mbn.a");
        }
        return null;
    }

    public static boolean isPackageNode(DafNode packageNode) {
        return "oracle.jdevimpl.daf.java.PackageNodeType".equals(DafJavaQueriesImpl.getNodeType((DafAttributes)packageNode));
    }

    public static boolean isClassNode(DafAttributes classNode) {
        return "oracle.jdevimpl.daf.java.ClassNodeType".equals(DafJavaQueriesImpl.getNodeType(classNode));
    }

    public static boolean isSymbolNode(DafNode symbolNode) {
        String nodeType = DafJavaQueriesImpl.getNodeType((DafAttributes)symbolNode);
        return nodeType != null && "oracle.jdevimpl.daf.java.SymbolNodeType".equals(nodeType);
    }

    public static boolean isMemberNode(DafAttributes memberNode) {
        return DafJavaQueries.isFieldNode(memberNode) || DafJavaQueries.isMethodNode(memberNode);
    }

    public static boolean isFieldNode(DafAttributes fieldNode) {
        String nodeType = DafJavaQueriesImpl.getNodeType(fieldNode);
        return nodeType != null && "oracle.jdevimpl.daf.java.FieldNodeType".equals(nodeType);
    }

    public static boolean isMethodNode(DafAttributes methodNode) {
        String nodeType = DafJavaQueriesImpl.getNodeType(methodNode);
        return nodeType != null && "oracle.jdevimpl.daf.java.MethodNodeType".equals(nodeType);
    }

    public static boolean isReferenceEdge(DafEdge referenceEdge) {
        String type = DafJavaQueriesImpl.getEdgeType(referenceEdge);
        return type != null && type.equals("oracle.jdevimpl.daf.java.ReferenceEdgeType");
    }

    public static boolean isReferenceOffsetBased(DafEdge referenceEdge) {
        if (!DafJavaQueries.isReferenceEdge(referenceEdge)) {
            return false;
        }
        return referenceEdge.getString((CharSequence)"off.a") != null;
    }

    public static int[] getReferenceLineColumn(DafEdge referenceEdge) {
        if (referenceEdge == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        if (!DafJavaQueries.isReferenceEdge(referenceEdge)) {
            return null;
        }
        String value = referenceEdge.getString((CharSequence)"lcl.a");
        if (value != null) {
            try {
                int pos = Integer.valueOf(value);
                int[] nArray = new int[]{Scanner.positionToLine((int)pos), Scanner.positionToColumn((int)pos) + 1};
                return nArray;
            }
            catch (NumberFormatException ex) {
                int[] nArray = null;
                return nArray;
            }
        }
        return null;
    }

    public static int getReferenceOffset(DafEdge referenceEdge) {
        if (referenceEdge == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        if (!DafJavaQueries.isReferenceEdge(referenceEdge)) {
            return -1;
        }
        String value = referenceEdge.getString((CharSequence)"off.a");
        if (value != null) {
            try {
                int n = Integer.valueOf(value);
                return n;
            }
            catch (NumberFormatException ex) {
                int n = -1;
                return n;
            }
        }
        return -1;
    }

    public static DafUrlNode getUrlNode(DafGraph graph, DafNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        if (node instanceof DafUrlNode) {
            return (DafUrlNode)node;
        }
        URL url = node.getContainingURL();
        if (url != null) {
            return DafJavaQueries.getUrlNode(graph, url);
        }
        return null;
    }

    public static DafUrlNode getUrlNode(DafGraph graph, URL url) {
        if (url == null || graph == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        NodeCriteria criteria = DafUrlNode.newURLCriteria((URL)url);
        Collection nodes = graph.getNodes(criteria);
        if (nodes.size() > 0) {
            return (DafUrlNode)((DafNode)nodes.iterator().next());
        }
        return null;
    }

    public static Collection<DafNode> getContainedByURL(DafGraph graph, DafUrlNode urlNode) {
        SimpleNodeCriteria criteria = new SimpleNodeCriteria();
        criteria.setContainingURL(urlNode.getURL());
        DafNode.requireNonStub((DafItem.DafCriteria)criteria);
        Collection nodes = graph.getNodes((NodeCriteria)criteria);
        return nodes;
    }

    public static boolean isDafJavaNode(DafNode node) {
        String type = DafJavaQueriesImpl.getNodeType((DafAttributes)node);
        return type != null && type.startsWith("oracle.jdevimpl.daf.java");
    }

    public static boolean isDafJavaEdge(DafEdge edge) {
        String type = DafJavaQueriesImpl.getEdgeType(edge);
        return type != null && type.startsWith("oracle.jdevimpl.daf.java");
    }

    public static String getMethodSignature(String name, String[] fullyQualifiedArgTypes) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter should not be null");
        }
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        buf.append('(');
        if (fullyQualifiedArgTypes != null) {
            int x = 0;
            while (x < fullyQualifiedArgTypes.length) {
                if (x > 0) {
                    buf.append(", ");
                }
                buf.append(fullyQualifiedArgTypes[x]);
                ++x;
            }
        }
        buf.append(')');
        return buf.toString();
    }

    public static String getMethodSignature(String name, String fullyQualifiedReturnType, String[] fullyQualifiedArgTypes) {
        return DafJavaQueries.getMethodSignature(name, fullyQualifiedArgTypes);
    }
}

