/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.daf.java;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.ide.util.Assert;
import oracle.javatools.daf.java.DafJavaClassUsages;
import oracle.javatools.daf.java.DafJavaImpl;
import oracle.javatools.daf.java.DafJavaMemberUsages;
import oracle.javatools.daf.java.DafJavaQueries;
import oracle.javatools.daf.model.DafAttributes;
import oracle.javatools.daf.model.DafEdge;
import oracle.javatools.daf.model.DafGraph;
import oracle.javatools.daf.model.DafNode;
import oracle.javatools.daf.model.DafUrlNode;
import oracle.javatools.daf.query.EdgeCriteria;
import oracle.javatools.daf.query.NodeCriteria;
import oracle.javatools.daf.query.SimpleEdgeCriteria;
import oracle.javatools.daf.query.SimpleNodeCriteria;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.util.Usages;
import oracle.jdeveloper.java.JavaModel;
import oracle.ojc.compiler.DepClassFileInfo;
import oracle.ojc.compiler.DepInfo;
import oracle.ojc.compiler.DepMemberInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DafJavaQueriesImpl {
    static final String PARAM_NOT_NULL = "Parameter should not be null";
    private static final Collection<DafEdge> EMPTY_EDGE_COLLECTION = Collections.emptyList();

    static SimpleNodeCriteria getNodeCriteria(CharSequence type, CharSequence nameAttribute, String name) {
        SimpleNodeCriteria criteria = new SimpleNodeCriteria();
        criteria.setNodeType(type);
        if (name != null) {
            criteria.put(nameAttribute, (CharSequence)name);
        }
        return criteria;
    }

    static Collection<DafNode> getNodes(DafGraph graph, CharSequence type, CharSequence nameAttribute, String name) {
        if (graph == null) {
            throw new IllegalArgumentException(PARAM_NOT_NULL);
        }
        SimpleNodeCriteria criteria = DafJavaQueriesImpl.getNodeCriteria(type, nameAttribute, name);
        return graph.getNodes((NodeCriteria)criteria);
    }

    static SimpleNodeCriteria getClassMembers(String fullyQualifiedClassName) {
        if (fullyQualifiedClassName == null) {
            throw new IllegalArgumentException(PARAM_NOT_NULL);
        }
        SimpleNodeCriteria criteria = new SimpleNodeCriteria();
        criteria.setNodeType((CharSequence)"oracle.jdevimpl.daf.java.MemberNodeType");
        criteria.putString((CharSequence)"cls.a", fullyQualifiedClassName);
        return criteria;
    }

    static Collection<DafNode> getClassMembers(DafGraph graph, String fullyQualifiedClassName) {
        if (graph == null) {
            throw new IllegalArgumentException(PARAM_NOT_NULL);
        }
        SimpleNodeCriteria criteria = DafJavaQueriesImpl.getClassMembers(fullyQualifiedClassName);
        return graph.getNodes((NodeCriteria)criteria);
    }

    static SimpleNodeCriteria getClassField(String fullyQualifiedClassName, String fieldName) {
        if (fullyQualifiedClassName == null || fieldName == null) {
            throw new IllegalArgumentException(PARAM_NOT_NULL);
        }
        SimpleNodeCriteria criteria = DafJavaQueriesImpl.getNodeCriteria("oracle.jdevimpl.daf.java.FieldNodeType", "mbn.a", fieldName);
        criteria.putString((CharSequence)"cls.a", fullyQualifiedClassName);
        return criteria;
    }

    static DafNode getClassField(DafGraph graph, String fullyQualifiedClassName, String fieldName) {
        if (graph == null) {
            throw new IllegalArgumentException(PARAM_NOT_NULL);
        }
        SimpleNodeCriteria criteria = DafJavaQueriesImpl.getClassField(fullyQualifiedClassName, fieldName);
        Collection nodes = graph.getNodes((NodeCriteria)criteria);
        if (nodes.size() == 1) {
            return (DafNode)nodes.iterator().next();
        }
        return null;
    }

    static DafNode getClassMethod(DafGraph graph, String fullyQualifiedClassName, String methodSignature) {
        if (graph == null) {
            throw new IllegalArgumentException(PARAM_NOT_NULL);
        }
        SimpleNodeCriteria criteria = DafJavaQueriesImpl.getClassMethod(fullyQualifiedClassName, methodSignature);
        Collection nodes = graph.getNodes((NodeCriteria)criteria);
        if (nodes.size() == 1) {
            return (DafNode)nodes.iterator().next();
        }
        return null;
    }

    static SimpleNodeCriteria getClassMethod(String fullyQualifiedClassName, String methodSignature) {
        if (fullyQualifiedClassName == null || methodSignature == null) {
            throw new IllegalArgumentException(PARAM_NOT_NULL);
        }
        SimpleNodeCriteria criteria = DafJavaQueriesImpl.getNodeCriteria("oracle.jdevimpl.daf.java.MethodNodeType", "mbn.a", methodSignature);
        criteria.putString((CharSequence)"cls.a", fullyQualifiedClassName);
        return criteria;
    }

    private static SimpleEdgeCriteria getClassNodeReferences(DafNode classNode) {
        if (classNode == null) {
            throw new IllegalArgumentException(PARAM_NOT_NULL);
        }
        if (!DafJavaQueries.isClassNode((DafAttributes)classNode)) {
            return null;
        }
        SimpleEdgeCriteria criteria = new SimpleEdgeCriteria();
        criteria.setEdgeType((CharSequence)"oracle.jdevimpl.daf.java.ReferenceEdgeType");
        SimpleNodeCriteria toCriteria = SimpleNodeCriteria.criteriaForNode((DafNode)classNode);
        criteria.setToNode((NodeCriteria)toCriteria);
        return criteria;
    }

    static Collection<DafEdge> getClassReferences(DafGraph graph, DafNode classNode) {
        if (graph == null) {
            throw new IllegalArgumentException(PARAM_NOT_NULL);
        }
        if (System.getProperty("dafjava.fullrefs") != null) {
            SimpleEdgeCriteria criteria = new SimpleEdgeCriteria();
            criteria.setEdgeType((CharSequence)"oracle.jdevimpl.daf.java.ReferenceEdgeType");
            SimpleNodeCriteria toCriteria = SimpleNodeCriteria.criteriaForNode((DafNode)classNode);
            criteria.setToNode((NodeCriteria)toCriteria);
            return graph.getEdges((EdgeCriteria)criteria);
        }
        if (System.getProperty("dafjava.norefs") == null) {
            SimpleEdgeCriteria criteria = DafJavaQueriesImpl.getClassNodeReferences(classNode);
            if (criteria == null) {
                return EMPTY_EDGE_COLLECTION;
            }
            Collection edges = graph.getEdges((EdgeCriteria)criteria);
            ArrayList<DafNode> fromClassNodes = new ArrayList<DafNode>();
            for (DafEdge edge : edges) {
                fromClassNodes.add(edge.getFromNode());
            }
            return DafJavaQueriesImpl.getClassOrMemberReferences(graph, classNode, fromClassNodes);
        }
        return EMPTY_EDGE_COLLECTION;
    }

    static Collection<DafEdge> getMemberReferences(DafGraph graph, DafNode toMemberNode) {
        DafNode parentClassNode;
        String parentClassName;
        if (graph == null || toMemberNode == null) {
            throw new IllegalArgumentException(PARAM_NOT_NULL);
        }
        if (System.getProperty("dafjava.fullrefs") != null) {
            SimpleEdgeCriteria criteria = new SimpleEdgeCriteria();
            criteria.setEdgeType((CharSequence)"oracle.jdevimpl.daf.java.ReferenceEdgeType");
            SimpleNodeCriteria toCriteria = SimpleNodeCriteria.criteriaForNode((DafNode)toMemberNode);
            criteria.setToNode((NodeCriteria)toCriteria);
            return graph.getEdges((EdgeCriteria)criteria);
        }
        if (System.getProperty("dafjava.norefs") == null && (parentClassName = DafJavaQueries.getClassName((DafAttributes)toMemberNode)) != null && (parentClassNode = DafJavaQueries.getClass(graph, parentClassName)) != null) {
            SimpleEdgeCriteria criteria = DafJavaQueriesImpl.getClassNodeReferences(parentClassNode);
            Collection edges = graph.getEdges((EdgeCriteria)criteria);
            ArrayList<DafNode> fromClassNodes = new ArrayList<DafNode>();
            for (DafEdge edge : edges) {
                fromClassNodes.add(edge.getFromNode());
            }
            return DafJavaQueriesImpl.getClassOrMemberReferences(graph, toMemberNode, fromClassNodes);
        }
        return EMPTY_EDGE_COLLECTION;
    }

    static String getNodeType(DafAttributes node) {
        if (node != null) {
            return node.getString((CharSequence)DafNode.KEY_NODETYPE);
        }
        return null;
    }

    static String getEdgeType(DafEdge edge) {
        if (edge != null) {
            return edge.getString((CharSequence)DafEdge.KEY_EDGETYPE);
        }
        return null;
    }

    private static Collection<DafEdge> getClassOrMemberReferences(DafGraph graph, DafNode toNode, Collection<DafNode> fromClassNodes) {
        ArrayList<DafEdge> refEdges = new ArrayList<DafEdge>();
        DepInfo depInfo = DafJavaImpl.getDepInfo(graph);
        boolean isClassNode = DafJavaQueries.isClassNode((DafAttributes)toNode);
        String toName = isClassNode ? DafJavaQueries.getClassName((DafAttributes)toNode) : DafJavaQueries.getMemberName((DafAttributes)toNode, true);
        HashMap<String, HashMap<String, DafNode>> jotUrlStrings = new HashMap<String, HashMap<String, DafNode>>();
        HashMap<String, URL> jotUrls = new HashMap<String, URL>();
        for (DafNode fromClassNode : fromClassNodes) {
            DafUrlNode urlNode = DafJavaQueries.getUrlNode(graph, fromClassNode);
            boolean useCdi = DafJavaImpl.useCdiInfo(depInfo, urlNode);
            if (useCdi) {
                if (isClassNode) {
                    DafJavaQueriesImpl.getCdiClassReferences(graph, depInfo, toNode, toName, fromClassNode, refEdges);
                    continue;
                }
                DafJavaQueriesImpl.getCdiMemberReferences(graph, depInfo, toNode, toName, fromClassNode, refEdges);
                continue;
            }
            HashMap<String, DafNode> fromClassNodeMap = (HashMap<String, DafNode>)jotUrlStrings.get(urlNode.getURL().getPath());
            if (fromClassNodeMap == null) {
                URL url = urlNode.getURL();
                fromClassNodeMap = new HashMap<String, DafNode>();
                jotUrlStrings.put(url.getPath(), fromClassNodeMap);
                jotUrls.put(url.getPath(), url);
            }
            String fromClassNodeName = DafJavaQueries.getClassName((DafAttributes)fromClassNode);
            fromClassNodeMap.put(fromClassNodeName, fromClassNode);
        }
        for (String urlPath : jotUrlStrings.keySet()) {
            Map fromNodeMap = (Map)jotUrlStrings.get(urlPath);
            URL url = (URL)jotUrls.get(urlPath);
            if (isClassNode) {
                DafJavaQueriesImpl.getJotClassReferences(graph, toNode, toName, url, fromNodeMap, refEdges);
                continue;
            }
            DafJavaQueriesImpl.getJotMemberReferences(graph, toNode, toName, url, fromNodeMap, refEdges);
        }
        return refEdges;
    }

    private static void getCdiClassReferences(DafGraph graph, DepInfo depInfo, DafNode toClassNode, String toClassNodeName, DafNode fromClassNode, Collection<DafEdge> refEdges) {
        String fromClassNodeName = fromClassNode.getString((CharSequence)"cls.a");
        DepClassFileInfo cfi = depInfo.getDepClassFileInfo(fromClassNodeName);
        Set fromNameRefs = cfi.getNameReferences();
        if (fromNameRefs != null) {
            for (Object fromNameRef : fromNameRefs) {
                int[] refs = (int[])fromNameRef;
                int lookupIndex = refs[0] & 0xFFFFFF;
                if ((refs[0] & 0x10000000) == 0) continue;
                cfi = depInfo.getDepClassFileInfo(lookupIndex);
                Assert.check((cfi != null ? 1 : 0) != 0, (String)"DepClassFileInfo lookup should never fail");
                if (cfi == null || !cfi.getClassName().equals(toClassNodeName)) continue;
                DafEdge edge = graph.getOwningInstance().newDafEdge((CharSequence)"oracle.jdevimpl.daf.java.ReferenceEdgeType");
                edge.setFromNode(fromClassNode);
                edge.setToNode(toClassNode);
                edge.put((CharSequence)"lcl.a", (CharSequence)Integer.toString(refs[1]));
                refEdges.add(edge);
            }
        }
    }

    private static void getCdiMemberReferences(DafGraph graph, DepInfo depInfo, DafNode toMemberNode, String toMemberName, DafNode fromClassNode, Collection<DafEdge> refEdges) {
        String fromClassNodeName = fromClassNode.getString((CharSequence)"cls.a");
        DepClassFileInfo fromCfi = depInfo.getDepClassFileInfo(fromClassNodeName);
        Set fromNameRefs = fromCfi.getNameReferences();
        if (fromNameRefs != null) {
            for (Object fromNameRef : fromNameRefs) {
                int[] refs = (int[])fromNameRef;
                int lookupIndex = refs[0] & 0xFFFFFF;
                if ((refs[0] & 0x10000000) != 0) continue;
                DepMemberInfo dmi = depInfo.getDepMemberInfo(lookupIndex);
                Assert.check((dmi != null ? 1 : 0) != 0, (String)"DepMemberInfo lookup should never fail");
                if (dmi == null || !dmi.getFullName(depInfo).equals(toMemberName)) continue;
                DafEdge edge = graph.getOwningInstance().newDafEdge((CharSequence)"oracle.jdevimpl.daf.java.ReferenceEdgeType");
                edge.setFromNode(fromClassNode);
                edge.setToNode(toMemberNode);
                edge.put((CharSequence)"lcl.a", (CharSequence)Integer.toString(refs[1]));
                refEdges.add(edge);
            }
        }
    }

    private static void getJotClassReferences(DafGraph graph, DafNode toClassNode, String toClassNodeName, URL fromUrl, Map<String, DafNode> fromClassNodeMap, Collection<DafEdge> refEdges) {
        DafNode rootNode = DafJavaImpl.getDafJavaRootNode(graph);
        JavaModel provider = DafJavaImpl.getJavaManager(rootNode);
        if (provider == null) {
            return;
        }
        SourceFile file = provider.getSourceFile(fromUrl);
        if (file == null) {
            return;
        }
        JavaClass primaryClass = file.getPrimaryClass();
        Usages.processUsages((SourceFile)file, (Usages)new DafJavaClassUsages(graph, primaryClass.getVMName().replace('/', '.'), toClassNode, toClassNodeName, fromClassNodeMap, refEdges));
    }

    private static void getJotMemberReferences(DafGraph graph, DafNode toMemberNode, String toMemberName, URL fromUrl, Map<String, DafNode> fromClassNodeMap, Collection<DafEdge> refEdges) {
        DafNode rootNode = DafJavaImpl.getDafJavaRootNode(graph);
        JavaModel provider = DafJavaImpl.getJavaManager(rootNode);
        if (provider == null) {
            return;
        }
        SourceFile file = provider.getSourceFile(fromUrl);
        if (file == null) {
            return;
        }
        JavaClass primaryClass = file.getPrimaryClass();
        Usages.processUsages((SourceFile)file, (Usages)new DafJavaMemberUsages(graph, primaryClass.getVMName().replace('/', '.'), toMemberNode, toMemberName, fromClassNodeMap, refEdges));
    }
}

