/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.util.WindowUtils;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.ide.dialogs.WizardLauncher;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorAPI;
import oracle.jdevimpl.vcs.svn.ui.SSLQueryPanel;
import oracle.jdevimpl.vcs.svn.util.NullPromptListener;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;

public final class SVNClientInteraction {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNClientInteraction.class.getName());
    private static final SVNClientInteraction sInstance = new SVNClientInteraction();
    private static final ISVNPromptUserPassword sNullPrompt = new NullPromptListener();
    private ISVNPromptUserPassword _callback;
    private ISVNClientAdapter _client;

    public static SVNClientInteraction getInstance() {
        return sInstance;
    }

    public void beginInteraction(ISVNClientAdapter client, SVNRepositoryInfo reposInfo) {
        if (!this.isClientInUse()) {
            sLogger.warning("Subversion client is already in use by another thread");
            return;
        }
        this._client = client;
        this._client.addPasswordCallback(this.getCallback(reposInfo));
        SVNUtil.setAuthInfo(this._client, reposInfo);
    }

    public void endInteraction() {
        if (this._client != null) {
            this._client.addPasswordCallback(sNullPrompt);
            SVNUtil.unsetAuthInfo(this._client);
        }
        this._client = null;
    }

    public boolean isClientInUse() {
        return this._client == null;
    }

    private ISVNPromptUserPassword getCallback(SVNRepositoryInfo reposInfo) {
        this._callback = reposInfo != null && reposInfo.getURL().getProtocol().equals("file") ? new FilesPromptListener(null) : new PromptListener(reposInfo);
        return this._callback;
    }

    private SVNClientInteraction() {
    }

    static Logger ra$sLogger() {
        return sLogger;
    }

    private final class PromptListener
    implements ISVNPromptUserPassword {
        private final SVNRepositoryInfo _reposInfo;

        PromptListener(SVNRepositoryInfo reposInfo) {
            this._reposInfo = reposInfo;
        }

        public boolean askYesNo(String realm, String question, boolean yesIsDefault) {
            if (SVNClientInteraction.ra$sLogger().isLoggable(Level.FINEST)) {
                SVNClientInteraction.ra$sLogger().finest("PromptListener.askYesNo: realm=" + realm + " question=" + question + " yesIsDefault=" + yesIsDefault);
            }
            return false;
        }

        public String getUsername() {
            SVNClientInteraction.ra$sLogger().finest("PromptListener.getUsername");
            return this._reposInfo.getAuthInfo().getUserName();
        }

        public String getPassword() {
            SVNClientInteraction.ra$sLogger().finest("PromptListener.getPassword");
            return this._reposInfo.getAuthInfo().getPassword();
        }

        public int askTrustSSLServer(String info, boolean allowPermanently) {
            SSLQueryPanel queryPanel = new SSLQueryPanel(info);
            if (SwingUtilities.isEventDispatchThread()) {
                WizardLauncher.runDialog((JDialog)this.createSSLQueryDialog(queryPanel));
            } else {
                try {
                    SwingUtilities.invokeAndWait(new 1(this, queryPanel));
                }
                catch (InterruptedException ie) {
                    SVNClientInteraction.ra$sLogger().info("interrupted while waiting to show ssl query dialog.");
                    int n = 0;
                    return n;
                }
                catch (InvocationTargetException ite) {
                    Throwable cause = ite.getTargetException();
                    SVNClientInteraction.ra$sLogger().warning("unexpected error while running ssl query dialog (" + cause.getClass().getName() + "): " + cause.getMessage());
                    int n = 0;
                    return n;
                }
            }
            return queryPanel.getPolicy();
        }

        public boolean prompt(String realm, String username, boolean maySave) {
            if (SVNClientInteraction.ra$sLogger().isLoggable(Level.FINEST)) {
                SVNClientInteraction.ra$sLogger().finest("PromptListener.prompt realm=" + realm + " username=" + username + " maySave=" + maySave);
            }
            String[] password = new String[1];
            try {
                SwingUtilities.invokeAndWait(new 2(this, password));
            }
            catch (InterruptedException ie) {
                SVNClientInteraction.ra$sLogger().info("interrupted while prompting for password.");
                boolean bl = false;
                return bl;
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getTargetException();
                SVNClientInteraction.ra$sLogger().warning("unexpected error while running prompting for password (" + cause.getClass().getName() + "): " + cause.getMessage());
                boolean bl = false;
                return bl;
            }
            if (password[0] != null) {
                this._reposInfo.getAuthInfo().setPassword(password[0]);
                SVNRepositoryNavigatorAPI.getInstance().saveRepositoryConnections();
            }
            return password[0] != null;
        }

        public String askQuestion(String realm, String question, boolean showAnswer, boolean maySave) {
            if (SVNClientInteraction.ra$sLogger().isLoggable(Level.FINEST)) {
                SVNClientInteraction.ra$sLogger().finest("PromptListener.askQuestion realm=" + realm + " question=" + question + " showAnswer=" + showAnswer + " maySave=" + maySave);
            }
            return null;
        }

        public boolean userAllowedSave() {
            SVNClientInteraction.ra$sLogger().finest("PromptListener.userAllowedSave");
            return false;
        }

        private JEWTDialog createSSLQueryDialog(SSLQueryPanel queryPanel) {
            ResourcePicker res = ResourcePicker.getPicker(SVNProfile.class);
            JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)VCSWindowUtils.getCurrentWindow(), (Component)queryPanel, (Component)queryPanel.getDefaultComponent(), (String)res.getString("UI_SSLQUERY_DIALOG_TITLE"), (int)5);
            return dialog;
        }

        public boolean promptSSH(String realm, String username, int sshPort, boolean maySave) {
            return false;
        }

        public String getSSHPrivateKeyPath() {
            return null;
        }

        public String getSSHPrivateKeyPassphrase() {
            return null;
        }

        public int getSSHPort() {
            return -1;
        }

        public boolean promptSSL(String string, boolean b) {
            return false;
        }

        public String getSSLClientCertPassword() {
            return null;
        }

        public String getSSLClientCertPath() {
            return null;
        }

        public boolean promptUser(String string, String string1, boolean b) {
            return false;
        }

        static JEWTDialog mav$createSSLQueryDialog(PromptListener promptListener, SSLQueryPanel sSLQueryPanel) {
            return promptListener.createSSLQueryDialog(sSLQueryPanel);
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ SSLQueryPanel v$queryPanel;
            final /* synthetic */ PromptListener this$0;

            public void run() {
                WizardLauncher.runDialog((JDialog)PromptListener.mav$createSSLQueryDialog(this.this$0, this.v$queryPanel));
            }

            public 1(PromptListener promptListener, SSLQueryPanel sSLQueryPanel) {
                this.v$queryPanel = sSLQueryPanel;
                this.this$0 = promptListener;
            }
        }

        final class 2
        implements Runnable {
            private final /* synthetic */ String[] v$password;
            final /* synthetic */ PromptListener this$0;

            public void run() {
                ResourcePicker res = ResourcePicker.getPicker(SVNProfile.class);
                1 dialog = new 1(WindowUtils.getActiveWindow());
                if (dialog.show(res.getString("UI_PASSWORD_DIALOG_TITLE"), res.getString("UI_PASSWORD_PROMPT"), null)) {
                    this.v$password[0] = dialog.getInputValue();
                }
            }

            public 2(PromptListener promptListener, String[] stringArray) {
                this.v$password = stringArray;
                this.this$0 = promptListener;
            }

            final class 1
            extends SimpleInputDialog {
                protected JTextComponent createInputComponent() {
                    return new JPasswordField("", 20);
                }

                protected boolean canOk() {
                    return true;
                }

                public 1(Component component) {
                    super(component);
                }
            }
        }
    }

    private class FilesPromptListener
    implements ISVNPromptUserPassword {
        public boolean askYesNo(String realm, String question, boolean yesIsDefault) {
            return true;
        }

        public String getUsername() {
            return " ";
        }

        public String getPassword() {
            return " ";
        }

        public int askTrustSSLServer(String info, boolean allowPermanently) {
            return 0;
        }

        public boolean prompt(String realm, String username, boolean maySave) {
            return true;
        }

        public boolean promptUser(String realm, String username, boolean maySave) {
            return true;
        }

        public String askQuestion(String realm, String question, boolean showAnswer, boolean maySave) {
            return null;
        }

        public boolean userAllowedSave() {
            return false;
        }

        public boolean promptSSH(String realm, String username, int sshPort, boolean maySave) {
            return false;
        }

        public String getSSHPrivateKeyPath() {
            return null;
        }

        public String getSSHPrivateKeyPassphrase() {
            return null;
        }

        public int getSSHPort() {
            return 0;
        }

        public boolean promptSSL(String realm, boolean maySave) {
            return false;
        }

        public String getSSLClientCertPassword() {
            return null;
        }

        public String getSSLClientCertPath() {
            return null;
        }

        private FilesPromptListener() {
        }

        FilesPromptListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

