/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Level;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdeveloper.vcs.spi.VCSURLFileSystemHelper;
import oracle.jdevimpl.vcs.generic.GenericClient;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class SVNFileProtocolHelper
extends VCSURLFileSystemHelper {
    public SVNFileProtocolHelper() {
        super(URLFileSystem.findHelper((String)"file"), (VCSExtension)((GenericClient)VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion")));
    }

    protected boolean deleteImpl(URL target) {
        VCSProfile profile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
        if (profile == null || !"oracle.jdeveloper.subversion".equals(profile.getID())) {
            return false;
        }
        try {
            if (!profile.getStatusCache().get(target).isVersioned()) {
                boolean bl = super.deleteImpl(target);
                return bl;
            }
            try {
                ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
                SVNOperationLogger.getInstance().beginOperation(client, null);
                client.remove(new File[]{SVNUtil.toFile(target)}, true);
                boolean bl = true;
                return bl;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                SVNOperationLogger.getInstance().endOperation();
            }
        }
        catch (Exception e) {
            profile.getLogger().log(Level.WARNING, "unable to remove " + URLFileSystem.getPlatformPathName((URL)target), e);
            boolean bl = false;
            return bl;
        }
    }

    protected boolean renameToImpl(URL source, URL target) {
        VCSProfile profile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
        if (profile == null || !"oracle.jdeveloper.subversion".equals(profile.getID())) {
            return false;
        }
        if (source.equals(target)) {
            return true;
        }
        if (this.exists(target)) {
            return false;
        }
        URLFilter workingCopyFilter = profile.getURLFilter("oracle.jdeveloper.subversion.filters.url.WORKING_COPY");
        if (!workingCopyFilter.accept(source) || !workingCopyFilter.accept(target)) {
            return false;
        }
        try {
            URL parent = URLFileSystem.getParent((URL)target);
            if (this.exists(parent) && profile.getStatusCache().get(parent).isVersioned()) {
                this.executeMove(source, target, profile);
                boolean bl = true;
                return bl;
            }
            this.ensureTargetDirs(parent, profile);
            this.executeMove(source, target, profile);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            profile.getLogger().log(Level.WARNING, "unable to rename " + URLFileSystem.getPlatformPathName((URL)source) + " to " + URLFileSystem.getPlatformPathName((URL)target), e);
            boolean bl = false;
            return bl;
        }
    }

    private void ensureTargetDirs(URL target, VCSProfile profile) throws Exception {
        URLFilter workingCopyFilter = profile.getURLFilter("oracle.jdeveloper.subversion.filters.url.WORKING_COPY");
        VCSStatusFilter unaddedFilter = profile.getStatusFilter("oracle.jdeveloper.subversion.filter.status.UNADDED");
        File targetDir = SVNUtil.toFile(target);
        targetDir.mkdirs();
        ArrayList<URL> dirs = new ArrayList<URL>(10);
        while (workingCopyFilter.accept(target) && unaddedFilter.accept(profile.getStatusCache().get(target))) {
            dirs.add(target);
            target = URLFileSystem.getParent((URL)target);
        }
        ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
        Collections.reverse(dirs);
        Iterator it = dirs.iterator();
        while (it.hasNext()) {
            try {
                SVNOperationLogger.getInstance().beginOperation(client, null);
                client.addDirectory(SVNUtil.toFile((URL)it.next()), false);
            }
            finally {
                SVNOperationLogger.getInstance().endOperation();
            }
        }
        URL[] created = dirs.toArray(new URL[dirs.size()]);
        profile.getStatusCache().clear(created);
        SVNURLInfoCache.getInstance().clear(created);
    }

    private void executeMove(URL oldUrl, URL newUrl, VCSProfile profile) throws SVNClientException {
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            SVNOperationLogger.getInstance().beginOperation(client, null);
            client.move(SVNUtil.toFile(oldUrl), SVNUtil.toFile(newUrl), true);
        }
        catch (Throwable throwable) {
            SVNOperationLogger.getInstance().endOperation();
            SVNURLInfoCache.getInstance().clear(new URL[]{oldUrl});
            profile.getStatusCache().clear(oldUrl);
            throw throwable;
        }
        SVNOperationLogger.getInstance().endOperation();
        SVNURLInfoCache.getInstance().clear(new URL[]{oldUrl});
        profile.getStatusCache().clear(oldUrl);
    }
}

