/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.awt.Color;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.ide.editor.EditorManager;
import oracle.ide.log.Href;
import oracle.ide.log.StyledMessage;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.progress.DeterminateProgressMonitor;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNMessagePage;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;

public final class SVNOperationLogger {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNOperationLogger.class.getName());
    private static final SVNMessagePage _svnMessagePage = SVNMessagePage.getInstance();
    private static final SVNOperationLogger sInstance = new SVNOperationLogger();
    private final NotifyListener _notifier = new NotifyListener(null);
    private long _opStartTime;
    private ISVNClientAdapter _client;
    private IndeterminateProgressMonitor _indeterminateProgress;
    private DeterminateProgressMonitor _determinateProgress;
    private static Color COMMAND_COLOR = Color.BLACK;
    private static Color MESSAGE_COLOR = new Color(0, 0, 128);
    private static Color ERROR_COLOR = Color.RED;

    public static final SVNOperationLogger getInstance() {
        return sInstance;
    }

    public synchronized void beginOperation(ISVNClientAdapter client, SVNRepositoryInfo reposInfo) {
        if (this._client != null) {
            throw new IllegalStateException();
        }
        SVNClientInteraction.getInstance().beginInteraction(client, reposInfo);
        this._client = client;
        this._indeterminateProgress = null;
        this._determinateProgress = null;
        this._client.addNotifyListener((ISVNNotifyListener)this._notifier);
        this._opStartTime = System.currentTimeMillis();
        this._notifier.logBeginOperation();
    }

    public synchronized void beginOperation(ISVNClientAdapter client, SVNRepositoryInfo reposInfo, IndeterminateProgressMonitor progressMonitor) {
        this.beginOperation(client, reposInfo);
        this._indeterminateProgress = progressMonitor;
    }

    public synchronized void beginOperation(ISVNClientAdapter client, SVNRepositoryInfo reposInfo, DeterminateProgressMonitor progressMonitor) {
        this.beginOperation(client, reposInfo);
        this._determinateProgress = progressMonitor;
    }

    public synchronized void endOperation() {
        if (this._client == null) {
            throw new IllegalStateException();
        }
        long duration = System.currentTimeMillis() - this._opStartTime;
        this._notifier.logEndOperation(duration);
        this._client.removeNotifyListener((ISVNNotifyListener)this._notifier);
        SVNClientInteraction.getInstance().endInteraction();
        this._client = null;
        this._indeterminateProgress = null;
        this._determinateProgress = null;
    }

    private SVNOperationLogger() {
    }

    static IndeterminateProgressMonitor ra$_indeterminateProgress(SVNOperationLogger sVNOperationLogger) {
        return sVNOperationLogger._indeterminateProgress;
    }

    static DeterminateProgressMonitor ra$_determinateProgress(SVNOperationLogger sVNOperationLogger) {
        return sVNOperationLogger._determinateProgress;
    }

    static SVNMessagePage ra$_svnMessagePage() {
        return _svnMessagePage;
    }

    static Color ra$MESSAGE_COLOR() {
        return MESSAGE_COLOR;
    }

    static Logger ra$sLogger() {
        return sLogger;
    }

    static Color ra$ERROR_COLOR() {
        return ERROR_COLOR;
    }

    private final class NotifyListener
    implements ISVNNotifyListener {
        public void logBeginOperation() {
            SVNOperationLogger.ra$sLogger().info("begin svn operation");
        }

        public void logEndOperation(long duration) {
            SVNOperationLogger.ra$sLogger().info("end svn operation, duration: " + duration + "ms");
        }

        public void setCommand(int commandId) {
        }

        public void logCommandLine(String commandLine) {
            this.toMessagePage(commandLine);
            this.toMessagePage("\n");
            SVNOperationLogger.ra$sLogger().info(commandLine);
        }

        public void logMessage(String message) {
            this.toMessagePage("    ");
            this.processHrefAware(message, SVNOperationLogger.ra$MESSAGE_COLOR());
            this.toMessagePage("\n");
            this.toProgressMonitor(message);
            SVNOperationLogger.ra$sLogger().fine(message);
        }

        public void logError(String error) {
            this.toMessagePage("    ");
            this.processHrefAware(error, SVNOperationLogger.ra$ERROR_COLOR());
            this.toMessagePage("\n");
            SVNOperationLogger.ra$sLogger().warning(error);
        }

        public void logRevision(long revision, String path) {
        }

        public void logCompleted(String message) {
            this.toMessagePage("    ");
            this.processHrefAware(message, SVNOperationLogger.ra$MESSAGE_COLOR());
            this.toMessagePage("\n");
            SVNOperationLogger.ra$sLogger().fine(message);
        }

        public void onNotify(File path, SVNNodeKind nodeKind) {
        }

        protected void processHrefAware(String message, Color color) {
            String[] msgSegs = message.split("\\s{1,}");
            int i = 0;
            while (i < msgSegs.length) {
                if (msgSegs[i].indexOf("\\") > -1 || msgSegs[i].indexOf("/") > -1) {
                    try {
                        Href href = this.createHref(msgSegs[i]);
                        this.toMessagePage(href);
                        this.toMessagePage(" ");
                    }
                    catch (MalformedURLException e) {}
                } else {
                    this.toMessagePage(this.formatMessage(msgSegs[i], color));
                    this.toMessagePage(" ");
                }
                ++i;
            }
        }

        private Href createHref(String msg) throws MalformedURLException {
            String hrefMsg = msg.startsWith("'") || msg.startsWith("\"") || msg.startsWith("(") ? msg.substring(1, msg.length() - 2) : msg;
            URL url = new URL("file:" + hrefMsg);
            if (URLFileSystem.isDirectory((URL)url) || !URLFileSystem.exists((URL)url)) {
                return new ConsoleHref(hrefMsg, null);
            }
            return new ConsoleHref(hrefMsg, url);
        }

        private StyledMessage formatMessage(String message, Color color) {
            SimpleAttributeSet attributeSet = new SimpleAttributeSet();
            StyleConstants.setForeground(attributeSet, color);
            return new StyledMessage((AttributeSet)attributeSet, message);
        }

        private void toMessagePage(Object message) {
            SVNOperationLogger.ra$_svnMessagePage().log(message);
        }

        private void toProgressMonitor(String message) {
            if (SVNOperationLogger.ra$_indeterminateProgress(SVNOperationLogger.this) != null) {
                SVNOperationLogger.ra$_indeterminateProgress(SVNOperationLogger.this).getPanel().setNote(message);
            }
            if (SVNOperationLogger.ra$_determinateProgress(SVNOperationLogger.this) != null) {
                SVNOperationLogger.ra$_determinateProgress(SVNOperationLogger.this).getPanel().setNote(message);
            }
        }

        private NotifyListener() {
        }

        NotifyListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class ConsoleHref
    extends Href {
        public ConsoleHref(String text, URL url) {
            super(text, url);
        }

        public void go() {
            EditorManager.getEditorManager().openDefaultEditorInFrame(this.getURL());
        }
    }
}

