/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.spi.VCSPropertyKey;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import oracle.jdevimpl.vcs.svn.util.TimingUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNOverlayProducer
extends VCSOverlayItemProducer
implements ChangeListener {
    private static final ResourcePicker sRes = ResourcePicker.getPicker(SVNProfile.class);
    private static final Icon sUnmodifiedDirIcon = sRes.getImage("OVERLAY_WC_DIR");
    private static final Icon sLocked = sRes.getImage("OVERLAY_LOCKED");
    private static final String TIMING_CTX_PRODUCE = "produce";
    private static final String TIMING_CTX_DECORATE = "decorate";
    private final VCSProfile _profile;
    private final VCSStatusFilter _remoteFilter;
    private final Map _properties;
    ISVNClientAdapter _client;

    private void $init$() {
        this._properties = new HashMap(10);
    }

    public SVNOverlayProducer(VCSStatusCache statusCache) {
        super(statusCache);
        this.$init$();
        this._profile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
        this._remoteFilter = this._profile.getStatusFilter("oracle.jdeveloper.subversion.filter.status.EXISTS_REMOTELY");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(ChangeEvent ce) {
        Map map = this._properties;
        synchronized (map) {
            this._properties.putAll(this._profile.getData("oracle.jdeveloper.vcs.data.COMMON_SETTINGS").getMap());
        }
    }

    protected IconOverlay produceOverlay(URL url, VCSStatus status) throws Exception {
        Map props = this.getProperties();
        boolean useIcons = (Boolean)props.get("useOverlays");
        boolean useLabels = (Boolean)props.get("useLabelDecorations");
        if (!useIcons && !useLabels) {
            return null;
        }
        String timingContext = this.beginTimeOverlay(TIMING_CTX_PRODUCE, url);
        try {
            if (useLabels && this._remoteFilter.accept(status)) {
                IconOverlay iconOverlay = this.getDecoratedOverlay(url, status, props);
                return iconOverlay;
            }
            IconOverlay iconOverlay = new IconOverlay(useIcons ? status.getOverlay().getIcon() : null, null, null);
            return iconOverlay;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.endTimeOverlay(timingContext);
        }
    }

    private IconOverlay getDecoratedOverlay(URL url, VCSStatus status, Map props) throws Exception {
        String timingContext = this.beginTimeOverlay(TIMING_CTX_DECORATE, url);
        boolean useIcons = (Boolean)props.get("useOverlays");
        try {
            String tooltip = this.createTooltip(url, status, props);
            if (this.isLocked(url)) {
                IconOverlay iconOverlay = new IconOverlay(sLocked, this.createLabelDecoration(url, props), tooltip);
                return iconOverlay;
            }
            if (URLFileSystem.isDirectory((URL)url)) {
                boolean unmodified;
                boolean bl = unmodified = status == this._profile.getStatusInstance("UNMODIFIED");
                IconOverlay iconOverlay = new IconOverlay(useIcons ? (unmodified ? sUnmodifiedDirIcon : status.getOverlay().getIcon()) : null, null, tooltip);
                return iconOverlay;
            }
            IconOverlay iconOverlay = new IconOverlay(useIcons ? status.getOverlay().getIcon() : null, this.createLabelDecoration(url, props), tooltip);
            return iconOverlay;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.endTimeOverlay(timingContext);
        }
    }

    private boolean isLocked(URL url) throws SVNClientException {
        this._client = this.getClient();
        ISVNStatus status = this._client.getSingleStatus(SVNUtil.toFile(url));
        return status.getLockOwner() != null;
    }

    private ISVNClientAdapter getClient() throws SVNClientException {
        if (this._client != null) {
            return this._client;
        }
        return SVNUtil.getIDEClientAdapter();
    }

    private String createLabelDecoration(URL url, Map props) throws SVNClientException {
        FastStringBuffer buff = new FastStringBuffer(50);
        Node node = NodeFactory.find((URL)url);
        if (node != null && node instanceof Project) {
            SVNUrl reposUrl = SVNURLInfoCache.getInstance().getURL(url);
            if (reposUrl != null) {
                String hostName = reposUrl.getHost();
                if (hostName == null || hostName.trim().equals("")) {
                    hostName = "localhost";
                }
                buff.append('[').append(hostName).append(']');
            }
        } else {
            long revInt = SVNURLInfoCache.getInstance().getLastChangedRevision(url);
            if (revInt > (long)-1) {
                buff.append(' ').append(String.valueOf(revInt));
            }
        }
        return buff.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String createTooltip(URL url, VCSStatus status, Map props) throws SVNClientException {
        SVNURLInfoCache cache = SVNURLInfoCache.getInstance();
        long revInt = cache.getLastChangedRevision(url);
        if (revInt <= (long)-1) return status.getOverlay().getToolTipText();
        FastStringBuffer buff = new FastStringBuffer(50);
        buff.append("svn: ");
        buff.append(String.valueOf(revInt));
        buff.append(" - ");
        String author = cache.getLastCommitAuthor(url);
        if (author != null) {
            buff.append(author);
            buff.append(" - ");
        }
        if (SVNUtil.isModified(status, this._profile)) {
            boolean propsModified = SVNUtil.isPropertiesModified(url);
            boolean textModified = SVNUtil.isTextModified(url);
            if (propsModified && textModified) {
                buff.append(sRes.getString("TOOLTIP_FRAG_PROPS_TEXT_MODIFIED"));
                return buff.toString();
            } else if (propsModified) {
                buff.append(sRes.getString("TOOLTIP_FRAG_PROPS_MODIFIED"));
                return buff.toString();
            } else {
                if (!textModified) throw new IllegalStateException();
                buff.append(sRes.getString("TOOLTIP_FRAG_TEXT_MODIFIED"));
            }
            return buff.toString();
        } else if (SVNUtil.isConflicted(status, this._profile)) {
            boolean propsConflicted = SVNUtil.isPropertiesConflicted(url);
            boolean textConflicted = SVNUtil.isTextConflicted(url);
            if (propsConflicted && textConflicted) {
                buff.append(sRes.getString("TOOLTIP_FRAG_PROPS_TEXT_CONFLICT"));
                return buff.toString();
            } else if (propsConflicted) {
                buff.append(sRes.getString("TOOLTIP_FRAG_PROPS_CONFLICT"));
                return buff.toString();
            } else {
                if (!textConflicted) throw new IllegalStateException();
                buff.append(sRes.getString("TOOLTIP_FRAG_TEXT_CONFLICT"));
            }
            return buff.toString();
        } else {
            buff.append(status.getOverlay().getToolTipText());
        }
        return buff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getProperties() {
        Map map = this._properties;
        synchronized (map) {
            HashMap<String, Boolean> props = new HashMap<String, Boolean>(10);
            props.putAll(this._properties);
            if (!props.containsKey("useOverlays")) {
                props.put("useOverlays", VCSPropertyKey.DEFAULT_USE_OVERLAYS);
            }
            if (!props.containsKey("useLabelDecorations")) {
                props.put("useLabelDecorations", VCSPropertyKey.DEFAULT_USE_LABEL_DECORATIONS);
            }
            HashMap<String, Boolean> hashMap = props;
            return hashMap;
        }
    }

    private String beginTimeOverlay(String contextOperation, URL url) {
        if (TimingUtil.canTime()) {
            String context = contextOperation + ".{" + URLFileSystem.getPlatformPathName((URL)url) + "}";
            TimingUtil.beginTiming(this.getClass(), context);
            return context;
        }
        return null;
    }

    private void endTimeOverlay(String context) {
        if (context != null) {
            TimingUtil.endTiming(this.getClass(), context);
        }
    }
}

