/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.vcs.properties.PropertiesPanel;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.ui.SVNPropertiesPanelUI;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNPropertiesPanel
extends PropertiesPanel {
    private final URL _url;

    public SVNPropertiesPanel(URL url) {
        this._url = url;
    }

    public Component getComponent() {
        try {
            SVNPropertiesPanelUI ui = new SVNPropertiesPanelUI();
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            this.populateSynchronously(ui, client);
            this.populateAsynchronously(ui, client);
            SVNPropertiesPanelUI sVNPropertiesPanelUI = ui;
            return sVNPropertiesPanelUI;
        }
        catch (SVNClientException ce) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)ce));
            JPanel jPanel = new JPanel();
            return jPanel;
        }
    }

    private void populateSynchronously(SVNPropertiesPanelUI ui, ISVNClientAdapter client) throws SVNClientException {
        SVNURLInfoCache ic = SVNURLInfoCache.getInstance();
        ISVNInfo info = client.getInfoFromWorkingCopy(SVNUtil.toFile(this._url));
        ui.setTextStatus(SVNStatusKind.fromInt((int)ic.getTextStatus(this._url)));
        ui.setPropertyStatus(SVNStatusKind.fromInt((int)ic.getPropStatus(this._url)));
        ui.setRevision(ic.getRevision(this._url));
        ui.setLastChangedRevision(ic.getLastChangedRevision(this._url));
        ui.setLastChangedDate(info.getLastChangedDate());
        ui.setLastCommitAuthor(ic.getLastCommitAuthor(this._url));
        ui.setTextLastChanged(info.getLastDateTextUpdate());
        ui.setPropertiesLastChanged(info.getLastDatePropsUpdate());
        ui.setSchedule(info.getSchedule());
        boolean isCopied = info.isCopied();
        ui.setIsCopied(isCopied);
        if (isCopied) {
            ui.setCopySourceUrl(info.getCopyUrl());
            SVNRevision.Number copyRev = info.getCopyRev();
            ui.setCopySourceRevision(copyRev != null ? copyRev.getNumber() : (long)-1);
        }
    }

    private void populateAsynchronously(SVNPropertiesPanelUI ui, ISVNClientAdapter client) {
        new ReposPropsThread(ui, client, null).start();
    }

    static URL ra$_url(SVNPropertiesPanel sVNPropertiesPanel) {
        return sVNPropertiesPanel._url;
    }

    private final class ReposPropsThread
    extends Thread {
        private final SVNPropertiesPanelUI _ui;
        private final ISVNClientAdapter _client;

        private ReposPropsThread(SVNPropertiesPanelUI ui, ISVNClientAdapter client) {
            this._ui = ui;
            this._client = client;
        }

        public void run() {
            WaitCursor wc = new WaitCursor((Component)this._ui);
            EventQueue.invokeLater(new 1(this, wc));
            try {
                try {
                    SVNUrl svnUrl = SVNURLInfoCache.getInstance().getURL(SVNPropertiesPanel.ra$_url(SVNPropertiesPanel.this));
                    SVNOperationLogger.getInstance().beginOperation(this._client, SVNUtil.resolveRepository(svnUrl));
                    ISVNInfo info = this._client.getInfo(SVNUtil.toFile(SVNPropertiesPanel.ra$_url(SVNPropertiesPanel.this)));
                    SwingUtilities.invokeLater(new 2(this, info));
                }
                catch (SVNClientException ce) {
                    ExceptionDialog.showExceptionDialog((Component)this._ui, (Throwable)ce);
                }
            }
            finally {
                SVNOperationLogger.getInstance().endOperation();
                EventQueue.invokeLater(new 3(this, wc));
            }
        }

        ReposPropsThread(SVNPropertiesPanelUI sVNPropertiesPanelUI, ISVNClientAdapter iSVNClientAdapter, 3 var4_4) {
            this(sVNPropertiesPanelUI, iSVNClientAdapter);
        }

        static SVNPropertiesPanelUI ra$_ui(ReposPropsThread reposPropsThread) {
            return reposPropsThread._ui;
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ WaitCursor v$wc;
            final /* synthetic */ ReposPropsThread this$0;

            public void run() {
                this.v$wc.show();
            }

            public 1(ReposPropsThread reposPropsThread, WaitCursor waitCursor) {
                this.v$wc = waitCursor;
                this.this$0 = reposPropsThread;
            }
        }

        final class 2
        implements Runnable {
            private final /* synthetic */ ISVNInfo v$info;
            final /* synthetic */ ReposPropsThread this$0;

            public void run() {
                ReposPropsThread.ra$_ui(this.this$0).setRepositoryRoot(this.v$info.getRepository());
                ReposPropsThread.ra$_ui(this.this$0).setRepositoryUrl(this.v$info.getUrl());
                ReposPropsThread.ra$_ui(this.this$0).setRepositoryUUID(this.v$info.getUuid());
                try {
                    ReposPropsThread.ra$_ui(this.this$0).setLockOwner(this.v$info.getLockOwner());
                    ReposPropsThread.ra$_ui(this.this$0).setLockCreationDate(this.v$info.getLockCreationDate());
                    ReposPropsThread.ra$_ui(this.this$0).setLockComment(this.v$info.getLockComment());
                }
                catch (NullPointerException npe) {
                    ReposPropsThread.ra$_ui(this.this$0).setLockOwner(null);
                    ReposPropsThread.ra$_ui(this.this$0).setLockCreationDate(null);
                    ReposPropsThread.ra$_ui(this.this$0).setLockComment(null);
                }
            }

            public 2(ReposPropsThread reposPropsThread, ISVNInfo iSVNInfo) {
                this.v$info = iSVNInfo;
                this.this$0 = reposPropsThread;
            }
        }

        final class 3
        implements Runnable {
            private final /* synthetic */ WaitCursor v$wc;
            final /* synthetic */ ReposPropsThread this$0;

            public void run() {
                this.v$wc.hide();
                this.v$wc.dispose();
            }

            public 3(ReposPropsThread reposPropsThread, WaitCursor waitCursor) {
                this.v$wc = waitCursor;
                this.this$0 = reposPropsThread;
            }
        }
    }
}

