/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.jdeveloper.vcs.generic.StatusResolver;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.StatusMapping;
import oracle.jdevimpl.vcs.svn.util.TimingUtil;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public final class SVNStatusResolver
implements StatusResolver {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNStatusResolver.class.getName());
    private static final String TIMING_CTX_STATUS_RESOLUTION = "resolveStatus";
    private VCSStatus _unrecognizedStatus;
    private URLFilter _defaultFilter;
    private URLFilter _wcFilter;
    private URLFilter _adFilter;

    public void populateStatuses(VCSProfile profile, URL[] urls, VCSStatus[] statuses) throws Exception {
        if (this._unrecognizedStatus == null) {
            this._unrecognizedStatus = profile.getStatusInstance("oracle.jdeveloper.vcs.status.UNRECOGNIZED");
        }
        if (this._defaultFilter == null) {
            this._defaultFilter = profile.getURLFilter("oracle.jdeveloper.vcs.filters.url.DEFAULT");
            this._wcFilter = profile.getURLFilter("oracle.jdeveloper.subversion.filters.url.WORKING_COPY");
            this._adFilter = profile.getURLFilter("oracle.jdeveloper.subversion.filters.url.ADMINISTRATIVE");
        }
        SVNURLInfoCache.getInstance().clear(urls);
        int i = 0;
        while (i < urls.length) {
            String timingContext = this.beginTimeResolve(TIMING_CTX_STATUS_RESOLUTION, urls[i]);
            try {
                try {
                    statuses[i] = this.getStatus(profile, urls[i]);
                }
                catch (SVNClientException ce) {
                    sLogger.log(Level.WARNING, "unable to resolve status for " + URLFileSystem.getPlatformPathName((URL)urls[i]), ce);
                    statuses[i] = this._unrecognizedStatus;
                }
            }
            finally {
                this.endTimeResolve(timingContext);
            }
            ++i;
        }
    }

    private VCSStatus getStatus(VCSProfile profile, URL url) throws SVNClientException {
        VCSStatus status;
        block7: {
            if (!this._defaultFilter.accept(url)) {
                return this._unrecognizedStatus;
            }
            boolean administrative = this._adFilter.accept(url);
            if (!this._wcFilter.accept(url) && !administrative) {
                return this._unrecognizedStatus;
            }
            if (administrative) {
                return profile.getStatusInstance("ADMINISTRATIVE");
            }
            status = null;
            try {
                SVNStatusKind propStatus = SVNStatusKind.fromInt((int)SVNURLInfoCache.getInstance().getPropStatus(url));
                if (SVNStatusKind.CONFLICTED.equals((Object)propStatus) || SVNStatusKind.MODIFIED.equals((Object)propStatus)) {
                    status = StatusMapping.getVCSStatus(propStatus);
                } else {
                    SVNStatusKind textStatus = SVNStatusKind.fromInt((int)SVNURLInfoCache.getInstance().getTextStatus(url));
                    status = !URLFileSystem.exists((URL)url) && !SVNStatusKind.DELETED.equals((Object)textStatus) ? this._unrecognizedStatus : StatusMapping.getVCSStatus(textStatus);
                }
            }
            catch (SVNClientException e) {
                VCSStatus parentStatus = this.getStatus(profile, URLFileSystem.getParent((URL)url));
                if (parentStatus.isVersioned()) break block7;
                VCSStatus vCSStatus = parentStatus;
                return vCSStatus;
            }
        }
        return status != null ? status : this._unrecognizedStatus;
    }

    private String beginTimeResolve(String contextOperation, URL url) {
        if (TimingUtil.canTime()) {
            String context = contextOperation + ".{" + URLFileSystem.getPlatformPathName((URL)url) + "}";
            TimingUtil.beginTiming(this.getClass(), context);
            return context;
        }
        return null;
    }

    private void endTimeResolve(String context) {
        if (context != null) {
            TimingUtil.endTiming(this.getClass(), context);
        }
    }
}

