/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNURLInfo;
import oracle.jdevimpl.vcs.svn.mx.InfoCacheMBean;
import oracle.jdevimpl.vcs.svn.util.SVNURLInfoIO;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNURLInfoCache
implements InfoCacheMBean {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNURLInfoCache.class.getName());
    private static final SVNURLInfoCache sInstance = new SVNURLInfoCache();
    private final SVNURLInfoIO _io;
    private final Map _byteCache;
    private final Map _objectCache;
    private final Object _lock;
    private ISVNClientAdapter _explicitClient;

    private void $init$() {
        this._io = new SVNURLInfoIO();
        this._byteCache = new HashMap(100);
        this._objectCache = new LRUCache(null);
        this._lock = new Object();
    }

    public static SVNURLInfoCache getInstance() {
        SVNURLInfoCache.sInstance._explicitClient = null;
        return sInstance;
    }

    public static SVNURLInfoCache getInstance(ISVNClientAdapter client) {
        SVNURLInfoCache.sInstance._explicitClient = client;
        return sInstance;
    }

    public int getTextStatus(URL url) throws SVNClientException {
        return this.getURLInfo(url).getTextStatus();
    }

    public int getPropStatus(URL url) throws SVNClientException {
        return this.getURLInfo(url).getPropStatus();
    }

    public long getRevision(URL url) throws SVNClientException {
        return this.getURLInfo(url).getRevision();
    }

    public long getLastChangedRevision(URL url) throws SVNClientException {
        return this.getURLInfo(url).getLastChangedRevision();
    }

    public String getLastCommitAuthor(URL url) throws SVNClientException {
        return this.getURLInfo(url).getLastCommitAuthor();
    }

    public SVNUrl getURL(URL url) throws SVNClientException {
        return this.getURLInfo(url).getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this._lock;
        synchronized (object) {
            this._objectCache.clear();
            this._byteCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(URL[] urls) {
        if (urls == null) {
            return;
        }
        Object object = this._lock;
        synchronized (object) {
            int i = 0;
            while (i < urls.length) {
                String externalForm = urls[i].toExternalForm();
                this._objectCache.remove(externalForm);
                this._byteCache.remove(externalForm);
                ++i;
            }
        }
    }

    public int getObjectCacheCapacity() {
        return LRUCache.mav$getMaxEntries((LRUCache)this._objectCache);
    }

    public void setObjectCacheCapacity(int capacity) {
        LRUCache.mav$setMaxEntries((LRUCache)this._objectCache, capacity);
    }

    public int getObjectCacheSize() {
        return this._objectCache.size();
    }

    public int getByteCacheSize() {
        return this._byteCache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNURLInfo getURLInfo(URL url) throws SVNClientException {
        String externalForm = url.toExternalForm();
        Object object = this._lock;
        synchronized (object) {
            SVNURLInfo info = (SVNURLInfo)this._objectCache.get(externalForm);
            if (info == null) {
                byte[] bytes = (byte[])this._byteCache.remove(externalForm);
                if (bytes != null) {
                    try {
                        info = this._io.unmarshall(bytes);
                        this._objectCache.put(externalForm, info);
                    }
                    catch (IOException ioe) {
                        sLogger.log(Level.SEVERE, "error byte[]->SVNURLInfo for " + externalForm, ioe);
                        throw new SVNClientException((Throwable)ioe);
                    }
                } else {
                    ISVNClientAdapter client = this.getSVNClient();
                    URL directory = URLFileSystem.isDirectoryPath((URL)url) ? url : URLFileSystem.getParent((URL)url);
                    this.populateFromDirectory(client, directory);
                    info = (SVNURLInfo)this._objectCache.get(externalForm);
                    if (info == null) {
                        info = this.getStatusDirectly(client, url);
                        this._objectCache.put(externalForm, info);
                    }
                }
            }
            SVNURLInfo sVNURLInfo = info;
            return sVNURLInfo;
        }
    }

    private SVNURLInfo getStatusDirectly(ISVNClientAdapter client, URL url) throws SVNClientException {
        return this.toURLInfo(client.getSingleStatus(SVNUtil.toFile(url)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateFromDirectory(ISVNClientAdapter client, URL dir) throws SVNClientException {
        if (URLFileSystem.exists((URL)dir) && !URLFileSystem.isDirectory((URL)dir)) {
            throw new IllegalStateException();
        }
        long start = System.currentTimeMillis();
        ISVNStatus[] statuses = client.getStatus(SVNUtil.toFile(dir), false, true);
        if (sLogger.isLoggable(Level.FINE)) {
            long duration = System.currentTimeMillis() - start;
            sLogger.fine("resolved url info for directory " + URLFileSystem.getPlatformPathName((URL)dir) + " in " + duration + "ms");
        }
        if (statuses != null && statuses.length > 0) {
            Object object = this._lock;
            synchronized (object) {
                int i = 0;
                while (i < statuses.length) {
                    String path = statuses[i].getPath();
                    SVNNodeKind nodeKind = statuses[i].getNodeKind();
                    URL url = this.createURL(path, nodeKind);
                    String externalForm = url.toExternalForm();
                    StringBuffer buff = null;
                    if (sLogger.isLoggable(Level.FINEST)) {
                        if (buff == null) {
                            buff = new StringBuffer(500);
                        }
                        buff.setLength(0);
                        buff.append("cache request: ");
                        String dirExtForm = dir.toExternalForm();
                        buff.append(dirExtForm);
                        buff.append(" (").append(dirExtForm.hashCode()).append(") ");
                        buff.append("cached ").append(externalForm).append(" (");
                        buff.append(externalForm.hashCode()).append(", ");
                        buff.append(nodeKind.toString()).append(")");
                        sLogger.finest(buff.toString());
                    }
                    this._objectCache.put(externalForm, this.toURLInfo(statuses[i]));
                    ++i;
                }
            }
        }
    }

    private SVNURLInfo toURLInfo(ISVNStatus status) {
        SVNRevision.Number workingRevision = status.getRevision();
        SVNRevision.Number changedRevision = status.getLastChangedRevision();
        return new SVNURLInfo(status.getTextStatus().toInt(), status.getPropStatus().toInt(), workingRevision != null ? workingRevision.getNumber() : (long)-1, changedRevision != null ? changedRevision.getNumber() : (long)-1, status.getLastCommitAuthor(), status.getUrl());
    }

    private URL createURL(String path, SVNNodeKind nodeKind) {
        if (SVNNodeKind.DIR.equals((Object)nodeKind)) {
            return URLFactory.newDirURL((String)path);
        }
        if (SVNNodeKind.FILE.equals((Object)nodeKind)) {
            return URLFactory.newFileURL((String)path);
        }
        File file = new File(path);
        return file.isDirectory() ? URLFactory.newDirURL((String)path) : URLFactory.newFileURL((String)path);
    }

    private ISVNClientAdapter getSVNClient() throws SVNClientException {
        if (this._explicitClient == null) {
            return SVNUtil.getIDEClientAdapter();
        }
        return this._explicitClient;
    }

    private SVNURLInfoCache() {
        this.$init$();
    }

    static SVNURLInfoIO ra$_io(SVNURLInfoCache sVNURLInfoCache) {
        return sVNURLInfoCache._io;
    }

    static Object ra$_lock(SVNURLInfoCache sVNURLInfoCache) {
        return sVNURLInfoCache._lock;
    }

    static Map ra$_byteCache(SVNURLInfoCache sVNURLInfoCache) {
        return sVNURLInfoCache._byteCache;
    }

    static Logger ra$sLogger() {
        return sLogger;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class LRUCache
    extends LinkedHashMap {
        private static final int DEFAULT_MAX_ENTRIES = 50;
        private int _maxEntries;

        private LRUCache() {
            super(51, 0.75f, true);
            this._maxEntries = 50;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean removeEldestEntry(Map.Entry entry) {
            if (this.size() > this._maxEntries) {
                try {
                    byte[] bytes = SVNURLInfoCache.ra$_io(SVNURLInfoCache.this).marshall((SVNURLInfo)entry.getValue());
                    Object object = SVNURLInfoCache.ra$_lock(SVNURLInfoCache.this);
                    synchronized (object) {
                        SVNURLInfoCache.ra$_byteCache(SVNURLInfoCache.this).put(entry.getKey(), bytes);
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (IOException ioe) {
                    SVNURLInfoCache.ra$sLogger().log(Level.SEVERE, "error SVNURLInfo->byte[] for " + (String)entry.getKey(), ioe);
                    throw new RuntimeException(ioe);
                }
            }
            return false;
        }

        private int getMaxEntries() {
            return this._maxEntries;
        }

        private void setMaxEntries(int maxEntries) {
            this._maxEntries = maxEntries;
        }

        static void mav$setMaxEntries(LRUCache lRUCache, int n) {
            lRUCache.setMaxEntries(n);
        }

        static int mav$getMaxEntries(LRUCache lRUCache) {
            return lRUCache.getMaxEntries();
        }

        LRUCache(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

