/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.annotation;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.highlight.HighlightLayer;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.highlight.HighlightedText;
import oracle.jdevimpl.vcs.svn.annotation.AnnotationMark;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;

public class AnnotationComponent
extends JComponent
implements MouseListener,
MouseMotionListener {
    private int _width;
    private int _height;
    private Color _fg;
    private Color _bg;
    private BasicEditorPane _pane;
    private Font _font;
    private int _fontHeight;
    private int _fontAscent;
    private ISVNAnnotations _annotations;
    private Collection _annotationMarkSet;
    private AnnotationMark _mouseOverMark;
    private AnnotationMark _preClickedMark;
    private HighlightRegistry _hlRegistry;
    private HighlightStyle _hlStyle;
    private HighlightLayer _hlLayer;

    public AnnotationComponent(int width, int height, Color fg, Color bg, BasicEditorPane pane) {
        this._width = width;
        this._height = height;
        this._fg = fg;
        this._bg = bg;
        this._pane = pane;
        this.setMinimumSize(new Dimension(width, height));
        this.setMaximumSize(new Dimension(width, height));
        this.setPreferredSize(new Dimension(width, width));
        this.setOpaque(true);
        this.setForeground(fg);
        this.setBackground(bg);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
        toolTipManager.setInitialDelay(0);
        toolTipManager.setDismissDelay(10000);
        toolTipManager.setReshowDelay(0);
        this.registerMouseListener();
        this._hlRegistry = this._pane.getHighlightRegistry();
        this._hlStyle = this._hlRegistry.createStyle("annotation-highlight", "ANNOTATION-HIGHLIGHT", 100, Color.BLACK, AnnotationMark.BASECOLOR);
        this._hlLayer = this._pane.createHighlightLayer();
    }

    public void registerMouseListener() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void deregisterMouseListener() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
    }

    public void setAnnotations(ISVNAnnotations annotations, Collection annotationMarkSet) {
        this._annotations = annotations;
        this._annotationMarkSet = annotationMarkSet;
    }

    public void paint(Graphics g) {
        g.clearRect(0, 0, this._width, this._height);
        this.updateLineHeight();
        this.drawAnnotations(g);
        this.drawHoveredAnnotation(g);
    }

    public void updateLineHeight() {
        Font currentFont = this._pane.getFont();
        if (this._font == null || currentFont != this._font) {
            this._font = currentFont;
            FontMetrics metrics = this.getFontMetrics(currentFont);
            this._fontHeight = metrics.getHeight();
            this._fontAscent = metrics.getAscent();
        }
    }

    public String getToolTipText(MouseEvent event) {
        if (this._mouseOverMark == null) {
            return null;
        }
        return this._mouseOverMark.toString();
    }

    public void drawAnnotations(Graphics g) {
        if (this._annotationMarkSet == null || this._annotations == null) {
            return;
        }
        for (AnnotationMark mark : this._annotationMarkSet) {
            this.drawAnnotationMark(g, mark);
        }
    }

    public void drawAnnotationMark(Graphics g, AnnotationMark mark) {
        Collection<int[]> scopePairSet = mark.getScopePairSet();
        for (int[] block : scopePairSet) {
            this.drawBlock(g, block[0], block[1], mark.getColor());
            this.drawSeperator(g, block[0], block[1], AnnotationMark.SEPERATORCOLOR);
        }
    }

    protected void drawBlock(Graphics g, int blockBeginLine, int blockEndLine, Color color) {
        g.setColor(color);
        int topX = 0;
        int topY = blockBeginLine * this._fontHeight;
        int width = this._width + 1;
        int height = this._fontHeight * (blockEndLine - blockBeginLine + 1);
        g.fillRect(topX, topY, width, height);
    }

    protected void drawSeperator(Graphics g, int blockBeginLine, int blockEndLine, Color color) {
        g.setColor(color);
        int width = this._width;
        int topX = 0;
        int topY = blockBeginLine * this._fontHeight;
        g.drawLine(topX, topY, topX + width, topY);
        int bottomX = 0;
        int bottomY = (blockEndLine + 1) * this._fontHeight;
        g.drawLine(bottomX, bottomY, topX + width, bottomY);
    }

    public void drawHoveredAnnotation(Graphics g) {
        if (this._mouseOverMark == null) {
            return;
        }
        this.drawAnnotationBorders(g, this._mouseOverMark);
    }

    public void drawAnnotationBorders(Graphics g, AnnotationMark mark) {
        Collection<int[]> scopePairSet = mark.getScopePairSet();
        for (int[] block : scopePairSet) {
            this.drawBorder(g, block[0], block[1], AnnotationMark.BORDERCOLOR);
        }
    }

    protected void drawBorder(Graphics g, int blockBeginLine, int blockEndLine, Color color) {
        g.setColor(color);
        int topX = 0;
        int topY = blockBeginLine * this._fontHeight;
        int width = this._width;
        int height = this._fontHeight * (blockEndLine - blockBeginLine + 1);
        g.drawRect(topX, topY, width, height);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.hightlightCodeinEditor();
        }
        this.getToolTipText(e);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.updateMouseInMark(e);
    }

    public void mouseExited(MouseEvent e) {
        this.updateMouseInMark(e);
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        this.updateMouseInMark(e);
    }

    protected void updateMouseInMark(MouseEvent event) {
        if (event != null) {
            int x = event.getX();
            int y = event.getY();
            int id = event.getID();
            switch (id) {
                case 505: {
                    this._mouseOverMark = null;
                    break;
                }
                case 503: 
                case 504: {
                    this._mouseOverMark = this.getMarkUnderMouse(x, y);
                    break;
                }
            }
            this.getToolTipText(event);
        } else {
            this._mouseOverMark = null;
        }
        this.repaint();
    }

    public void hightlightCodeinEditor() {
        this.removeAllHighlights();
        if (this._mouseOverMark == null || this._preClickedMark == this._mouseOverMark) {
            this._preClickedMark = null;
            return;
        }
        Set<Integer> scope = this._mouseOverMark.getScopeSet();
        for (Integer line : scope) {
            HighlightedText highlightedText = this._hlLayer.addLineHighlight(this._hlStyle, line.intValue());
        }
        this._preClickedMark = this._mouseOverMark;
    }

    public void removeAllHighlights() {
        this._hlLayer.removeAllHighlights();
    }

    protected AnnotationMark getMarkUnderMouse(int x, int y) {
        int line = this.getLineFromCoordinates(x, y);
        if (line > this._annotations.numberOfLines()) {
            return null;
        }
        for (AnnotationMark mark : this._annotationMarkSet) {
            if (!mark.inScope(line)) continue;
            return mark;
        }
        return null;
    }

    protected int getLineFromCoordinates(int x, int y) {
        return Math.round(y / this._fontHeight);
    }
}

