/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.annotation;

import java.awt.Color;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.jdevimpl.vcs.svn.annotation.AnnotationComponent;
import oracle.jdevimpl.vcs.svn.annotation.AnnotationMark;
import oracle.jdevimpl.vcs.svn.annotation.AnnotationView;
import oracle.jdevimpl.vcs.svn.op.SVNOperationViewAnnotation;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class AnnotationController
implements Controller {
    private AnnotationComponent _component;

    public AnnotationController(AnnotationComponent component) {
        this._component = component;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == AnnotationView.SVN_ANNOTATION_REFRESH_CMDID) {
            this.refresh();
            return true;
        }
        if (cmdId == AnnotationView.SVN_ANNOTATION_CLOSE_CMDID) {
            SVNOperationViewAnnotation.removeExistedPlugin();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        return true;
    }

    public void refresh() {
        this.refresh(this.getAnnotations());
    }

    public void refresh(ISVNAnnotations annotations) {
        if (annotations != null) {
            this._component.setAnnotations(annotations, this.getAnnotationMarkSet(annotations));
            this._component.repaint();
        }
    }

    public Collection getAnnotationMarkSet(ISVNAnnotations annotations) {
        LinkedHashSet<AnnotationMark> annotationMarkSet = new LinkedHashSet<AnnotationMark>();
        int totalLines = annotations.numberOfLines();
        int i = 0;
        while (i < totalLines) {
            AnnotationMark mark = new AnnotationMark(i, annotations.getAuthor(i), (int)annotations.getRevision(i), annotations.getChanged(i));
            if (!annotationMarkSet.contains(mark)) {
                int j = i == totalLines ? i : i + 1;
                while (j < totalLines) {
                    if (annotations.getRevision(i) == annotations.getRevision(j)) {
                        mark.addLineToScope(j);
                    }
                    ++j;
                }
                mark.createScopePairSet();
                annotationMarkSet.add(mark);
            }
            ++i;
        }
        this.setAnnotationMarkColors(annotationMarkSet);
        return annotationMarkSet;
    }

    public void setAnnotationMarkColors(Set annotationMarkSet) {
        Color color = AnnotationMark.BASECOLOR;
        for (AnnotationMark mark : annotationMarkSet) {
            mark.setColor(color);
            color = new Color(color.getRGB() - 20);
        }
    }

    public ISVNAnnotations getAnnotations() {
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        File file = SVNUtil.toFile(editor.getContext().getNode().getURL());
        if (file == null) {
            return null;
        }
        return this.getAnnotations(file);
    }

    private ISVNAnnotations getAnnotations(File file) {
        try {
            ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
            ISVNAnnotations iSVNAnnotations = client.annotate(file, SVNRevision.START, SVNRevision.BASE);
            return iSVNAnnotations;
        }
        catch (SVNClientException e) {
            ISVNAnnotations iSVNAnnotations = null;
            return iSVNAnnotations;
        }
    }
}

