/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.annotation;

import java.awt.Color;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMark {
    public static Color BASECOLOR = Color.CYAN;
    public static Color SEPERATORCOLOR = Color.BLACK;
    public static Color BORDERCOLOR = Color.YELLOW;
    private LinkedHashSet<Integer> _scopeSet;
    private String _author;
    private int _revision;
    private Date _date;
    private Color _markColor;
    private HashSet<int[]> _scopePairSet;

    public AnnotationMark(int line, String author, int revision, Date date) {
        this._scopeSet = new LinkedHashSet();
        this._scopeSet.add(new Integer(line));
        this._author = author;
        this._revision = revision;
        this._date = date;
    }

    public AnnotationMark(LinkedHashSet<Integer> scopeSet, String author, int revision, Date date) {
        this._scopeSet = scopeSet;
        this._author = author;
        this._revision = revision;
        this._date = date;
    }

    public void addLineToScope(int line) {
        this._scopeSet.add(new Integer(line));
    }

    public boolean inScope(int line) {
        return this._scopeSet.contains(new Integer(line));
    }

    public void createScopePairSet() {
        if (this._scopeSet == null) {
            return;
        }
        this._scopePairSet = new HashSet();
        int previousLine = -1;
        int beginBlockLine = 1;
        int line = 1;
        Iterator it = this._scopeSet.iterator();
        while (it.hasNext()) {
            line = (Integer)it.next();
            if (previousLine == -1) {
                beginBlockLine = line;
                previousLine = line;
            }
            if (this.beginOfBlock(previousLine, line)) {
                this._scopePairSet.add(this.createBlock(beginBlockLine, previousLine));
                beginBlockLine = line;
            }
            if (!it.hasNext()) {
                this._scopePairSet.add(this.createBlock(beginBlockLine, line));
            }
            previousLine = line;
        }
    }

    private boolean beginOfBlock(int previousLine, int line) {
        return Math.abs(previousLine - line) > 1;
    }

    private int[] createBlock(int beginBlockLine, int endBlockLine) {
        int[] newBlock = new int[]{beginBlockLine, endBlockLine};
        return newBlock;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AnnotationMark)) {
            return false;
        }
        return this._revision == ((AnnotationMark)o).getRevsion();
    }

    public int hashCode() {
        return this._revision;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._revision);
        sb.append(" ");
        sb.append(this._author);
        sb.append(" ");
        sb.append(this._date.toString());
        return sb.toString();
    }

    public int getRevsion() {
        return this._revision;
    }

    public Set<Integer> getScopeSet() {
        return this._scopeSet;
    }

    public void setColor(Color markColor) {
        this._markColor = markColor;
    }

    public Color getColor() {
        return this._markColor;
    }

    public Collection<int[]> getScopePairSet() {
        return this._scopePairSet;
    }
}

