/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.annotation;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.layout.ViewId;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.jdevimpl.vcs.svn.annotation.AnnotationComponent;
import oracle.jdevimpl.vcs.svn.annotation.AnnotationController;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;

public class AnnotationView
extends View
implements EditorPlugin,
ContextMenuListener {
    public static final String VIEW_NAME = "SVNAnnotationView";
    public static final ViewId VIEW_ID = new ViewId("SVNAnnotationView");
    public static int PLUGINWIDTH = 10;
    public static String SVN_ANNOTATION_REFRESH_CMD = "SVN_ANNOTATION_REFRESH_CMD";
    public static int SVN_ANNOTATION_REFRESH_CMDID = Ide.findOrCreateCmdID((String)SVN_ANNOTATION_REFRESH_CMD);
    public static String SVN_ANNOTATION_CLOSE_CMD = "SVN_ANNOTATION_CLOSE_CMD";
    public static int SVN_ANNOTATION_CLOSE_CMDID = Ide.findOrCreateCmdID((String)SVN_ANNOTATION_CLOSE_CMD);
    private BasicEditorPane _pane;
    private AnnotationComponent _component;
    private AnnotationController _controller;
    private ContextMenu _contextMenu;
    private PropMouseListener _mouseListener;
    private int _componentWidth;
    private int _componentHeight;
    private Color _fg;
    private Color _bg;
    private ISVNAnnotations _annotations;
    private IdeAction _refreshAction;
    private IdeAction _closeAction;

    public AnnotationView() {
        super(VIEW_ID.getId());
    }

    public AnnotationView(ISVNAnnotations annotations) {
        super(VIEW_ID.getId());
        this._annotations = annotations;
    }

    private void registerMouseListener() {
        this._mouseListener = new PropMouseListener(null);
        this.getGUI().addMouseListener(this._mouseListener);
    }

    private void deregisterMouseListener() {
        this.getGUI().removeMouseListener(this._mouseListener);
    }

    public Component getGUI() {
        if (this._component == null) {
            this._component = new AnnotationComponent(this._componentWidth, this._componentHeight, this._fg, this._bg, this._pane);
        }
        return this._component;
    }

    public Controller getController() {
        if (this._controller == null) {
            this._controller = new AnnotationController(this._component);
        }
        return this._controller;
    }

    public final ContextMenu getContextMenu() {
        if (this._contextMenu == null) {
            this._contextMenu = new ContextMenu();
            this._contextMenu.addContextMenuListener((ContextMenuListener)this);
        }
        return this._contextMenu;
    }

    public void install(BasicEditorPane editor) {
        this._pane = editor;
        this._componentWidth = PLUGINWIDTH;
        this._componentHeight = this._pane.getHeight();
        this._fg = (Color)this._pane.getProperty("right-margin-color");
        this._bg = this._pane.getBackground();
        this.registerMouseListener();
        ((AnnotationController)this.getController()).refresh();
    }

    public void deinstall(BasicEditorPane editor) {
        this.deregisterMouseListener();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this._component != null) {
            this._component.repaint();
        }
    }

    public void menuWillShow(ContextMenu contextMenu) {
        this.addMenuItems(contextMenu);
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void addMenuItems(ContextMenu contextMenu) {
        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getRefreshAction()));
        contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)this.getCloseAction()));
    }

    private IdeAction getRefreshAction() {
        if (this._refreshAction == null) {
            this._refreshAction = IdeAction.get((int)SVN_ANNOTATION_REFRESH_CMDID);
            this._refreshAction.setName("Refresh");
            this._refreshAction.addController((Controller)this._controller);
        }
        return this._refreshAction;
    }

    private IdeAction getCloseAction() {
        if (this._closeAction == null) {
            this._closeAction = IdeAction.get((int)SVN_ANNOTATION_CLOSE_CMDID);
            this._closeAction.setName("Close");
            this._closeAction.addController((Controller)this._controller);
        }
        return this._closeAction;
    }

    private final class PropMouseListener
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                AnnotationView.this.getContextMenu().show(AnnotationView.this.getContext(e));
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                AnnotationView.this.getContextMenu().show(AnnotationView.this.getContext(e));
            }
        }

        private PropMouseListener() {
        }

        PropMouseListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

