/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.changelist;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import oracle.ide.docking.DockStation;
import oracle.ide.layout.ViewId;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEvent;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSThreadPool;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdevimpl.vcs.generic.changelist.ChangeListViewId;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.changelist.SVNIncomingChangeList;
import oracle.jdevimpl.vcs.svn.changelist.SVNIncomingEventQueue;
import oracle.jdevimpl.vcs.svn.changelist.SVNRemoteStatus;
import oracle.jdevimpl.vcs.svn.changelist.SVNRemoteStatusCache;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNUrlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SVNIncomingChangesTask
extends TimerTask {
    private final SVNIncomingChangeList _changeList;
    private final SVNIncomingEventQueue _eventQueue;
    private final SVNRemoteStatusCache _statusCache;
    private final VCSThreadPool _threadPool;

    public SVNIncomingChangesTask(SVNIncomingChangeList changeList, VCSThreadPool threadPool) {
        this._changeList = changeList;
        this._eventQueue = (SVNIncomingEventQueue)this._changeList.getEventQueue();
        this._statusCache = (SVNRemoteStatusCache)this._changeList.getStatusCache();
        this._threadPool = threadPool;
    }

    @Override
    public void run() {
        if (this._eventQueue == null || this._changeList == null || this._eventQueue.isTaskInProgress() || this._changeList.isBusy() || !this.isChangeListVisible() || SVNClientInteraction.getInstance().isClientInUse()) {
            return;
        }
        this.setChangeListBusy(true);
        try {
            HashSet workingCopies = new HashSet(10);
            Project[] projects = VCSModelUtils.findCachedProjects();
            int i = 0;
            while (i < projects.length && projects[i].isOpen()) {
                workingCopies.addAll(this.resolveWorkingCopyRoots(projects[i]));
                ++i;
            }
            HashMap cache = new HashMap(100);
            Iterator it = workingCopies.iterator();
            while (it.hasNext()) {
                try {
                    try {
                        URL workingCopyRoot = URLFileSystem.canonicalize((URL)((URL)it.next()));
                        ISVNClientAdapter client = this.getClient();
                        ISVNInfo wcInfo = null;
                        try {
                            wcInfo = client.getInfoFromWorkingCopy(SVNUtil.toFile(workingCopyRoot));
                        }
                        catch (SVNClientException ce) {
                            // empty catch block
                        }
                        if (wcInfo == null || wcInfo.getRepository() == null) continue;
                        SVNRepositoryInfo repoInfo = SVNRepositoryManager.getInstance().get(wcInfo.getRepository().toString());
                        SVNClientInteraction.getInstance().beginInteraction(client, repoInfo);
                        ISVNStatus[] statuses = client.getStatus(SVNUtil.toFile(workingCopyRoot), true, true, true);
                        this.cacheRelevantStatuses(workingCopyRoot, statuses, cache);
                    }
                    catch (SVNClientException ce) {
                        ce.printStackTrace();
                    }
                }
                finally {
                    if (!SVNClientInteraction.getInstance().isClientInUse()) {
                        SVNClientInteraction.getInstance().endInteraction();
                    }
                }
            }
            LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
            urls.addAll(Arrays.asList(this._statusCache.searchValues(VCSURLFilters.createNullFilter())));
            urls.addAll(cache.keySet());
            this._statusCache.setInternalCache(cache);
            ChangeListEvent event = new ChangeListEvent(0);
            event.setURLs(urls.toArray(new URL[urls.size()]));
            event.setUpdate(true);
            this._eventQueue.enqueue(event);
        }
        finally {
            this.setChangeListBusy(false);
        }
    }

    private ISVNClientAdapter getClient() throws SVNClientException {
        return SVNUtil.getClientAdapter(SVNProfile.IDE_CLIENT_CONTEXT_ID, SVNProfile.IC_ADAPTER_CONTEXT_ID);
    }

    private void cacheRelevantStatuses(URL localRoot, ISVNStatus[] statuses, Map cache) throws SVNClientException {
        SVNUrl wcReposUrl = SVNURLInfoCache.getInstance().getURL(localRoot);
        if (wcReposUrl == null) {
            return;
        }
        int i = 0;
        while (i < statuses.length) {
            SVNStatusKind textStatus = statuses[i].getRepositoryTextStatus();
            SVNStatusKind propStatus = statuses[i].getRepositoryPropStatus();
            if (SVNStatusKind.MODIFIED.equals((Object)textStatus) && SVNStatusKind.MODIFIED.equals((Object)propStatus)) {
                cache.put(this.getVirtualUrl(localRoot, wcReposUrl, statuses[i].getUrl()), SVNRemoteStatus.TEXT_PROP_MODIFIED);
            } else if (SVNStatusKind.MODIFIED.equals((Object)textStatus)) {
                cache.put(this.getVirtualUrl(localRoot, wcReposUrl, statuses[i].getUrl()), SVNRemoteStatus.TEXT_MODIFIED);
            } else if (SVNStatusKind.MODIFIED.equals((Object)propStatus)) {
                cache.put(this.getVirtualUrl(localRoot, wcReposUrl, statuses[i].getUrl()), SVNRemoteStatus.PROP_MODIFIED);
            } else if (SVNStatusKind.ADDED.equals((Object)textStatus)) {
                cache.put(this.getVirtualUrl(localRoot, wcReposUrl, statuses[i].getUrl()), SVNRemoteStatus.ADDED);
            } else if (SVNStatusKind.DELETED.equals((Object)textStatus)) {
                cache.put(this.getVirtualUrl(localRoot, wcReposUrl, statuses[i].getUrl()), SVNRemoteStatus.DELETED);
            }
            ++i;
        }
    }

    private URL getVirtualUrl(URL localBase, SVNUrl reposBase, SVNUrl item) {
        String rel = SVNUrlUtils.getRelativePath((SVNUrl)reposBase, (SVNUrl)item);
        return URLFileSystem.canonicalize((URL)URLFactory.newURL((URL)localBase, (String)rel.replace('/', File.separatorChar)));
    }

    private Collection resolveWorkingCopyRoots(Project project) {
        HashSet<URL> roots = new HashSet<URL>(10);
        URL root = SVNUtil.resolveWorkingCopy(project.getURL());
        if (root != null) {
            roots.add(root);
        }
        Collection contentPaths = this.getContentRoots(project);
        Iterator it = contentPaths.iterator();
        while (it.hasNext()) {
            roots.add((URL)it.next());
        }
        return roots;
    }

    private Collection getContentRoots(Project project) {
        ContentSet[] allContents = new ContentSet[1];
        if (SwingUtilities.isEventDispatchThread()) {
            allContents[0] = ProjectContent.getInstance((PropertyStorage)project).getAllContents();
        } else {
            try {
                SwingUtilities.invokeAndWait(new 1(this, allContents, project));
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                List list = Collections.EMPTY_LIST;
                return list;
            }
            catch (InvocationTargetException ite) {
                ite.getTargetException().printStackTrace();
                List list = Collections.EMPTY_LIST;
                return list;
            }
        }
        return allContents[0].getAllRootDirs().asList();
    }

    private void setChangeListBusy(boolean busy) {
        ChangeListEvent cle = new ChangeListEvent(2);
        cle.setRunnable((Runnable)new 2(this, busy));
        this._eventQueue.enqueue(cle);
        this._eventQueue.setTaskInProgress(busy);
    }

    protected void populateStatusCacheMap(Map<URL, Object> statusCacheMap, Collection<URL> directoriesToQuery) {
    }

    protected boolean isControlled(URL directoryUrl) {
        return false;
    }

    protected String getViewId() {
        VCSProfile _profile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
        return ViewId.validate((String)ChangeListViewId.getViewId((VCSProfile)_profile));
    }

    protected boolean isChangeListVisible() {
        ChangeListWindow clw = this.getChangeListWindow();
        return clw.isChangeListVisible((ChangeList)this._changeList);
    }

    public final ChangeListWindow getChangeListWindow() {
        return (ChangeListWindow)DockStation.getDockStation().getDockable(new ViewId(this.getViewId()));
    }

    static SVNIncomingEventQueue ra$_eventQueue(SVNIncomingChangesTask sVNIncomingChangesTask) {
        return sVNIncomingChangesTask._eventQueue;
    }

    final class 1
    implements Runnable {
        private final /* synthetic */ ContentSet[] v$allContents;
        private final /* synthetic */ Project v$project;
        final /* synthetic */ SVNIncomingChangesTask this$0;

        public void run() {
            this.v$allContents[0] = ProjectContent.getInstance((PropertyStorage)this.v$project).getAllContents();
        }

        public 1(SVNIncomingChangesTask sVNIncomingChangesTask, ContentSet[] contentSetArray, Project project) {
            this.v$project = project;
            this.v$allContents = contentSetArray;
            this.this$0 = sVNIncomingChangesTask;
        }
    }

    final class 2
    implements Runnable {
        private final /* synthetic */ boolean v$busy;
        final /* synthetic */ SVNIncomingChangesTask this$0;

        public void run() {
            SVNIncomingChangesTask.ra$_eventQueue(this.this$0).setChangeListBusyImpl(this.v$busy);
        }

        public 2(SVNIncomingChangesTask sVNIncomingChangesTask, boolean bl) {
            this.v$busy = bl;
            this.this$0 = sVNIncomingChangesTask;
        }
    }
}

