/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.changelist;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.explorer.IconOverlay;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.changelist.ChangeListItem;
import oracle.jdeveloper.vcs.icons.VCSIconArb;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdevimpl.vcs.svn.changelist.SVNIncomingChangeList;
import oracle.jdevimpl.vcs.svn.changelist.SVNRemoteStatus;
import oracle.jdevimpl.vcs.svn.changelist.SVNRemoteStatusCache;

public final class SVNIncomingEventQueue
extends ChangeListEventQueue {
    private boolean _taskInProgress;
    SVNIncomingChangeList _changeList;
    private static final Map sIconReferences = new HashMap(7);

    public SVNIncomingEventQueue(SVNIncomingChangeList changeList) {
        super((ChangeList)changeList);
        this._changeList = changeList;
    }

    protected void setChangeListBusy(boolean busy) {
        this.setChangeListBusyImpl(busy);
    }

    protected void setChangeListBusyImpl(boolean busy) {
        super.setChangeListBusy(busy);
    }

    protected void setTaskInProgress(boolean inProgress) {
        this._taskInProgress = inProgress;
    }

    protected boolean isTaskInProgress() {
        return this._taskInProgress;
    }

    protected boolean containStatus(List displayStatuses, ArrayList urlStatuses, int i) {
        if (urlStatuses.get(i) == null) {
            return false;
        }
        SVNRemoteStatus status = (SVNRemoteStatus)urlStatuses.get(i);
        if (status.getID().equals("TEXT_MODIFIED") || status.getID().equals("PROP_MODIFIED")) {
            return true;
        }
        if (status.getID().equals("ADDED")) {
            return true;
        }
        return status.getID().equals("DELETED");
    }

    static {
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_ADDED", new int[]{9});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_CHECKED_IN", new int[]{3});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_CHECKED_OUT", new int[]{8});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_CONFLICTS", new int[]{16});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_MODIFIED", new int[]{6});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_REMOVED", new int[]{7});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_UNADDED", new int[]{5});
        sIconReferences.put("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_UNVERSIONED", new int[]{5});
    }

    protected ChangeListItem createChangeListItem(URL url) {
        URL url0 = URLFileSystem.canonicalize((URL)url);
        ChangeListItem cli = super.createChangeListItem(url0);
        VCSOverlayItemProducer overlayItemProducer = this.getChangeList().getOverlayItemProducer();
        Object overlayItem = null;
        IconOverlay iconOverlay = null;
        if (overlayItemProducer != null) {
            try {
                SVNRemoteStatusCache cache = (SVNRemoteStatusCache)this._changeList.getStatusCache();
                SVNRemoteStatus status = (SVNRemoteStatus)cache.getValue(url0);
                int iconkey = ((int[])sIconReferences.get("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_UNVERSIONED"))[0];
                if (status.getID().equals("TEXT_MODIFIED") || status.getID().equals("PROP_MODIFIED")) {
                    iconkey = ((int[])sIconReferences.get("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_MODIFIED"))[0];
                }
                if (status.getID().equals("ADDED")) {
                    iconkey = ((int[])sIconReferences.get("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_ADDED"))[0];
                }
                if (status.getID().equals("DELETED")) {
                    iconkey = ((int[])sIconReferences.get("oracle.jdeveloper.vcs.icon.OVERLAY_ICON_REMOVED"))[0];
                }
                iconOverlay = new IconOverlay(VCSIconArb.getInstance().getIconImpl(iconkey), status.getID(), status.getChangeListLabel());
                cli.setOverlay(iconOverlay);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return cli;
    }
}

