/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.changelist;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.changelist.ChangeListProjectContent;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public final class SVNOutgoingEventQueue
extends ChangeListEventQueue {
    public SVNOutgoingEventQueue(ChangeList changeList) {
        super(changeList);
    }

    protected Collection listProjectURLs(Project project, ChangeListProjectContent projectContent, VCSCancellable cancellable) throws Exception {
        HashSet urls = new HashSet(super.listProjectURLs(project, projectContent, cancellable));
        ArrayList<URL> baseDirs = new ArrayList<URL>(Arrays.asList(VCSFileSystemUtils.coalesceURLs((URL[])projectContent.getBaseDirectoryURLs())));
        HashSet<URL> workingCopies = new HashSet<URL>(baseDirs.size());
        Iterator it = baseDirs.iterator();
        while (it.hasNext()) {
            URL workingCopy = SVNUtil.resolveWorkingCopy((URL)it.next());
            if (workingCopy == null) continue;
            workingCopies.add(workingCopy);
        }
        it = workingCopies.iterator();
        while (it.hasNext() && !cancellable.isCancelled()) {
            this.addDeletions(urls, (URL)it.next(), cancellable);
        }
        return urls;
    }

    private void addDeletions(Collection urls, URL directory, VCSCancellable cancellable) throws Exception {
        ISVNStatus[] statuses = this.getClient().getStatus(SVNUtil.toFile(directory), true, false, false);
        int i = 0;
        while (i < statuses.length && !cancellable.isCancelled()) {
            if (SVNStatusKind.DELETED.equals((Object)statuses[i].getTextStatus())) {
                urls.add(URLFactory.newURL((String)statuses[i].getPath()));
            }
            ++i;
        }
    }

    private ISVNClientAdapter getClient() throws SVNClientException {
        return SVNUtil.getClientAdapter(SVNProfile.IDE_CLIENT_CONTEXT_ID, SVNProfile.OC_ADAPTER_CONTEXT_ID);
    }
}

