/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.changelist;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.generic.PendingChangesAdapter;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSPropertyMap;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.util.VCSNavigableUtils;
import oracle.jdevimpl.vcs.generic.GenericClient;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.SVNURLInfoCache;
import oracle.jdevimpl.vcs.svn.StatusMapping;
import oracle.jdevimpl.vcs.svn.prefs.SVNVersionToolsPreferences;
import oracle.jdevimpl.vcs.svn.res.Resource;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public final class SVNPendingChangesAdapter
extends PendingChangesAdapter {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNPendingChangesAdapter.class.getName());
    private static final String CL_ID_OUTGOING = "oracle.jdevimpl.vcs.svn.changelist.OUTGOING";
    private static final String CL_ID_INCOMING = "oracle.jdevimpl.vcs.svn.changelist.INCOMING";
    private static final String CL_ID_CANDIDATES = "oracle.jdevimpl.vcs.svn.changelist.CANDIDATES";
    private static final String PROP_ID_TEXT_STATUS = "textStatus";
    private static final String PROP_ID_PROP_STATUS = "propStatus";
    private static final String PROP_ID_STATUS = "status";

    public VCSProfile getProfile() {
        return VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
    }

    public Object resolvePropertyValue(String changeListId, String propertyId, URL url) {
        if (CL_ID_OUTGOING.equals(changeListId)) {
            if (PROP_ID_TEXT_STATUS.equals(propertyId)) {
                return this.resolveOutgoingTextStatus(url);
            }
            if (PROP_ID_PROP_STATUS.equals(propertyId)) {
                return this.resolveOutgoingPropStatus(url);
            }
            throw new IllegalArgumentException("Unknown outgoing change list display property: " + propertyId);
        }
        if (CL_ID_INCOMING.equals(changeListId)) {
            return "";
        }
        if (CL_ID_CANDIDATES.equals(changeListId)) {
            if (PROP_ID_STATUS.equals(propertyId)) {
                return super.resolvePropertyValue(changeListId, propertyId, url);
            }
            throw new IllegalArgumentException("Unknown candidate change list display property: " + propertyId);
        }
        throw new IllegalArgumentException("Unknown change list id: " + changeListId);
    }

    public boolean isActionSilent(ChangeList changeList, String actionId) {
        if (actionId.equals("oracle.jdeveloper.subversion.commit") || actionId.equals("oracle.jdeveloper.subversion.commit-workingcopy")) {
            VCSProfile profile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
            if (profile != null) {
                VCSPropertyMap vtoolsPrefs = profile.getData("VTOOLS_SETTINGS");
                Integer policy = (Integer)vtoolsPrefs.getMap().get("outgoingCommitDialog");
                if (policy == null) {
                    policy = SVNVersionToolsPreferences.PROP_DEFAULT_VALUE_DIALOG_POLICY;
                }
                if (SVNVersionToolsPreferences.PROP_VALUE_DIALOG_POLICY_ALWAYS.equals(policy)) {
                    return false;
                }
                if (SVNVersionToolsPreferences.PROP_VALUE_DIALOG_POLICY_SOMETIMES.equals(policy)) {
                    return changeList.isOptionsVisible();
                }
                if (SVNVersionToolsPreferences.PROP_VALUE_DIALOG_POLICY_NEVER.equals(policy)) {
                    return true;
                }
                throw new IllegalStateException();
            }
            return false;
        }
        return true;
    }

    private Object resolveOutgoingPropStatus(URL url) {
        try {
            int statusInt = SVNURLInfoCache.getInstance().getPropStatus(url);
            VCSStatus vCSStatus = StatusMapping.getVCSStatus(SVNStatusKind.fromInt((int)statusInt));
            return vCSStatus;
        }
        catch (SVNClientException ce) {
            sLogger.log(Level.SEVERE, "unable to resolve property status for " + URLFileSystem.getPlatformPathName((URL)url), ce);
            String string = "<<error>>";
            return string;
        }
    }

    private Object resolveOutgoingTextStatus(URL url) {
        try {
            int statusInt = SVNURLInfoCache.getInstance().getTextStatus(url);
            VCSStatus vCSStatus = StatusMapping.getVCSStatus(SVNStatusKind.fromInt((int)statusInt));
            return vCSStatus;
        }
        catch (SVNClientException ce) {
            sLogger.log(Level.SEVERE, "unable to resolve text status for " + URLFileSystem.getPlatformPathName((URL)url), ce);
            String string = "<<error>>";
            return string;
        }
    }

    public VCSPropertyMap getPreferences() {
        return VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion").getData("VTOOLS_SETTINGS");
    }

    public String[] getPreferencesPath() {
        return VCSNavigableUtils.getSystemNavigablePath((String)((GenericClient)VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion")).getInformation().getShortLabel(), (String[])new String[]{Resource.getBundle().getString("PREFERENCES_VTOOLS")});
    }
}

