/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.history;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.persistence.NameSpace;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNHistoricalContentCache {
    private static final SVNHistoricalContentCache sInstance = new SVNHistoricalContentCache();
    private final NameSpace _ns = NameSpace.getNameSpace((String)this.getClass().getName(), (int)0);

    public static SVNHistoricalContentCache getInstance() {
        return sInstance;
    }

    public synchronized boolean containsRevisionContent(SVNUrl url, SVNRevision revision) {
        return this._ns == null ? false : this._ns.checkRecord(this.createCacheKey(url, revision));
    }

    public synchronized byte[] getRevisionContent(SVNUrl url, SVNRevision revision) {
        String key = this.createCacheKey(url, revision);
        if (this._ns != null && this._ns.checkRecord(key)) {
            return this._ns.getRecord(key);
        }
        return new byte[0];
    }

    public synchronized InputStream getRevisionContentStream(SVNUrl url, SVNRevision revision) {
        String key = this.createCacheKey(url, revision);
        if (this._ns != null && this._ns.checkRecord(key)) {
            return new BufferedInputStream(this._ns.getRecordStream(key));
        }
        return null;
    }

    public synchronized void putRevisionContent(SVNUrl url, SVNRevision revision, byte[] content) throws IOException {
        if (this._ns == null) {
            throw new IOException();
        }
        String key = this.createCacheKey(url, revision);
        if (this._ns.checkRecord(key)) {
            this._ns.delRecord(key);
        }
        this._ns.putRecord(key, content);
    }

    public synchronized void putRevisionContentStream(SVNUrl url, SVNRevision revision, InputStream content) throws IOException {
        if (this._ns == null) {
            throw new IOException();
        }
        String key = this.createCacheKey(url, revision);
        if (this._ns.checkRecord(key)) {
            this._ns.delRecord(key);
        }
        BufferedInputStream in = new BufferedInputStream(content);
        BufferedOutputStream out = new BufferedOutputStream(this._ns.putRecordStream(key));
        byte[] buff = new byte[4096];
        try {
            try {
                int bytesRead = -1;
                while ((bytesRead = in.read(buff)) != -1) {
                    out.write(buff, 0, bytesRead);
                }
                out.close();
            }
            catch (IOException ioe) {
                this._ns.delRecord(key);
                throw ioe;
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ioe) {}
        }
    }

    public synchronized void removeRevisionContent(SVNUrl url, SVNRevision revision) {
        String key = this.createCacheKey(url, revision);
        if (this._ns != null && this._ns.checkRecord(key)) {
            this._ns.delRecord(key);
        }
    }

    public synchronized void removeAllRevisionContent() {
        if (this._ns != null) {
            ArrayList c = new ArrayList(50);
            Iterator it = this._ns.getKeyIterator();
            while (it.hasNext()) {
                c.add(it.next());
            }
            it = c.iterator();
            while (it.hasNext()) {
                this._ns.delRecord((String)it.next());
            }
        }
    }

    private String createCacheKey(SVNUrl url, SVNRevision revision) {
        return url.toString() + "@@r" + revision.toString();
    }

    private SVNHistoricalContentCache() {
    }
}

