/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.history;

import java.awt.EventQueue;
import java.awt.Window;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Ide;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.history.HistoryEntry;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.generic.HistoryEntryProducer;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.history.SVNHistoryEntry;
import oracle.jdevimpl.vcs.svn.history.SVNWCHistoryEntry;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class SVNHistoryEntryProducer
implements HistoryEntryProducer {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNHistoryEntryProducer.class.getName());
    public static Object CLIENT_CONTEXT = new Object();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HistoryEntry[] produceEntries(URL target) {
        EventQueue.invokeLater(new 1());
        try {
            ISVNClientAdapter client = SVNUtil.getClientAdapter(CLIENT_CONTEXT);
            HistoryEntry[] historyEntryArray = this.produceEntries(client, target);
            return historyEntryArray;
        }
        catch (SVNClientException ce) {
            String path = URLFileSystem.getPlatformPathName((URL)target);
            sLogger.log(Level.SEVERE, "unable to mine history for " + path, ce);
            ResourcePicker res = ResourcePicker.getPicker(SVNProfile.class);
            ExceptionDialog.showExceptionDialog((Window)VCSWindowUtils.getCurrentWindow(), (Exception)((Object)ce), (String)res.getString("HISTROY_PRODUCER_ERROR_TITLE"), (String)res.getString("HISTROY_PRODUCER_ERROR_MESSAGE", new Object[]{path}));
            HistoryEntry[] historyEntryArray = new HistoryEntry[]{};
            EventQueue.invokeLater(new 2());
            return historyEntryArray;
        }
        finally {
            EventQueue.invokeLater(new 2());
        }
    }

    private HistoryEntry[] produceEntries(ISVNClientAdapter client, URL target) throws SVNClientException {
        ISVNLogMessage[] logMessages = client.getLogMessages(SVNUtil.toFile(target), SVNRevision.START, SVNRevision.HEAD, false);
        ArrayList<Object> entries = new ArrayList<Object>(logMessages.length * 2);
        entries.add(this.getWorkingCopyEntry(client, target));
        int i = 0;
        while (i < logMessages.length) {
            entries.add((Object)new SVNHistoryEntry(target, logMessages[i].getDate(), logMessages[i].getAuthor(), logMessages[i].getRevision().getNumber(), logMessages[i].getMessage()));
            ++i;
        }
        return entries.toArray(new HistoryEntry[entries.size()]);
    }

    private HistoryEntry getWorkingCopyEntry(ISVNClientAdapter client, URL target) throws SVNClientException {
        ISVNInfo info = client.getInfoFromWorkingCopy(SVNUtil.toFile(target));
        return new SVNWCHistoryEntry(target, info.getLastChangedDate(), info.getLastCommitAuthor(), info.getRevision().getNumber());
    }

    final class 1
    implements Runnable {
        public void run() {
            Ide.getWaitCursor().show();
        }
    }

    final class 2
    implements Runnable {
        public void run() {
            Ide.getWaitCursor().hide();
        }
    }
}

