/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.imp;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.NetArb;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNExecutorService;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.imp.SVNImportModel;
import oracle.jdevimpl.vcs.svn.imp.SVNImportWizard;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.op.SVNOperationNewRemoteDir;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.util.SVNReposInfoComboBoxRenderer;
import oracle.jdevimpl.vcs.svn.util.SVNRepositoryTreeNode;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class DestinationPanel
extends DefaultTraversablePanel
implements ActionListener {
    private static final String TRANSIENT_TREE_PATH_KEY = DestinationPanel.class.getName() + ".treePath";
    private final ResourcePicker _res;
    private final Map _treeModels;
    private boolean _initialized;
    private JMultiLineLabel _hint;
    private JLabel _reposListLabel;
    private JComboBox _reposList;
    private JScrollPane _treeScroller;
    private JTree _tree;
    private DefaultMutableTreeNode _treeRoot;
    private JLabel _treeLabel;
    private JToolBar _treeToolbar;
    private JButton _newReposDirButton;

    private void $init$() {
        this._res = ResourcePicker.getPicker(SVNProfile.class);
        this._treeModels = new HashMap(10);
        this._initialized = false;
    }

    private void reloadTreeNodes(boolean contactRepos) {
        SVNRepositoryInfo repos = (SVNRepositoryInfo)this._reposList.getSelectedItem();
        this._treeRoot.removeAllChildren();
        if (contactRepos) {
            this._treeModels.put(repos, null);
        }
        Iterator it = this.getNodeModel(repos).iterator();
        while (it.hasNext()) {
            this._treeRoot.add((MutableTreeNode)it.next());
        }
        ((DefaultTreeModel)this._tree.getModel()).reload(this._treeRoot);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._reposList) {
            this.reloadTreeNodes(false);
            this._tree.setSelectionPath(new TreePath(this._treeRoot));
        }
        if (e.getSource() == this._newReposDirButton) {
            TreeNode selectedNode;
            SVNRepositoryInfo repos = (SVNRepositoryInfo)this._reposList.getSelectedItem();
            SVNUrl parent = repos.getURL();
            TreePath selectedPath = this._tree.getSelectionPath();
            DefaultMutableTreeNode parentNode = this._treeRoot;
            if (selectedPath != null && (selectedNode = (TreeNode)selectedPath.getLastPathComponent()) != this._treeRoot) {
                SVNRepositoryTreeNode svnNode = (SVNRepositoryTreeNode)selectedNode;
                parent = svnNode.getURL();
                parentNode = svnNode;
            }
            SVNOperationNewRemoteDir command = new SVNOperationNewRemoteDir(repos, parent, false);
            Context context = Context.newIdeContext();
            command.setContext(context);
            try {
                CommandProcessor.getInstance().invoke((Command)command);
                String newDir = (String)context.getProperty(SVNOperationNewRemoteDir.DIR_NAME_PROP_KEY);
                if (newDir != null) {
                    EventQueue.invokeLater(new 1());
                    if (parentNode instanceof SVNRepositoryTreeNode) {
                        ((SVNRepositoryTreeNode)parentNode).repopulate();
                        ((DefaultTreeModel)this._tree.getModel()).reload(parentNode);
                        Enumeration<TreeNode> childNodes = parentNode.children();
                        this.selectChildNode(newDir, childNodes);
                    } else {
                        this.reloadTreeNodes(true);
                        Enumeration<TreeNode> childNodes = this._treeRoot.children();
                        this.selectChildNode(newDir, childNodes);
                    }
                    EventQueue.invokeLater(new 2());
                }
            }
            catch (Exception commandException) {
                commandException.printStackTrace();
            }
        }
    }

    private void selectChildNode(String newDir, Enumeration childNodes) {
        while (childNodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)childNodes.nextElement();
            if (!newDir.equals(node.getUserObject())) continue;
            this._tree.setSelectionPath(new TreePath(node.getPath()));
        }
    }

    public void onEntry(TraversableContext ctx) {
        this.initialize();
        SVNImportModel model = (SVNImportModel)ctx.get(SVNImportWizard.DATA_KEY);
        SVNExecutorService.getInstance().submit(new 3(this, model, ctx));
        ctx.getWizardCallbacks().wizardEnableButtons(Boolean.FALSE, Boolean.FALSE, Boolean.FALSE);
    }

    public void onExit(TraversableContext ctx) throws TraversalException {
        this.initialize();
        SVNImportModel model = (SVNImportModel)ctx.get(SVNImportWizard.DATA_KEY);
        SVNRepositoryInfo repos = (SVNRepositoryInfo)this._reposList.getSelectedItem();
        model.setRepository(repos);
        TreePath selectedPath = this._tree.getSelectionPath();
        if (selectedPath != null) {
            TreeNode selectedNode = (TreeNode)selectedPath.getLastPathComponent();
            if (selectedNode == this._treeRoot) {
                model.setDestinationUrl(repos.getURL());
            } else {
                SVNRepositoryTreeNode svnNode = (SVNRepositoryTreeNode)selectedNode;
                model.setDestinationUrl(svnNode.getURL());
            }
            ctx.put(TRANSIENT_TREE_PATH_KEY, (Object)selectedPath);
        } else {
            model.setDestinationUrl(repos.getURL());
            ctx.put(TRANSIENT_TREE_PATH_KEY, null);
        }
    }

    private Collection getNodeModel(SVNRepositoryInfo repos) {
        Collection nodeModel = (Collection)this._treeModels.get(repos);
        if (nodeModel == null) {
            try {
                nodeModel = this.generateNodeModel(repos);
                this._treeModels.put(repos, nodeModel);
            }
            catch (SVNClientException ce) {
                nodeModel = Collections.EMPTY_LIST;
            }
        }
        return nodeModel;
    }

    private Collection generateNodeModel(SVNRepositoryInfo repos) throws SVNClientException {
        SVNRepositoryTreeNode virtualRoot = new SVNRepositoryTreeNode(repos, SVNNodeKind.DIR, repos.getURL(), "/", 1, SVNUtil.getIDEClientAdapter());
        ArrayList nodes = new ArrayList(20);
        WaitCursor wc = new WaitCursor((Component)((Object)this));
        EventQueue.invokeLater(new 4(this, wc));
        try {
            Enumeration children = virtualRoot.children();
            while (children.hasMoreElements()) {
                nodes.add(children.nextElement());
            }
            ArrayList arrayList = nodes;
            return arrayList;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            EventQueue.invokeLater(new 5(this, wc));
        }
    }

    private synchronized void initialize() {
        if (this._initialized) {
            return;
        }
        this.createComponents();
        this.layoutComponents();
        this.initListeners();
        this._initialized = true;
    }

    private void createComponents() {
        this._hint = new JMultiLineLabel();
        this._hint.setText(this._res.getString("IMPORT_UI_DEST_HINT"));
        this._reposList = new JComboBox<Object>(SVNRepositoryManager.getInstance().list().toArray());
        this._reposList.setRenderer(new SVNReposInfoComboBoxRenderer());
        this._reposListLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._reposListLabel, (Component)this._reposList, (String)this._res.getString("IMPORT_UI_REPOS_CONNECTION"));
        this._treeRoot = new DefaultMutableTreeNode("root");
        this._tree = new JTree(this._treeRoot);
        this._tree.setVisibleRowCount(10);
        this._tree.setRootVisible(true);
        this._tree.setShowsRootHandles(true);
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.setCellRenderer(new 6());
        this._treeLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._treeLabel, (Component)this._tree, (String)this._res.getString("IMPORT_UI_REPOS_TREE"));
        this._treeScroller = new JScrollPane(this._tree);
        this._newReposDirButton = new JButton(NetArb.getIcon((int)36));
        this._newReposDirButton.setMargin(new Insets(1, 1, 1, 1));
        this._newReposDirButton.setToolTipText(this._res.getString("IMPORT_UI_CREATE_REMOTE_FOLDER_TOOLTIP"));
        this._treeToolbar = new JToolBar(0);
        this._treeToolbar.setBorder(BorderFactory.createEmptyBorder());
        this._treeToolbar.setFloatable(false);
        this._treeToolbar.setRollover(true);
        this._treeToolbar.add(this._newReposDirButton);
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this._hint, this.gbc(0, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add(this._reposListLabel, this.gbc(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 3, 0), 0, 0));
        this.add(this._reposList, this.gbc(0, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 50, 0));
        this.add(this._treeLabel, this.gbc(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 3, 0), 0, 0));
        this.add(this._treeToolbar, this.gbc(1, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 3, 0), 0, 0));
        this.add(this._treeScroller, this.gbc(0, 4, 2, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void initListeners() {
        this._reposList.addActionListener(this);
        this._newReposDirButton.addActionListener(this);
    }

    public DestinationPanel() {
        this.$init$();
    }

    static ResourcePicker ra$_res(DestinationPanel destinationPanel) {
        return destinationPanel._res;
    }

    static Collection mav$getNodeModel(DestinationPanel destinationPanel, SVNRepositoryInfo sVNRepositoryInfo) {
        return destinationPanel.getNodeModel(sVNRepositoryInfo);
    }

    static JComboBox ra$_reposList(DestinationPanel destinationPanel) {
        return destinationPanel._reposList;
    }

    static String ra$TRANSIENT_TREE_PATH_KEY() {
        return TRANSIENT_TREE_PATH_KEY;
    }

    static JTree ra$_tree(DestinationPanel destinationPanel) {
        return destinationPanel._tree;
    }

    static DefaultMutableTreeNode ra$_treeRoot(DestinationPanel destinationPanel) {
        return destinationPanel._treeRoot;
    }

    final class 1
    implements Runnable {
        public void run() {
            Ide.getWaitCursor().show(500);
        }
    }

    final class 2
    implements Runnable {
        public void run() {
            Ide.getWaitCursor().hide();
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ SVNImportModel v$model;
        private final /* synthetic */ TraversableContext v$ctx;
        final /* synthetic */ DestinationPanel this$0;

        public void run() {
            DestinationPanel.mav$getNodeModel(this.this$0, this.v$model.getRepository());
            SwingUtilities.invokeLater(new 1());
        }

        public 3(DestinationPanel destinationPanel, SVNImportModel sVNImportModel, TraversableContext traversableContext) {
            this.v$ctx = traversableContext;
            this.v$model = sVNImportModel;
            this.this$0 = destinationPanel;
        }

        static SVNImportModel ra$v$model(3 var0) {
            return var0.v$model;
        }

        static TraversableContext ra$v$ctx(3 var0) {
            return var0.v$ctx;
        }

        final class 1
        implements Runnable {
            public void run() {
                SVNUrl reposUrl = 3.ra$v$model(3.this).getRepository().getURL();
                int i = 0;
                while (i < DestinationPanel.ra$_reposList(3.this.this$0).getItemCount()) {
                    SVNRepositoryInfo repos = (SVNRepositoryInfo)DestinationPanel.ra$_reposList(3.this.this$0).getItemAt(i);
                    if (reposUrl.equals((Object)repos.getURL())) {
                        DestinationPanel.ra$_reposList(3.this.this$0).setSelectedIndex(i);
                        break;
                    }
                    ++i;
                }
                TreePath selectedPath = (TreePath)3.ra$v$ctx(3.this).get(DestinationPanel.ra$TRANSIENT_TREE_PATH_KEY());
                if (selectedPath != null) {
                    DestinationPanel.ra$_tree(3.this.this$0).setSelectionPath(selectedPath);
                } else {
                    try {
                        DestinationPanel.ra$_tree(3.this.this$0).setSelectionPath(new TreePath(DestinationPanel.ra$_treeRoot(3.this.this$0)));
                    }
                    catch (NoSuchElementException nsee) {
                        // empty catch block
                    }
                }
                3.ra$v$ctx(3.this).getWizardCallbacks().wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
            }
        }
    }

    final class 4
    implements Runnable {
        private final /* synthetic */ WaitCursor v$wc;
        final /* synthetic */ DestinationPanel this$0;

        public void run() {
            this.v$wc.show(500);
        }

        public 4(DestinationPanel destinationPanel, WaitCursor waitCursor) {
            this.v$wc = waitCursor;
            this.this$0 = destinationPanel;
        }
    }

    final class 5
    implements Runnable {
        private final /* synthetic */ WaitCursor v$wc;
        final /* synthetic */ DestinationPanel this$0;

        public void run() {
            this.v$wc.hide();
            this.v$wc.dispose();
        }

        public 5(DestinationPanel destinationPanel, WaitCursor waitCursor) {
            this.v$wc = waitCursor;
            this.this$0 = destinationPanel;
        }
    }

    final class 6
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (!(value instanceof SVNRepositoryTreeNode)) {
                this.setIcon(DestinationPanel.ra$_res(DestinationPanel.this).getImage("NAV_ICON_REPOSITORY_NODE"));
            }
            return this;
        }
    }
}

