/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.imp;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSM;
import oracle.ide.wizard.FSMBuilder;
import oracle.ide.wizard.FSMInvalidException;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.Step;
import oracle.ide.wizard.WelcomePanel;
import oracle.ideri.util.Product;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.util.ResourcePicker;
import oracle.javatools.util.SwingUtils;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.generic.VCSProfiles;
import oracle.jdeveloper.vcs.spi.VCSCancelException;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.spi.VCSImportBackupHelper;
import oracle.jdeveloper.vcs.util.VCSIgnoreFilters;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.generic.util.DirectoryCopier;
import oracle.jdevimpl.vcs.generic.util.NewFilesHandler;
import oracle.jdevimpl.vcs.generic.util.PatternURLFilter;
import oracle.jdevimpl.vcs.generic.util.VCSDirectoryWatcher;
import oracle.jdevimpl.vcs.generic.util.VCSGenericUtil;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.imp.DestinationPanel;
import oracle.jdevimpl.vcs.svn.imp.FiltersPanel;
import oracle.jdevimpl.vcs.svn.imp.OthersPanel;
import oracle.jdevimpl.vcs.svn.imp.SVNImportModel;
import oracle.jdevimpl.vcs.svn.imp.SourcePanel;
import oracle.jdevimpl.vcs.svn.imp.SummaryPanel;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNImportWizard {
    static final String DATA_KEY;
    private static final String LAST_REPOS_KEY;
    private static final Object FSM_STATE_DESTINATION;
    private static final Object FSM_STATE_SOURCE;
    private static final Object FSM_STATE_FILTERS;
    private static final Object FSM_STATE_OTHERS;
    private static final Object FSM_STATE_SUMMARY;
    private final VCSProfile _profile;
    private final ResourcePicker _res;
    private IndeterminateProgressMonitor _progress;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this._progress = null;
    }

    public SVNImportWizard() {
        this.$init$();
        this._profile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
        this._res = ResourcePicker.getPicker(SVNProfile.class);
    }

    public boolean runWizard(Component parent, Context context) {
        if (!SVNUtil.ensureRepositoryConnection(context)) {
            return false;
        }
        Namespace ns = new Namespace();
        ns.put(DATA_KEY, (Object)this.createModel(context));
        FSMWizard wizard = new FSMWizard(this.createFSM(), ns);
        wizard.setWelcomePageAdded(true);
        wizard.setFinishPageAdded(true);
        wizard.setWizardTitle(this._res.getString("IMPORT_WIZARD_TITLE"));
        wizard.setShowStepNumber(true);
        wizard.setRoadmapVisible(true);
        wizard.setLogoImage(this._res.getImageResource(this._res.getString("IMPORT_WIZARD_IMAGE")).getImage());
        WizardDialog wd = this.createWizardDialog(wizard, parent);
        wizard.addCommitListener((CommitListener)new 1(this, ns, context, wd));
        return WizardLauncher.runDialog((JDialog)wd);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean commitWizard(SVNImportModel model, Context context) {
        this._progress = new IndeterminateProgressMonitor((Component)VCSWindowUtils.getCurrentWindow(), this._res.getString("IMPORT_OP_PROGRESS_TITLE"));
        this._progress.setCancellable(true);
        this._progress.setCloseOnFinish(true);
        this._progress.setMillisToPopup(0);
        this._progress.start();
        Ide.getDTCache().putString(LAST_REPOS_KEY, model.getRepository().getURL().toString());
        2 cancellable = new 2();
        try {
            this.setProgressMessage(this._res.getString("IMPORT_OP_PROGRESS_COPYING"));
            URL filteredSourceDir = this.prepareImportSources(model, cancellable);
            this.setProgressMessage(this._res.getString("IMPORT_OP_PROGRESS_IMPORTING"));
            boolean success = this.executeImport(model, filteredSourceDir, cancellable);
            if (success && model.getCheckout()) {
                URL importSource = model.getSourceDirectory();
                this.setProgressMessage(this._res.getString("IMPORT_OP_PROGRESS_BACKUP"));
                URL backup = this.backupAndCloseNodes(importSource, cancellable);
                if (URLFileSystem.list((URL)importSource).length > 0) {
                    MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)this._res.getString("IMPORT_OP_ERROR_MSG_BACKUPURLS", (Object)URLFileSystem.getPlatformPathName((URL)backup)), (String)this._res.getString("IMPORT_OP_ERROR_TITLE_BACKUPURL"), null);
                    throw new VCSCancelException();
                }
                VCSDirectoryWatcher watcher = new VCSDirectoryWatcher(importSource);
                this.setProgressMessage(this._res.getString("IMPORT_OP_PROGRESS_CHECKOUT"));
                watcher.beginWatch();
                this.executeCheckout(model.getDestinationUrl(), model.getRepository(), importSource, cancellable);
                watcher.endWatch();
                this.openNewFiles(watcher, context);
                this._profile.getStatusCache().clear(VCSURLFilters.createBaseURLContentsFilter((URL[])new URL[]{importSource}));
            }
            boolean bl = true;
            return bl;
        }
        catch (VCSCancelException vcsce) {
            boolean bl = false;
            this.progressFinish();
            return bl;
        }
        finally {
            this.progressFinish();
        }
    }

    private void openNewFiles(VCSDirectoryWatcher watcher, Context context) {
        VCSProfile profile = VCSProfiles.getInstance().getProfile("oracle.jdeveloper.subversion");
        URLFilter filter = profile.getURLFilter("oracle.jdeveloper.subversion.filters.url.WORKING_COPY");
        NewFilesHandler nfh = new NewFilesHandler(watcher, filter);
        SwingUtilities.invokeLater(new 3(this, context, nfh, watcher));
    }

    private void executeCheckout(SVNUrl source, SVNRepositoryInfo repos, URL target, VCSCancellable cancellable) throws VCSCancelException {
        if (cancellable.isCancelled()) {
            throw new VCSCancelException();
        }
        ISVNClientAdapter client = null;
        try {
            try {
                client = SVNUtil.getIDEClientAdapter();
                SVNOperationLogger.getInstance().beginOperation(client, repos);
                client.checkout(source, SVNUtil.toFile(target), SVNRevision.HEAD, true);
            }
            catch (SVNClientException ce) {
                ExceptionDialog.showExceptionDialog((Window)VCSWindowUtils.getCurrentWindow(), (Exception)((Object)ce), (String)this._res.getString("IMPORT_OP_ERROR_TITLE_CHECKOUT"), (String)this._res.getString("IMPORT_OP_ERROR_MSG_CHECKOUT", (Object)source.toString()));
                throw new VCSCancelException();
            }
        }
        finally {
            if (client != null) {
                SVNOperationLogger.getInstance().endOperation();
            }
        }
    }

    private URL backupAndCloseNodes(URL dir, VCSCancellable cancellable) throws VCSCancelException {
        4 backupHelper = new 4(this, dir, dir);
        try {
            URL backupDirectoryUrl = backupHelper.backupDirectoryFiles(cancellable);
            if (cancellable.isCancelled() || backupDirectoryUrl == null) {
                throw new VCSCancelException();
            }
            URL uRL = backupDirectoryUrl;
            return uRL;
        }
        catch (VCSCancelException vcsce) {
            throw vcsce;
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog((Window)VCSWindowUtils.getCurrentWindow(), (Exception)e);
            throw new VCSCancelException();
        }
    }

    private boolean executeImport(SVNImportModel model, URL filteredSourceDir, VCSCancellable cancellable) throws VCSCancelException {
        if (cancellable.isCancelled()) {
            throw new VCSCancelException();
        }
        ISVNClientAdapter client = null;
        try {
            try {
                client = SVNUtil.getIDEClientAdapter();
                SVNOperationLogger.getInstance().beginOperation(client, model.getRepository());
                String comment = model.getComment();
                client.doImport(SVNUtil.toFile(filteredSourceDir), model.getDestinationUrl(), comment != null ? comment : "", model.getRecursive());
            }
            catch (SVNClientException ce) {
                this.progressFinish();
                ExceptionDialog.showExceptionDialog((Component)VCSWindowUtils.getCurrentWindow(), (Throwable)ce, (String)this._res.getString("IMPORT_OP_ERROR_TITLE_IMPORTING"), (String)this._res.getString("IMPORT_OP_ERROR_MSG_IMPORTING", (Object)model.getDestinationUrl().toString()), (String)"f1_svnimpimporterror_html");
                boolean bl = false;
                if (client != null) {
                    SVNOperationLogger.getInstance().endOperation();
                }
                return bl;
            }
        }
        finally {
            if (client != null) {
                SVNOperationLogger.getInstance().endOperation();
            }
        }
        return true;
    }

    private URL prepareImportSources(SVNImportModel model, VCSCancellable cancellable) throws VCSCancelException {
        URL sourceDir = model.getSourceDirectory();
        String name = URLFileSystem.getFileName((URL)sourceDir) + ".svn-import-workarea/";
        URL filteredSourceDir = URLFactory.newUniqueURL((URL)URLFileSystem.getParent((URL)sourceDir), (NameGenerator)new DefaultNameGenerator(name, null));
        if (!URLFileSystem.mkdirs((URL)(filteredSourceDir = URLFactory.newDirURL((URL)filteredSourceDir, (String)"/")))) {
            this.progressFinish();
            MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)this._res.getString("IMPORT_OP_ERROR_MSG_STAGEDIR", new Object[]{URLFileSystem.getPlatformPathName((URL)filteredSourceDir), URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)filteredSourceDir))}), (String)this._res.getString("IMPORT_OP_ERROR_TITLE_COPYING"), (String)"f1_svnimpfilterdirerror_htm553l");
            throw new VCSCancelException();
        }
        DirectoryCopier copier = null;
        try {
            copier = new DirectoryCopier(sourceDir, filteredSourceDir, (URLFilter)new PatternURLFilter(model.getFilters()), cancellable, true);
        }
        catch (IllegalArgumentException iae) {
            MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)this._res.getString("IMPORT_OP_ERROR_MSG_COPYING", new Object[]{URLFileSystem.getPlatformPathName((URL)filteredSourceDir), URLFileSystem.getPlatformPathName((URL)sourceDir)}), (String)this._res.getString("IMPORT_OP_ERROR_TITLE_COPYING"), (String)"f1_svnimpcopyerror_html");
        }
        if (cancellable.isCancelled()) {
            throw new VCSCancelException();
        }
        try {
            if (copier != null) {
                copier.performCopy();
            }
            URL uRL = filteredSourceDir;
            return uRL;
        }
        catch (IOException ioe) {
            this.progressFinish();
            MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)this._res.getString("IMPORT_OP_ERROR_MSG_COPYING", new Object[]{URLFileSystem.getPlatformPathName((URL)filteredSourceDir), URLFileSystem.getPlatformPathName((URL)sourceDir)}), (String)this._res.getString("IMPORT_OP_ERROR_TITLE_COPYING"), (String)"f1_svnimpcopyerror_html");
            ioe.printStackTrace();
            throw new VCSCancelException();
        }
    }

    private WizardDialog createWizardDialog(FSMWizard wizard, Component parent) {
        Dialog dialog = SwingUtils.getAncestorDialog((Component)parent);
        if (dialog != null) {
            return wizard.getDialog(dialog);
        }
        return wizard.getDialog(SwingUtils.getAncestorFrame((Component)parent));
    }

    private SVNImportModel createModel(Context context) {
        SVNRepositoryInfo defaultRepos;
        SVNImportModel model = new SVNImportModel();
        Collection c = SVNRepositoryManager.getInstance().list();
        SVNRepositoryInfo repos = defaultRepos = (SVNRepositoryInfo)c.iterator().next();
        String lastRepos = Ide.getDTCache().getString(LAST_REPOS_KEY);
        if (lastRepos != null) {
            try {
                SVNRepositoryInfo resolvedRepos = SVNUtil.resolveRepository(new SVNUrl(lastRepos));
                if (resolvedRepos != null) {
                    repos = resolvedRepos;
                }
            }
            catch (MalformedURLException mfue) {
                this._profile.getLogger().log(Level.WARNING, "malformed svn url for last import target", mfue);
            }
        }
        model.setRepository(repos);
        model.setSourceDirectory(VCSGenericUtil.getContextDirectoryURL((Context)context, (VCSProfile)this._profile));
        model.setFilters(VCSIgnoreFilters.getAllIgnoreFilters());
        model.setRecursive(true);
        model.setCheckout(true);
        return model;
    }

    static {
        $assertionsDisabled = SVNImportWizard.class.desiredAssertionStatus() ^ true;
        DATA_KEY = SVNImportWizard.class.getName() + ".importModel";
        LAST_REPOS_KEY = SVNImportWizard.class.getName() + ".lastRepos";
        FSM_STATE_DESTINATION = new Object();
        FSM_STATE_SOURCE = new Object();
        FSM_STATE_FILTERS = new Object();
        FSM_STATE_OTHERS = new Object();
        FSM_STATE_SUMMARY = new Object();
    }

    private FSM createFSM() {
        FSMBuilder builder = new FSMBuilder();
        Step step = WelcomePanel.newStep((String)this._res.getString("IMPORT_WIZARD_TITLE"), (String)this._res.getString("IMPORT_WIZARD_HEADER"), (String)this._res.getString("IMPORT_WIZARD_WELCOME_TEXT"), (String)(this.getClass().getName() + ".skipWelcome"), (String)"f1_svnimpwelcome_html");
        builder.newStartState(step, FSM_STATE_DESTINATION);
        step = new Step(this._res.getString("IMPORT_WIZARD_DESTINATION_TITLE"), DestinationPanel.class, "f1_svnimpdestination_html");
        builder.newState(FSM_STATE_DESTINATION, step, FSM_STATE_SOURCE);
        step = new Step(this._res.getString("IMPORT_WIZARD_SOURCE_TITLE"), SourcePanel.class, "f1_svnimpsource_html");
        builder.newState(FSM_STATE_SOURCE, step, FSM_STATE_FILTERS);
        step = new Step(this._res.getString("IMPORT_WIZARD_FILTERS_TITLE"), FiltersPanel.class, "f1_svnimpfilters_html");
        builder.newState(FSM_STATE_FILTERS, step, FSM_STATE_OTHERS);
        step = new Step(this._res.getString("IMPORT_WIZARD_OTHERS_TITLE"), OthersPanel.class, "f1_svnimpoptions_html");
        builder.newState(FSM_STATE_OTHERS, step, FSM_STATE_SUMMARY);
        step = new Step(this._res.getString("IMPORT_WIZARD_SUMMARY_TITLE"), SummaryPanel.class, "f1_svnimpsummary_html");
        builder.newFinalState(FSM_STATE_SUMMARY, step);
        try {
            FSM fSM = builder.getFSM();
            return fSM;
        }
        catch (FSMInvalidException fsmie) {
            fsmie.printStackTrace();
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Unexpected FSMInvalidException");
            }
            FSM fSM = null;
            return fSM;
        }
    }

    private void setProgressMessage(String message) {
        if (this._progress != null && this._progress.getPanel() != null) {
            this._progress.getPanel().setMessage(message);
        }
    }

    private void progressFinish() {
        if (this._progress != null) {
            this._progress.finish();
        }
    }

    static void mav$progressFinish(SVNImportWizard sVNImportWizard) {
        sVNImportWizard.progressFinish();
    }

    static ResourcePicker ra$_res(SVNImportWizard sVNImportWizard) {
        return sVNImportWizard._res;
    }

    static IndeterminateProgressMonitor ra$_progress(SVNImportWizard sVNImportWizard) {
        return sVNImportWizard._progress;
    }

    static boolean mav$commitWizard(SVNImportWizard sVNImportWizard, SVNImportModel sVNImportModel, Context context) {
        return sVNImportWizard.commitWizard(sVNImportModel, context);
    }

    final class oracle.jdevimpl.vcs.svn.imp.SVNImportWizard$1
    implements CommitListener {
        private final /* synthetic */ Namespace v$ns;
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ WizardDialog v$wd;
        final /* synthetic */ SVNImportWizard this$0;

        public void checkCommit(ApplyEvent event) {
        }

        public void commit(ApplyEvent event) {
            new Thread((Runnable)new 1(), "svn-import-wizard-thread").start();
        }

        public void rollback(ApplyEvent event) {
        }

        public void cancel(ApplyEvent event) {
        }

        public oracle.jdevimpl.vcs.svn.imp.SVNImportWizard$1(SVNImportWizard sVNImportWizard, Namespace namespace, Context context, WizardDialog wizardDialog) {
            this.v$wd = wizardDialog;
            this.v$context = context;
            this.v$ns = namespace;
            this.this$0 = sVNImportWizard;
        }

        static Namespace ra$v$ns(oracle.jdevimpl.vcs.svn.imp.SVNImportWizard$1 var0) {
            return var0.v$ns;
        }

        static Context ra$v$context(oracle.jdevimpl.vcs.svn.imp.SVNImportWizard$1 var0) {
            return var0.v$context;
        }

        static WizardDialog ra$v$wd(oracle.jdevimpl.vcs.svn.imp.SVNImportWizard$1 var0) {
            return var0.v$wd;
        }

        final class oracle.jdevimpl.vcs.svn.imp.SVNImportWizard$1$1
        implements Runnable {
            public void run() {
                if (!SVNImportWizard.mav$commitWizard(1.this.this$0, (SVNImportModel)oracle.jdevimpl.vcs.svn.imp.SVNImportWizard$1.ra$v$ns(1.this).get(DATA_KEY), oracle.jdevimpl.vcs.svn.imp.SVNImportWizard$1.ra$v$context(1.this))) {
                    return;
                }
                SwingUtilities.invokeLater(new 1());
            }

            final class 1
            implements Runnable {
                public void run() {
                    oracle.jdevimpl.vcs.svn.imp.SVNImportWizard$1.ra$v$wd(1.this).dispose();
                }
            }
        }
    }

    final class 2
    extends VCSCancellable {
        public boolean isCancelled() {
            return SVNImportWizard.ra$_progress(SVNImportWizard.this).isCancelled();
        }
    }

    final class 3
    implements Runnable {
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ NewFilesHandler v$nfh;
        private final /* synthetic */ VCSDirectoryWatcher v$watcher;
        final /* synthetic */ SVNImportWizard this$0;

        public void run() {
            try {
                Element elm = this.v$context.getElement();
                String name = "";
                if (elm instanceof Locatable) {
                    URL url = ((Locatable)elm).getURL();
                    name = URLFileSystem.getName((URL)url);
                }
                if (!Product.isRaptor()) {
                    this.v$nfh.handleNewFiles(this.v$context, name);
                }
            }
            catch (Exception exception) {
                SVNImportWizard.mav$progressFinish(this.this$0);
                ExceptionDialog.showExceptionDialog((Component)VCSWindowUtils.getCurrentWindow(), (Throwable)exception, (String)SVNImportWizard.ra$_res(this.this$0).getString("IMPORT_OP_ERROR_TITLE_OPENNEW"), (String)SVNImportWizard.ra$_res(this.this$0).getString("IMPORT_OP_ERROR_MSG_OPENNEW", (Object)URLFileSystem.getPlatformPathName((URL)this.v$watcher.getWatchedDirectory())), (String)"f1_svnimpopennewerror_html");
            }
        }

        public 3(SVNImportWizard sVNImportWizard, Context context, NewFilesHandler newFilesHandler, VCSDirectoryWatcher vCSDirectoryWatcher) {
            this.v$watcher = vCSDirectoryWatcher;
            this.v$nfh = newFilesHandler;
            this.v$context = context;
            this.this$0 = sVNImportWizard;
        }
    }

    final class 4
    extends VCSImportBackupHelper {
        private final /* synthetic */ URL v$dir;
        final /* synthetic */ SVNImportWizard this$0;

        protected URL generateBackupDirectoryURL(URL directoryUrl) {
            String name = URLFileSystem.getFileName((URL)directoryUrl) + ".svn-import-backup/";
            URL backupDir = URLFactory.newUniqueURL((URL)URLFileSystem.getParent((URL)directoryUrl), (NameGenerator)new DefaultNameGenerator(name, null));
            return URLFactory.newDirURL((URL)backupDir, (String)"/");
        }

        protected void createBackupDirectory(URL backupDirectoryUrl) throws Exception {
            if (!URLFileSystem.mkdirs((URL)backupDirectoryUrl)) {
                SVNImportWizard.mav$progressFinish(this.this$0);
                MessageDialog.error((Component)VCSWindowUtils.getCurrentWindow(), (Object)SVNImportWizard.ra$_res(this.this$0).getString("IMPORT_OP_ERROR_MSG_BACKUPDIR", new Object[]{URLFileSystem.getPlatformPathName((URL)backupDirectoryUrl), URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)this.v$dir))}), (String)SVNImportWizard.ra$_res(this.this$0).getString("IMPORT_OP_ERROR_TITLE_BACKUP"), (String)"f1_svnimpbackupdirerror_html");
                throw new VCSCancelException();
            }
        }

        protected boolean confirmRetryBackupAfterFailure(URL url) {
            return MessageDialog.confirm((Component)VCSWindowUtils.getCurrentWindow(), (Object)SVNImportWizard.ra$_res(this.this$0).getString("IMPORT_OP_ERROR_MSG_BACKUPURL", (Object)URLFileSystem.getPlatformPathName((URL)url)), (String)SVNImportWizard.ra$_res(this.this$0).getString("IMPORT_OP_ERROR_TITLE_BACKUPURL"), (String)"f1_svnimpconfirmbackupretry_html", (boolean)false, (String)SVNImportWizard.ra$_res(this.this$0).getString("IMPORT_OP_ERROR_BACKUPURL_RETRY_YES"), (String)UIManager.getString("OptionPane.cancelButtonText"));
        }

        protected void removeNodes(Node[] nodes) throws Exception {
            try {
                super.removeNodes(nodes);
            }
            catch (Exception exception) {
                SVNImportWizard.mav$progressFinish(this.this$0);
                ExceptionDialog.showExceptionDialog((Window)VCSWindowUtils.getCurrentWindow(), (Exception)exception, (String)SVNImportWizard.ra$_res(this.this$0).getString("IMPORT_OP_ERROR_MSG_REMOVENODE"));
                throw new VCSCancelException();
            }
        }

        protected void closeNodes(Node[] nodes) throws Exception {
            try {
                super.closeNodes(nodes);
            }
            catch (Exception exception) {
                SVNImportWizard.mav$progressFinish(this.this$0);
                ExceptionDialog.showExceptionDialog((Window)VCSWindowUtils.getCurrentWindow(), (Exception)exception, (String)SVNImportWizard.ra$_res(this.this$0).getString("IMPORT_OP_ERROR_MSG_CLOSENODE"));
                throw new VCSCancelException();
            }
        }

        public 4(SVNImportWizard sVNImportWizard, URL uRL, URL uRL2) {
            this.v$dir = uRL2;
            this.this$0 = sVNImportWizard;
            super(uRL);
        }
    }
}

