/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.imp;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.imp.SVNImportModel;
import oracle.jdevimpl.vcs.svn.imp.SVNImportWizard;

public final class SourcePanel
extends DefaultTraversablePanel
implements ActionListener {
    private final ResourcePicker _res;
    private boolean _initialized;
    private JMultiLineLabel _hint;
    private JLabel _sourceLabel;
    private FileField _sourceField;
    private JButton _browseButton;
    private VCSCommentsCustomizer _commentsUI;

    private void $init$() {
        this._res = ResourcePicker.getPicker(SVNProfile.class);
        this._initialized = false;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._browseButton) {
            URL current = URLFactory.newDirURL((String)this._sourceField.getText());
            URLChooser chooser = DialogUtil.newURLChooser((URL)current);
            chooser.setSelectionMode(0);
            chooser.setSelectionScope(1);
            if (chooser.showOpenDialog((Component)((Object)this)) == 0) {
                this._sourceField.setText(URLFileSystem.getPlatformPathName((URL)chooser.getSelectedURL()));
            }
        }
    }

    public void onEntry(TraversableContext ctx) {
        this.initialize();
        SVNImportModel model = (SVNImportModel)ctx.get(SVNImportWizard.DATA_KEY);
        URL sourceUrl = model.getSourceDirectory();
        String comment = model.getComment();
        this._sourceField.setText(URLFileSystem.getPlatformPathName((URL)sourceUrl));
        if (comment != null && comment.length() > 0) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("setting_comments", comment);
            this._commentsUI.setOptions(options);
        }
        ctx.getWizardCallbacks().wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
    }

    public void onExit(TraversableContext ctx) throws TraversalException {
        this.initialize();
        SVNImportModel model = (SVNImportModel)ctx.get(SVNImportWizard.DATA_KEY);
        String urlStr = this._sourceField.getText();
        model.setSourceDirectory(urlStr != null && urlStr.length() > 0 ? URLFactory.newDirURL((String)urlStr) : null);
        String comment = (String)this._commentsUI.getOptions().get("setting_comments");
        model.setComment(comment != null && comment.length() > 0 ? comment : null);
    }

    private synchronized void initialize() {
        if (this._initialized) {
            return;
        }
        this.createComponents();
        this.layoutComponents();
        this.initListeners();
        this._initialized = true;
    }

    private void createComponents() {
        this._hint = new JMultiLineLabel();
        this._hint.setText(this._res.getString("IMPORT_UI_SOURCE_HINT"));
        this._sourceField = new FileField(true);
        this._sourceField.setText("");
        this._sourceLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)this._sourceLabel, (Component)this._sourceField, (String)this._res.getString("IMPORT_UI_SOURCE_DIR"));
        this._browseButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._browseButton, (String)this._res.getString("IMPORT_UI_BROWSE"));
        this._commentsUI = new VCSCommentsCustomizer();
        this._commentsUI.setShowReuseCommentsOption(false);
        this._commentsUI.setSuppressContextMenu(false);
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this._hint, this.gbc(0, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 15, 0), 0, 0));
        this.add(this._sourceLabel, this.gbc(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add((Component)this._sourceField, this.gbc(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.add(this._browseButton, this.gbc(1, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this._commentsUI.getComponent(), this.gbc(0, 3, 2, 1, 1.0, 1.0, 17, 1, new Insets(20, 0, 0, 0), 0, 0));
    }

    private void initListeners() {
        this._browseButton.addActionListener(this);
    }

    public SourcePanel() {
        this.$init$();
    }
}

