/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.util.FastStringBuffer;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorAPI;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNNavURLFileSystemHelper
extends URLFileSystemHelper {
    private static final String SVN_NAV_PROTOCOL = "ide.scm.svn.nav";

    public static URL toNavigatorUrl(SVNUrl svnUrl) {
        FastStringBuffer buff = new FastStringBuffer(100);
        buff.append(SVN_NAV_PROTOCOL).append("://");
        String hostname = svnUrl.getHost();
        if (hostname != null && !hostname.equals("")) {
            buff.append(hostname);
            int port = svnUrl.getPort();
            if (port > 0) {
                buff.append(':').append(String.valueOf(port));
            }
        }
        buff.append('/');
        String[] segments = svnUrl.getPathSegments();
        if (segments != null && segments.length > 0) {
            int i = 0;
            while (i < segments.length) {
                buff.append(segments[i]);
                if (i + 1 < segments.length) {
                    buff.append('/');
                }
                ++i;
            }
        }
        buff.append('#').append(svnUrl.getProtocol());
        try {
            URL uRL = new URL(buff.toString());
            return uRL;
        }
        catch (MalformedURLException mfue) {
            mfue.printStackTrace();
            URL uRL = null;
            return uRL;
        }
    }

    public static SVNUrl toSVNUrl(URL navUrl) throws MalformedURLException {
        String path;
        if (navUrl == null || !SVN_NAV_PROTOCOL.equals(navUrl.getProtocol())) {
            return null;
        }
        FastStringBuffer buff = new FastStringBuffer(100);
        buff.append(navUrl.getRef()).append("://");
        String hostname = navUrl.getHost();
        if (hostname != null && !hostname.equals("")) {
            buff.append(hostname);
            int port = navUrl.getPort();
            if (port > 0) {
                buff.append(':').append(String.valueOf(port));
            }
        }
        if (!(path = navUrl.getPath()).startsWith("/")) {
            buff.append('/');
        }
        buff.append(navUrl.getPath());
        return new SVNUrl(buff.toString());
    }

    public boolean canWrite(URL url) {
        return false;
    }

    public boolean isReadOnly(URL url) {
        return true;
    }

    public boolean exists(URL url) {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream openInputStream(URL url) throws IOException {
        SVNUrl svnUrl = SVNNavURLFileSystemHelper.toSVNUrl(url);
        try {
            ISVNClientAdapter client = SVNUtil.getClientAdapter(SVNRepositoryNavigatorAPI.CLIENT_CONTEXT);
            SVNClientInteraction.getInstance().beginInteraction(client, SVNUtil.resolveRepository(svnUrl));
            InputStream inputStream = client.getContent(svnUrl, SVNRevision.HEAD);
            return inputStream;
        }
        catch (SVNClientException ce) {
            throw new IOException(ce.getMessage());
        }
        finally {
            SVNClientInteraction.getInstance().endInteraction();
        }
    }
}

