/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav;

import java.awt.Component;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Node;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoriesNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.svn.nav.cmd.EditConnectionCommand;
import oracle.jdevimpl.vcs.svn.nav.cmd.NewConnectionCommand;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;

public final class SVNNavigatorContextMenu
implements ContextMenuListener {
    public void menuWillShow(ContextMenu popup) {
        Node node;
        Context context = popup.getContext();
        Node node2 = node = context != null ? context.getNode() : null;
        if (node instanceof SVNRepositoriesNode) {
            this.addMenuItem(popup, Ide.findCmdID((String)"oracle.jdeveloper.subversion.new-connection"), 1.0f, 1.0f);
            this.addMenuItem(popup, Ide.findCmdID((String)"oracle.jdeveloper.subversion.export-connections"), MenuConstants.SECTION_ADDITIONAL_CTXT_MENU, 1.0f);
            this.addMenuItem(popup, Ide.findCmdID((String)"oracle.jdeveloper.subversion.import-connections"), MenuConstants.SECTION_ADDITIONAL_CTXT_MENU, 2.0f);
            return;
        }
        SVNRemoteNode remoteNode = SVNUtil.getSVNRemoteNode(context);
        if (remoteNode == null) {
            return;
        }
        if (node instanceof SVNRepositoryNode) {
            this.addMenuItem(popup, 56, MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU, MenuConstants.WEIGHT_EDIT_PROPERTIES);
        } else {
            this.addMenuItem(popup, Ide.findCmdID((String)"oracle.jdeveloper.subversion.branch"), MenuConstants.SECTION_EDIT_CTXT_MENU, MenuConstants.WEIGHT_EDIT_COPY_PATH + 1.0f);
        }
        this.addMenuItem(popup, 20, 1.0f, MenuConstants.WEIGHT_FILE_ERASE);
        if (remoteNode.getNodeKind() == SVNNodeKind.DIR) {
            this.addMenuItem(popup, Ide.findCmdID((String)"oracle.jdeveloper.subversion.checkout"), MenuConstants.SECTION_EDIT_CTXT_MENU, MenuConstants.WEIGHT_EDIT_COPY);
            this.addMenuItem(popup, Ide.findCmdID((String)"oracle.jdeveloper.subversion.new-remote-directory"), 1.0f, 2.0f);
        }
        this.addMenuItem(popup, Ide.findCmdID((String)"oracle.jdeveloper.subversion.copy-svnurl"), MenuConstants.SECTION_EDIT_CTXT_MENU, MenuConstants.WEIGHT_EDIT_COPY_PATH);
    }

    public void menuWillHide(ContextMenu popup) {
    }

    public boolean handleDefaultAction(Context ctx) {
        Node node;
        Node node2 = node = ctx != null ? ctx.getNode() : null;
        if (node != null && node instanceof SVNRepositoriesNode) {
            try {
                NewConnectionCommand command = new NewConnectionCommand();
                command.setContext(ctx);
                CommandProcessor.getInstance().invoke((Command)command);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        if (node != null && node instanceof SVNRepositoryNode) {
            try {
                EditConnectionCommand command = new EditConnectionCommand();
                command.setContext(ctx);
                CommandProcessor.getInstance().invoke((Command)command);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private void addMenuItem(ContextMenu popup, int commandId, float section, float weight) {
        popup.add((Component)this.createMenuItem(popup, commandId, weight), section);
    }

    private JMenuItem createMenuItem(ContextMenu popup, int commandId, float weight) {
        return popup.createMenuItem((ToggleAction)IdeAction.find((int)commandId), weight);
    }
}

