/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.nav.ConnectionFilter;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteFile;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteFolder;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNRemoteContainer
extends DefaultContainer
implements SVNRemoteNode {
    private static final Logger sLogger = SVNProfile.getQualifiedLogger(SVNRemoteContainer.class.getName());
    protected SVNRemoteContainer _parent;
    private final SVNRepositoryNode _parentRepos;
    private final SVNUrl _svnUrl;
    private final ResourcePicker _res;
    private ConnectionFilter _filter;

    public SVNRemoteContainer(SVNRemoteContainer parent, SVNRepositoryNode parentRepos, SVNUrl url) {
        this._parentRepos = parentRepos;
        this._svnUrl = url;
        this._parent = parent;
        this.setURL(SVNNavURLFileSystemHelper.toNavigatorUrl(url));
        this._res = ResourcePicker.getPicker(SVNProfile.class);
    }

    void setFilter(ConnectionFilter filter) {
        this._filter = filter;
    }

    public SVNRepositoryNode getParentRepository() {
        return this._parentRepos;
    }

    public SVNUrl getSVNUrl() {
        return this._svnUrl;
    }

    public SVNNodeKind getNodeKind() {
        return SVNNodeKind.DIR;
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Object getData() {
        return this.getSVNUrl();
    }

    void requestCollapse() {
        UpdateMessage.fireObjectClosed((Subject)this);
        SwingUtilities.invokeLater(new 1());
    }

    protected void postCloseImpl() {
        System.out.println("SVNRemoteContainer postCloseImpl ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openImpl() throws IOException {
        ArrayList arrayList = this._children;
        synchronized (arrayList) {
            this._children.clear();
            this.openContainer();
        }
    }

    private void openContainer() {
        try {
            try {
                ISVNClientAdapter svnClient = SVNUtil.getIDEClientAdapter();
                SVNRepositoryInfo repoInfo = SVNRepositoryManager.getInstance().get(this._svnUrl.toString());
                SVNClientInteraction.getInstance().beginInteraction(svnClient, repoInfo);
                ISVNDirEntry[] entries = svnClient.getList(this.getSVNUrl(), SVNRevision.HEAD, false);
                int i = 0;
                while (i < entries.length) {
                    SVNUrl childUrl = this.getSVNUrl().appendPath(entries[i].getPath());
                    if (entries[i].getNodeKind().equals((Object)SVNNodeKind.DIR)) {
                        StringBuilder path = new StringBuilder();
                        String[] stringArray = childUrl.getPathSegments();
                        int n = 0;
                        while (n < stringArray.length) {
                            String segment = stringArray[n];
                            path.append('/');
                            path.append(segment);
                            ++n;
                        }
                        if (this._filter == null || this._filter.accept(path.toString())) {
                            this._children.add(new SVNRemoteFolder(this, this.getParentRepository(), childUrl));
                        }
                    } else if (entries[i].getNodeKind().equals((Object)SVNNodeKind.FILE)) {
                        this._children.add(new SVNRemoteFile(this, this.getParentRepository(), childUrl, (SVNRevision)entries[i].getLastChangedRevision()));
                    } else {
                        sLogger.fine("browsed unknown node type: " + childUrl.toString() + ", " + entries[i].getNodeKind().toString());
                    }
                    ++i;
                }
                for (Object o : this._children) {
                    if (!(o instanceof SVNRemoteContainer)) continue;
                    ((SVNRemoteContainer)o).setFilter(this._filter);
                }
            }
            catch (SVNClientException ce) {
                this.cleanup((Exception)((Object)ce));
            }
        }
        finally {
            SVNClientInteraction.getInstance().endInteraction();
        }
    }

    private void cleanup(Exception e) {
        sLogger.log(Level.WARNING, "unable to list children of " + this.getSVNUrl().toString(), e);
        SVNRepositoryNode reposNode = this.getParentRepository();
        this.requestCollapse();
        if (reposNode != this) {
            reposNode.requestCollapse();
        }
        ExceptionDialog.showExceptionDialog((Component)VCSWindowUtils.getCurrentWindow(), (Throwable)e, (String)this._res.getString("ACTION_OPEN_REPOS_ERROR_TITLE"), (String)this._res.getString("ACTION_OPEN_REPOS_ERROR_MESSAGE_DIR"), null);
        if (!SVNClientInteraction.getInstance().isClientInUse()) {
            SVNClientInteraction.getInstance().endInteraction();
        }
    }

    public SVNRemoteContainer getParent() {
        return this._parent;
    }

    static void mav$setOpen(SVNRemoteContainer sVNRemoteContainer, boolean bl) {
        sVNRemoteContainer.setOpen(bl);
    }

    final class 1
    implements Runnable {
        public void run() {
            SVNRemoteContainer.mav$setOpen(SVNRemoteContainer.this, false);
        }
    }
}

