/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav;

import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.net.URLFileSystem;
import oracle.jdeveloper.vcs.util.VCSStreamUtils;
import oracle.jdevimpl.vcs.svn.nav.SVNNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteContainer;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.util.browser.DefaultBrowsable;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class SVNRemoteFile
extends DefaultBrowsable
implements SVNRemoteNode {
    private final SVNRepositoryNode _parentRepos;
    private SVNRemoteContainer _parent;
    private final SVNUrl _svnUrl;
    private SVNRevision _revision;

    public SVNRemoteFile(SVNRemoteContainer parent, SVNRepositoryNode parentRepos, SVNUrl svnUrl, SVNRevision revision) {
        this._parentRepos = parentRepos;
        this._svnUrl = svnUrl;
        this.setURL(SVNNavURLFileSystemHelper.toNavigatorUrl(svnUrl));
        this._revision = revision;
        this._parent = parent;
    }

    public SVNRemoteContainer getParent() {
        return this._parent;
    }

    public SVNRepositoryNode getParentRepository() {
        return this._parentRepos;
    }

    public SVNUrl getSVNUrl() {
        return this._svnUrl;
    }

    public SVNNodeKind getNodeKind() {
        return SVNNodeKind.FILE;
    }

    public String getToolTipText() {
        return this._svnUrl.toString();
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getShortLabel() {
        StringBuffer labelBuffer = new StringBuffer(super.getShortLabel());
        labelBuffer.append(' ');
        labelBuffer.append('[');
        labelBuffer.append(this.getRevision());
        labelBuffer.append(']');
        return labelBuffer.toString();
    }

    private String getRevision() {
        return this._revision.toString();
    }

    public Object getData() {
        return this.getSVNUrl();
    }

    public void writeFileContents(OutputStream outputStream) throws IOException {
        EventQueue.invokeLater(new 1());
        try {
            VCSStreamUtils.pipeStreamData((InputStream)URLFileSystem.openInputStream((URL)this.getURL()), (OutputStream)outputStream);
        }
        finally {
            EventQueue.invokeLater(new 2());
        }
    }

    final class 1
    implements Runnable {
        public void run() {
            Ide.getWaitCursor().show(1000);
        }
    }

    final class 2
    implements Runnable {
        public void run() {
            Ide.getWaitCursor().hide();
        }
    }
}

