/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav;

import java.awt.Component;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import oracle.ide.Context;
import oracle.ide.explorer.Explorer;
import oracle.ide.model.Node;
import oracle.ide.model.Observer;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.FastStringBuffer;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNAuthInfo;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SVNRepositoryExplorer
extends Explorer
implements Observer {
    private final ResourcePicker _res;
    private JScrollPane _scrollPane;
    private JTree _tree;
    private Node _node;
    private boolean _observing;

    private void $init$() {
        this._res = ResourcePicker.getPicker(SVNProfile.class);
    }

    public SVNRepositoryExplorer() {
        this.$init$();
    }

    public Component getGUI() {
        if (this._tree == null) {
            this._tree = new JTree();
            this._tree.setRootVisible(false);
            this._tree.setShowsRootHandles(true);
            this._tree.setCellRenderer(new ExplorerCellRenderer(null));
            ToolTipManager.sharedInstance().registerComponent(this._tree);
            this._scrollPane = new JScrollPane(this._tree);
            this._scrollPane.setBorder(BorderFactory.createEmptyBorder());
        }
        return this._scrollPane;
    }

    public void setContext(Context context) {
        Node n = context.getNode();
        if (n != null && n.getData() instanceof SVNRepositoryInfo) {
            this._node = n;
            this._tree = null;
        }
    }

    public Context getContext(EventObject eventObject) {
        return this._node != null ? Context.newIdeContext((Node)this._node) : Context.newIdeContext();
    }

    public void stateChanged(int state) {
        switch (state) {
            case 0: {
                this.loadTree();
                this.beginObservation();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.endObservation();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void update(Object object, UpdateMessage updateMessage) {
        int id;
        if (this._observing && this._node != null && object == this._node && ((id = updateMessage.getMessageID()) == UpdateMessage.STRUCTURE_CHANGED || id == UpdateMessage.OBJECT_RELOADED)) {
            this.loadTree();
        }
    }

    private void beginObservation() {
        if (!this._observing && this._node != null) {
            this._node.attach((Observer)this);
            this._observing = true;
        }
    }

    private void endObservation() {
        if (this._observing && this._node != null) {
            this._node.detach((Observer)this);
            this._observing = false;
        }
    }

    private void loadTree() {
        if (this._tree == null) {
            return;
        }
        DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
        model.setRoot(this.createTreeNodes());
        model.reload();
        int i = 0;
        while (i < this._tree.getRowCount()) {
            this._tree.expandRow(i);
            ++i;
        }
    }

    private DefaultMutableTreeNode createTreeNodes() {
        SVNRepositoryInfo reposInfo = this._node != null ? (SVNRepositoryInfo)this._node.getData() : null;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        if (reposInfo != null) {
            String user;
            String host;
            SVNUrl url;
            String protocol;
            String name = reposInfo.getAlias();
            if (name != null && name.length() > 0) {
                root.add(new DefaultMutableTreeNode(this._res.getString("NAV_REPOS_EXPLORER_NAME", new Object[]{name})));
            }
            if ((protocol = (url = reposInfo.getURL()).getProtocol()) != null) {
                root.add(new DefaultMutableTreeNode(this._res.getString("NAV_REPOS_EXPLORER_PROTOCOL", new Object[]{protocol})));
            }
            if ((host = url.getHost()) == null || host.trim().equals("")) {
                host = "localhost";
            }
            root.add(new DefaultMutableTreeNode(this._res.getString("NAV_REPOS_EXPLORER_HOST", new Object[]{host})));
            int port = url.getPort();
            if (port > 0) {
                root.add(new DefaultMutableTreeNode(this._res.getString("NAV_REPOS_EXPLORER_PORT", new Object[]{String.valueOf(port)})));
            }
            String resource = this.getResource(url);
            root.add(new DefaultMutableTreeNode(this._res.getString("NAV_REPOS_EXPLORER_RESOURCE", new Object[]{resource})));
            SVNAuthInfo authInfo = reposInfo.getAuthInfo();
            String string = user = authInfo != null ? authInfo.getUserName() : null;
            if (user != null && user.length() > 0) {
                root.add(new DefaultMutableTreeNode(this._res.getString("NAV_REPOS_EXPLORER_USER", new Object[]{user})));
            }
        }
        return root;
    }

    private String getResource(SVNUrl url) {
        String[] segs = url.getPathSegments();
        FastStringBuffer buff = new FastStringBuffer(segs.length * 10);
        int i = 0;
        while (i < segs.length) {
            buff.append(segs[i]);
            if (i + 1 < segs.length) {
                buff.append('/');
            }
            ++i;
        }
        String res = buff.toString();
        if (!res.startsWith("/")) {
            res = "/" + res;
        }
        return res;
    }

    static ResourcePicker ra$_res(SVNRepositoryExplorer sVNRepositoryExplorer) {
        return sVNRepositoryExplorer._res;
    }

    private final class ExplorerCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (value instanceof DefaultMutableTreeNode) {
                this.setIcon(SVNRepositoryExplorer.ra$_res(SVNRepositoryExplorer.this).getImage("NAV_REPOS_EXPLORER_NODE_ICON"));
            }
            return this;
        }

        private ExplorerCellRenderer() {
        }

        ExplorerCellRenderer(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

