/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Observable;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.wizard.Wizard;
import oracle.ide.wizard.WizardManager;
import oracle.jdeveloper.vcs.nav.BaseConnectionProvider;
import oracle.jdeveloper.vcs.nav.ConnectionFilter;
import oracle.jdeveloper.vcs.nav.ConnectionListFilterNode;
import oracle.jdeveloper.vcs.nav.ConnectionNode;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoriesFilterNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoriesObservable;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorAPI;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorManager;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryWizard;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SVNRepositoryNavigatorProvider
extends BaseConnectionProvider {
    public Node getConnectionListNode() {
        return SVNRepositoryNavigatorManager.getInstance().getRepositoriesNode();
    }

    public String getALMTeamSourceControlType() {
        return "SVN";
    }

    protected Collection<ConnectionNode> getConnectionNodes() {
        ArrayList<ConnectionNode> connectionNodes = new ArrayList<ConnectionNode>();
        for (Object o : SVNRepositoryManager.getInstance().list()) {
            SVNUrl url = ((SVNRepositoryInfo)o).getURL();
            connectionNodes.add(SVNRepositoryNavigatorAPI.getInstance().getRepositoryNode(url));
        }
        return connectionNodes;
    }

    protected boolean createConnection(Map<String, String> criteria, Context context) {
        StringBuilder url = new StringBuilder();
        url.append(criteria.get("protocol"));
        url.append("://");
        if (criteria.get("server") != null) {
            url.append(criteria.get("server"));
        }
        url.append(criteria.get("path"));
        context.setProperty("PRESET_REPO_URL", (Object)url.toString());
        Wizard connectionWizard = WizardManager.getInstance().getWizard(SVNRepositoryWizard.class);
        return connectionWizard.invoke(context);
    }

    protected ConnectionListFilterNode createConnectionListFilterNode() {
        return new SVNRepositoriesFilterNode();
    }

    protected Element createConnectionFilterNode(ConnectionNode connectionNode, ConnectionFilter filter) {
        SVNRepositoryNode connectionFilterNode = new SVNRepositoryNode((SVNRepositoryInfo)connectionNode.getData());
        connectionFilterNode.setFilter(filter);
        return connectionFilterNode;
    }

    public Observable getConnectionObservable() {
        return SVNRepositoriesObservable.getObservable();
    }

    SVNRepositoryNavigatorProvider() {
    }
}

