/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.net.MalformedURLException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import oracle.bali.ewt.dialog.DialogHeader;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.wizard.Wizard;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.AlreadyExistsException;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNavigatorAPI;
import oracle.jdevimpl.vcs.svn.nav.SVNRepositoryNode;
import oracle.jdevimpl.vcs.svn.nav.ui.ConnectionPanel;
import oracle.jdevimpl.vcs.svn.repos.SVNRepositoryManager;

public final class SVNRepositoryWizard
extends Wizard {
    public static final String PROPERTY_NAME_EDITING = SVNRepositoryWizard.class.getName() + ".editing";
    public static final String PRESET_REPO_URL = "PRESET_REPO_URL";
    private final ResourcePicker _res = ResourcePicker.getPicker(SVNProfile.class);

    public boolean isAvailable(Context context) {
        return true;
    }

    public boolean invoke(Context context) {
        ConnectionPanel panel = new ConnectionPanel();
        boolean editing = this.isEditing(context);
        JEWTDialog dialog = this.createDialog(panel, editing);
        WaitCursor wc = new WaitCursor((Component)panel);
        panel.addListener(new 1(this, dialog, wc));
        dialog.addWindowListener((WindowListener)new 2(this, panel));
        if (editing) {
            SVNRepositoryNode reposNode = (SVNRepositoryNode)context.getNode();
            panel.setRepositoryInfo((SVNRepositoryInfo)reposNode.getData());
            dialog.addVetoableChangeListener((VetoableChangeListener)new EditNodeCommitter(dialog, panel, reposNode, null));
        } else {
            panel.setRepositoryInfo(null);
            dialog.addVetoableChangeListener((VetoableChangeListener)new NewNodeCommitter(dialog, panel, null));
        }
        if (context.getProperty(PRESET_REPO_URL) != null) {
            panel.setURL((String)context.getProperty(PRESET_REPO_URL));
        }
        return WizardLauncher.runDialog((JDialog)dialog);
    }

    public String getShortLabel() {
        return this._res.getString("NAV_CONNECTION_WIZARD_LABEL");
    }

    public String getLongLabel() {
        return this._res.getString("NAV_CONNECTION_WIZARD_DESCRIPTION");
    }

    public Icon getIcon() {
        return this._res.getImage("NAV_CONNECTION_WIZARD_ICON");
    }

    private boolean isEditing(Context ctx) {
        Boolean editing = (Boolean)ctx.getProperty(PROPERTY_NAME_EDITING);
        if (editing == null) {
            editing = Boolean.FALSE;
        }
        return ctx.getNode() instanceof SVNRepositoryNode && editing != false;
    }

    private JEWTDialog createDialog(JComponent content, boolean editMode) {
        JEWTDialog dialog = new JEWTDialog((Frame)Ide.getMainWindow(), editMode ? this._res.getString("NAV_CONNECTION_WIZARD_DIALOG_TITLE_EDIT") : this._res.getString("NAV_CONNECTION_WIZARD_DIALOG_TITLE_CREATE"), 7);
        dialog.setDefaultButton(1);
        dialog.setContent((Component)content);
        DialogHeader header = new DialogHeader();
        header.setHeaderDescription(this._res.getString("NAV_CONNECTION_WIZARD_DIALOG_HEADER_DESC"));
        dialog.setDialogHeader((Component)header);
        HelpSystem.getHelpSystem().registerTopic(content, editMode ? "f1_svneditsvnconnection_html" : "f1_svncreatesvnconnection_html");
        return dialog;
    }

    static ResourcePicker ra$_res(SVNRepositoryWizard sVNRepositoryWizard) {
        return sVNRepositoryWizard._res;
    }

    final class oracle.jdevimpl.vcs.svn.nav.SVNRepositoryWizard$1
    implements ConnectionPanel.Listener {
        private final /* synthetic */ JEWTDialog v$dialog;
        private final /* synthetic */ WaitCursor v$wc;
        final /* synthetic */ SVNRepositoryWizard this$0;

        public void setContainsURL(boolean containsUrl) {
            this.v$dialog.setOKButtonEnabled(containsUrl);
        }

        public void testHasBegun() {
            this.v$dialog.setOKButtonEnabled(false);
            EventQueue.invokeLater(new 1());
        }

        public void testHasFinished() {
            this.v$dialog.setOKButtonEnabled(true);
            EventQueue.invokeLater(new 2());
        }

        public oracle.jdevimpl.vcs.svn.nav.SVNRepositoryWizard$1(SVNRepositoryWizard sVNRepositoryWizard, JEWTDialog jEWTDialog, WaitCursor waitCursor) {
            this.v$wc = waitCursor;
            this.v$dialog = jEWTDialog;
            this.this$0 = sVNRepositoryWizard;
        }

        static WaitCursor ra$v$wc(oracle.jdevimpl.vcs.svn.nav.SVNRepositoryWizard$1 var0) {
            return var0.v$wc;
        }

        final class 1
        implements Runnable {
            public void run() {
                oracle.jdevimpl.vcs.svn.nav.SVNRepositoryWizard$1.ra$v$wc(1.this).show();
            }
        }

        final class 2
        implements Runnable {
            public void run() {
                oracle.jdevimpl.vcs.svn.nav.SVNRepositoryWizard$1.ra$v$wc(1.this).hide();
                oracle.jdevimpl.vcs.svn.nav.SVNRepositoryWizard$1.ra$v$wc(1.this).dispose();
            }
        }
    }

    final class 2
    implements WindowListener {
        private final /* synthetic */ ConnectionPanel v$panel;
        final /* synthetic */ SVNRepositoryWizard this$0;

        public void windowDeactivated(WindowEvent e) {
        }

        public void windowActivated(WindowEvent e) {
        }

        public void windowDeiconified(WindowEvent e) {
        }

        public void windowIconified(WindowEvent e) {
        }

        public void windowClosed(WindowEvent e) {
        }

        public void windowClosing(WindowEvent e) {
            this.v$panel.cleanupInteraction();
        }

        public void windowOpened(WindowEvent e) {
        }

        public 2(SVNRepositoryWizard sVNRepositoryWizard, ConnectionPanel connectionPanel) {
            this.v$panel = connectionPanel;
            this.this$0 = sVNRepositoryWizard;
        }
    }

    private abstract class NodeCommitter {
        protected final JEWTDialog _dialog;
        protected final ConnectionPanel _panel;

        NodeCommitter(JEWTDialog dialog, ConnectionPanel panel) {
            this._dialog = dialog;
            this._panel = panel;
        }

        protected void respond(MalformedURLException mfue, PropertyChangeEvent pce) throws PropertyVetoException {
            MessageDialog.error((Component)this._panel, (Object)SVNRepositoryWizard.ra$_res(SVNRepositoryWizard.this).getString("NAV_CONNECTION_WIZARD_COMMIT_BAD_URL"), (String)SVNRepositoryWizard.ra$_res(SVNRepositoryWizard.this).getString("NAV_CONNECTION_WIZARD_COMMIT_ERROR"), null);
            this._dialog.setOKButtonEnabled(false);
            throw new PropertyVetoException(mfue.getMessage(), pce);
        }

        protected void respond(AlreadyExistsException aee, PropertyChangeEvent pce) throws PropertyVetoException {
            MessageDialog.error((Component)this._panel, (Object)SVNRepositoryWizard.ra$_res(SVNRepositoryWizard.this).getString("NAV_CONNECTION_WIZARD_COMMIT_NON_UNIQUE"), (String)SVNRepositoryWizard.ra$_res(SVNRepositoryWizard.this).getString("NAV_CONNECTION_WIZARD_COMMIT_ERROR"), null);
            this._dialog.setOKButtonEnabled(false);
            throw new PropertyVetoException(null, pce);
        }
    }

    private final class NewNodeCommitter
    extends NodeCommitter
    implements VetoableChangeListener {
        private NewNodeCommitter(JEWTDialog dialog, ConnectionPanel panel) {
            super(dialog, panel);
        }

        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                SVNRepositoryManager.getInstance().save();
                SVNRepositoryManager.getInstance().reload();
                return;
            }
            try {
                SVNRepositoryInfo reposInfo = this._panel.createRepositoryInfo();
                SVNRepositoryNavigatorAPI.getInstance().createRepositoryConnection(reposInfo);
            }
            catch (MalformedURLException mfue) {
                this.respond(mfue, pce);
            }
            catch (AlreadyExistsException aee) {
                this.respond(aee, pce);
            }
        }

        NewNodeCommitter(JEWTDialog jEWTDialog, ConnectionPanel connectionPanel, 1 var4_4) {
            this(jEWTDialog, connectionPanel);
        }

        public final class 1 {
        }
    }

    private final class EditNodeCommitter
    extends NodeCommitter
    implements VetoableChangeListener {
        private final SVNRepositoryNode _originalNode;

        private EditNodeCommitter(JEWTDialog dialog, ConnectionPanel panel, SVNRepositoryNode originalNode) {
            super(dialog, panel);
            this._originalNode = originalNode;
        }

        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                SVNRepositoryManager.getInstance().save();
                SVNRepositoryManager.getInstance().reload();
                return;
            }
            try {
                SVNRepositoryInfo reposInfo = this._panel.createRepositoryInfo();
                SVNRepositoryNavigatorAPI.getInstance().removeRepositoryConnection(this._originalNode);
                SVNRepositoryNavigatorAPI.getInstance().createRepositoryConnection(reposInfo);
            }
            catch (MalformedURLException mfue) {
                this.respond(mfue, pce);
            }
            catch (AlreadyExistsException aee) {
                this.respond(aee, pce);
            }
        }

        EditNodeCommitter(JEWTDialog jEWTDialog, ConnectionPanel connectionPanel, SVNRepositoryNode sVNRepositoryNode, 1 var5_5) {
            this(jEWTDialog, connectionPanel, sVNRepositoryNode);
        }

        public final class 1 {
        }
    }
}

