/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav.cmd;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Element;
import oracle.ide.navigator.NavigatorWindow;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.util.ResourcePicker;
import oracle.jdeveloper.vcs.spi.VCSCommentsCustomizer;
import oracle.jdeveloper.vcs.util.VCSWindowUtils;
import oracle.jdevimpl.vcs.svn.SVNExecutorService;
import oracle.jdevimpl.vcs.svn.SVNOperationLogger;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteContainer;
import oracle.jdevimpl.vcs.svn.nav.SVNRemoteNode;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public final class DeleteRemoteResourceCommand
extends Command {
    public static final String COMMAND_ID = "oracle.jdeveloper.subversion.delete-remote-resource";
    private static final ResourcePicker sRes = ResourcePicker.getPicker(SVNProfile.class);

    public DeleteRemoteResourceCommand() {
        super(Ide.findCmdID((String)COMMAND_ID).intValue());
    }

    public int doit() {
        SVNRemoteNode[] nodes = SVNUtil.getSVNRemoteNodes(this.getContext());
        if (nodes == null || nodes.length == 0) {
            return 1;
        }
        int i = 0;
        while (i < nodes.length) {
            if (SVNNodeKind.DIR.equals((Object)nodes[i].getNodeKind())) {
                if (!this.cancelDirectoryDelete()) break;
                return 1;
            }
            ++i;
        }
        DeleteResourcesUI panel = new DeleteResourcesUI(null);
        JEWTDialog dialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)panel, (Component)DeleteResourcesUI.ra$_commentsUI(panel).getInitialFocusComponent(), (String)sRes.getString("ACTION_DELETE_REMOTE_RESOURCE_DIALOG_TITLE"), (int)7);
        dialog.addVetoableChangeListener((VetoableChangeListener)new 1(this, dialog, panel, nodes));
        return WizardLauncher.runDialog((JDialog)dialog) ? 0 : 1;
    }

    private boolean cancelDirectoryDelete() {
        return MessageDialog.optionalConfirm((String)(DeleteRemoteResourceCommand.class.getName() + ".confirmDelete"), (Component)Ide.getMainWindow(), (String)sRes.getString("ACTION_DELETE_REMOTE_RESOURCE_CONF_MSG"), (String)sRes.getString("ACTION_DELETE_REMOTE_RESOURCE_CONF_TITLE"), null) ^ true;
    }

    static ResourcePicker ra$sRes() {
        return sRes;
    }

    static Context ra$context(DeleteRemoteResourceCommand deleteRemoteResourceCommand) {
        return deleteRemoteResourceCommand.context;
    }

    final class 1
    implements VetoableChangeListener {
        private final /* synthetic */ JEWTDialog v$dialog;
        private final /* synthetic */ DeleteResourcesUI v$panel;
        private final /* synthetic */ SVNRemoteNode[] v$nodes;
        final /* synthetic */ DeleteRemoteResourceCommand this$0;

        public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
            if (!JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)pce)) {
                return;
            }
            SVNExecutorService.getInstance().submit(this.this$0.new DeleteResourcesTask(this.v$dialog, this.v$panel, this.v$nodes, null));
            try {
                SVNRemoteContainer parent = this.v$nodes[0].getParent();
                parent.close();
            }
            catch (IOException e) {
                throw new PropertyVetoException(e.getMessage(), pce);
            }
        }

        public 1(DeleteRemoteResourceCommand deleteRemoteResourceCommand, JEWTDialog jEWTDialog, DeleteResourcesUI deleteResourcesUI, SVNRemoteNode[] sVNRemoteNodeArray) {
            this.v$nodes = sVNRemoteNodeArray;
            this.v$panel = deleteResourcesUI;
            this.v$dialog = jEWTDialog;
            this.this$0 = deleteRemoteResourceCommand;
        }
    }

    private final class DeleteResourcesTask
    implements Runnable {
        private final JEWTDialog _dialog;
        private final DeleteResourcesUI _panel;
        private final SVNRemoteNode[] _nodes;

        private DeleteResourcesTask(JEWTDialog dialog, DeleteResourcesUI panel, SVNRemoteNode[] nodes) {
            this._dialog = dialog;
            this._panel = panel;
            this._nodes = nodes;
        }

        public void run() {
            IndeterminateProgressMonitor progress = new IndeterminateProgressMonitor((Component)VCSWindowUtils.getCurrentWindow(), DeleteRemoteResourceCommand.ra$sRes().getString("ACTION_DELETE_REMOTE_RESOURCE_PROGESS_TITLE"), (Object)DeleteRemoteResourceCommand.ra$sRes().getString("ACTION_DELETE_REMOTE_RESOURCE_PROGRESS_MESSAGE"), null);
            progress.setMillisToPopup(500);
            progress.setCloseOnFinish(true);
            progress.setCancellable(false);
            EventQueue.invokeLater(new 1());
            progress.start();
            SVNUrl[] resources = new SVNUrl[this._nodes.length];
            int i = 0;
            while (i < this._nodes.length) {
                resources[i] = this._nodes[i].getSVNUrl();
                ++i;
            }
            NavigatorWindow nav = null;
            TreeExplorer explorer = null;
            TNode rootTNode = null;
            TNode parentT = null;
            try {
                try {
                    ISVNClientAdapter client = SVNUtil.getIDEClientAdapter();
                    SVNOperationLogger.getInstance().beginOperation(client, (SVNRepositoryInfo)this._nodes[0].getParentRepository().getData(), progress);
                    nav = (NavigatorWindow)DeleteRemoteResourceCommand.ra$context(DeleteRemoteResourceCommand.this).getView();
                    explorer = nav.getTreeExplorer();
                    rootTNode = explorer.getRoot();
                    parentT = explorer.searchTNode((Element)this._nodes[0].getParent(), rootTNode);
                    client.remove(resources, DeleteResourcesUI.mav$getComments(this._panel));
                }
                catch (SVNClientException ce) {
                    SwingUtilities.invokeLater(new 2(this, ce));
                }
            }
            finally {
                SVNOperationLogger.getInstance().endOperation();
                explorer.expand(parentT, false);
                progress.finish();
                EventQueue.invokeLater(new 3());
            }
        }

        DeleteResourcesTask(JEWTDialog jEWTDialog, DeleteResourcesUI deleteResourcesUI, SVNRemoteNode[] sVNRemoteNodeArray, oracle.jdevimpl.vcs.svn.nav.cmd.DeleteRemoteResourceCommand$1 var5_5) {
            this(jEWTDialog, deleteResourcesUI, sVNRemoteNodeArray);
        }

        final class 1
        implements Runnable {
            public void run() {
                Ide.getWaitCursor().show();
            }
        }

        final class 2
        implements Runnable {
            private final /* synthetic */ SVNClientException v$ce;
            final /* synthetic */ DeleteResourcesTask this$0;

            public void run() {
                ExceptionDialog.showExceptionDialog((Component)VCSWindowUtils.getCurrentWindow(), (Throwable)this.v$ce, (String)DeleteRemoteResourceCommand.ra$sRes().getString("ACTION_DELETE_REMOTE_RESOURCE_ERROR_TITLE"), (String)this.v$ce.getMessage(), null);
            }

            public 2(DeleteResourcesTask deleteResourcesTask, SVNClientException sVNClientException) {
                this.v$ce = sVNClientException;
                this.this$0 = deleteResourcesTask;
            }
        }

        final class 3
        implements Runnable {
            public void run() {
                Ide.getWaitCursor().hide();
            }
        }
    }

    private final class DeleteResourcesUI
    extends JPanel {
        private final VCSCommentsCustomizer _commentsUI;

        private void $init$() {
            this._commentsUI = new VCSCommentsCustomizer();
        }

        private DeleteResourcesUI() {
            super(new GridBagLayout());
            this.$init$();
            this.createComponents();
            this.layoutComponents();
        }

        private String getComments() {
            return (String)this._commentsUI.getOptions().get("setting_comments");
        }

        private void createComponents() {
            this._commentsUI.setShowReuseCommentsOption(false);
            this._commentsUI.setSuppressContextMenu(true);
        }

        private void layoutComponents() {
            this.add(this._commentsUI.getComponent(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        DeleteResourcesUI(1 var2_2) {
            this();
        }

        static VCSCommentsCustomizer ra$_commentsUI(DeleteResourcesUI deleteResourcesUI) {
            return deleteResourcesUI._commentsUI;
        }

        static String mav$getComments(DeleteResourcesUI deleteResourcesUI) {
            return deleteResourcesUI.getComments();
        }

        public final class 1 {
        }
    }
}

