/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.svn.nav.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ResourcePicker;
import oracle.jdevimpl.vcs.svn.SVNClientInteraction;
import oracle.jdevimpl.vcs.svn.SVNProfile;
import oracle.jdevimpl.vcs.svn.model.SVNAuthInfo;
import oracle.jdevimpl.vcs.svn.model.SVNRepositoryInfo;
import oracle.jdevimpl.vcs.svn.util.ProtocolMatcher;
import oracle.jdevimpl.vcs.svn.util.SVNRepositoryInfoValidator;
import oracle.jdevimpl.vcs.svn.util.SVNUtil;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ConnectionPanel
extends JPanel {
    private final ResourcePicker _res;
    private JLabel _urlLabel;
    private JTextField _urlField;
    private JLabel _nameLabel;
    private JTextField _nameField;
    private JLabel _userNameLabel;
    private JTextField _userNameField;
    private JLabel _passwordLabel;
    private JPasswordField _passwordField;
    private JButton _testButton;
    private JCheckBox _rememberPwdCheckbox;
    private JLabel _statusLabel;
    private JTextArea _statusArea;
    private JScrollPane _scrollPane;
    private final Collection _listeners;
    private final ProtocolMatcher _protocolMatcher;

    private void $init$() {
        this._listeners = new ArrayList(5);
        this._protocolMatcher = new ProtocolMatcher();
    }

    public ConnectionPanel() {
        super(new GridBagLayout());
        this.$init$();
        this._res = ResourcePicker.getPicker(SVNProfile.class);
        this.createComponents();
        this.layoutComponents();
        this.initComponentListeners();
    }

    public void addListener(Listener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this._listeners.remove(listener);
    }

    public void setRepositoryInfo(SVNRepositoryInfo reposInfo) {
        boolean goodUrl = true;
        if (reposInfo == null) {
            goodUrl = false;
            this._nameField.setText("");
            this._userNameField.setText("");
            this._passwordField.setText("");
            this._rememberPwdCheckbox.setSelected(false);
            this._testButton.setEnabled(false);
            this._statusArea.setText("");
        } else {
            this._urlField.setText(reposInfo.getURL().toString());
            this._nameField.setText(reposInfo.getAlias());
            SVNAuthInfo authInfo = reposInfo.getAuthInfo();
            if (authInfo != null) {
                this._userNameField.setText(authInfo.getUserName());
                this._passwordField.setText(authInfo.getPassword());
            }
            this._testButton.setEnabled(true);
            this._statusArea.setText("");
        }
        this.fireContainsUrl(goodUrl);
    }

    public void setURL(String urlString) {
        this._urlField.setText(urlString);
        this.updateBasedOnProtocol();
    }

    public SVNRepositoryInfo createRepositoryInfo() throws MalformedURLException {
        String username = this._userNameField.getText();
        SVNAuthInfo authInfo = username != null ? new SVNAuthInfo(username, new String(this._passwordField.getPassword())) : null;
        return new SVNRepositoryInfo(new SVNUrl(this._urlField.getText().trim()), this._nameField.getText(), authInfo);
    }

    private void createComponents() {
        this._urlLabel = new JLabel();
        this._urlField = new JTextField();
        ResourceUtils.resLabel((JLabel)this._urlLabel, (Component)this._urlField, (String)this._res.getString("NAV_CONNECTION_WIZARD_URL"));
        this._nameLabel = new JLabel();
        this._nameField = new JTextField();
        ResourceUtils.resLabel((JLabel)this._nameLabel, (Component)this._nameField, (String)this._res.getString("NAV_CONNECTION_WIZARD_NAME"));
        this._userNameLabel = new JLabel();
        this._userNameField = new JTextField();
        ResourceUtils.resLabel((JLabel)this._userNameLabel, (Component)this._userNameField, (String)this._res.getString("NAV_CONNECTION_WIZARD_USER"));
        this._passwordLabel = new JLabel();
        this._passwordField = new JPasswordField();
        ResourceUtils.resLabel((JLabel)this._passwordLabel, (Component)this._passwordField, (String)this._res.getString("NAV_CONNECTION_WIZARD_PASSWORD"));
        this._testButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this._testButton, (String)this._res.getString("NAV_CONNECTION_WIZARD_TEST"));
        this._rememberPwdCheckbox = new JCheckBox();
        this._rememberPwdCheckbox.setSelected(false);
        ResourceUtils.resButton((AbstractButton)this._rememberPwdCheckbox, (String)this._res.getString("NAV_CONNECTION_WIZARD_REMEMBER"));
        this._statusLabel = new JLabel();
        this._statusArea = new JTextArea();
        this._statusArea.setEditable(false);
        this._statusArea.setLineWrap(true);
        this._statusArea.setWrapStyleWord(true);
        this._statusArea.setRows(4);
        this._scrollPane = new JScrollPane(this._statusArea);
        ResourceUtils.resLabel((JLabel)this._statusLabel, (Component)this._statusArea, (String)this._res.getString("NAV_CONNECTION_WIZARD_STATUS"));
    }

    private void layoutComponents() {
        Insets lblIns = new Insets(2, 5, 3, 5);
        Insets fldIns = new Insets(0, 5, 5, 5);
        Insets tstIns = new Insets(5, 5, 5, 5);
        this.add((Component)this._urlLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, lblIns, 0, 0));
        this.add((Component)this._urlField, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 2, fldIns, 0, 0));
        this.add((Component)this._nameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, lblIns, 0, 0));
        this.add((Component)this._nameField, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 2, fldIns, 0, 0));
        this.add((Component)this._userNameLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, lblIns, 0, 0));
        this.add((Component)this._userNameField, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 2, fldIns, 0, 0));
        this.add((Component)this._passwordLabel, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, lblIns, 0, 0));
        this.add((Component)this._passwordField, new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 17, 2, fldIns, 0, 0));
        this.add((Component)this._testButton, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, tstIns, 0, 0));
        this.add((Component)this._statusLabel, new GridBagConstraints(0, 9, 1, 1, 0.0, 0.0, 17, 0, tstIns, 0, 0));
        this.add((Component)this._scrollPane, new GridBagConstraints(0, 10, 2, 3, 1.0, 1.0, 17, 1, fldIns, 350, 0));
    }

    private void initComponentListeners() {
        this._urlField.getDocument().addDocumentListener(new LocationDocumentListener(null));
        this._testButton.addActionListener(new ConnectionTester(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireContainsUrl(boolean containsUrl) {
        Collection collection = this._listeners;
        synchronized (collection) {
            Iterator it = this._listeners.iterator();
            while (it.hasNext()) {
                ((Listener)it.next()).setContainsURL(containsUrl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTestHasBegun() {
        Collection collection = this._listeners;
        synchronized (collection) {
            Iterator it = this._listeners.iterator();
            while (it.hasNext()) {
                ((Listener)it.next()).testHasBegun();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTestHasFinished() {
        Collection collection = this._listeners;
        synchronized (collection) {
            Iterator it = this._listeners.iterator();
            while (it.hasNext()) {
                ((Listener)it.next()).testHasFinished();
            }
        }
    }

    public void cleanupInteraction() {
        if (!SVNClientInteraction.getInstance().isClientInUse()) {
            SVNClientInteraction.getInstance().endInteraction();
        }
    }

    private void updateBasedOnProtocol() {
        this._protocolMatcher.setSource(this._urlField.getText());
        boolean goodProtocol = this._protocolMatcher.containsProtocol();
        this._testButton.setEnabled(goodProtocol);
        this.fireContainsUrl(goodProtocol);
    }

    static void mav$updateBasedOnProtocol(ConnectionPanel connectionPanel) {
        connectionPanel.updateBasedOnProtocol();
    }

    static JTextArea ra$_statusArea(ConnectionPanel connectionPanel) {
        return connectionPanel._statusArea;
    }

    static ResourcePicker ra$_res(ConnectionPanel connectionPanel) {
        return connectionPanel._res;
    }

    static JButton ra$_testButton(ConnectionPanel connectionPanel) {
        return connectionPanel._testButton;
    }

    static void mav$fireTestHasBegun(ConnectionPanel connectionPanel) {
        connectionPanel.fireTestHasBegun();
    }

    static JTextField ra$_urlField(ConnectionPanel connectionPanel) {
        return connectionPanel._urlField;
    }

    static void mav$fireContainsUrl(ConnectionPanel connectionPanel, boolean bl) {
        connectionPanel.fireContainsUrl(bl);
    }

    static void mav$fireTestHasFinished(ConnectionPanel connectionPanel) {
        connectionPanel.fireTestHasFinished();
    }

    public static interface Listener {
        public void setContainsURL(boolean var1);

        public void testHasBegun();

        public void testHasFinished();
    }

    private final class LocationDocumentListener
    implements DocumentListener {
        public void insertUpdate(DocumentEvent e) {
            ConnectionPanel.mav$updateBasedOnProtocol(ConnectionPanel.this);
        }

        public void removeUpdate(DocumentEvent e) {
            ConnectionPanel.mav$updateBasedOnProtocol(ConnectionPanel.this);
        }

        public void changedUpdate(DocumentEvent e) {
            ConnectionPanel.mav$updateBasedOnProtocol(ConnectionPanel.this);
        }

        private LocationDocumentListener() {
        }

        LocationDocumentListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class ConnectionTester
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            try {
                SVNRepositoryInfo reposInfo = ConnectionPanel.this.createRepositoryInfo();
                ConnectionPanel.ra$_statusArea(ConnectionPanel.this).setText("");
                ConnectionPanel.ra$_statusArea(ConnectionPanel.this).append(ConnectionPanel.ra$_res(ConnectionPanel.this).formatString(ConnectionPanel.ra$_res(ConnectionPanel.this).getString("NAV_CONNECTION_WIZARD_TEST_TESTING"), new Object[]{reposInfo.getURL()}));
                ConnectionPanel.ra$_statusArea(ConnectionPanel.this).append("\n");
                SVNRepositoryInfoValidator validator = new SVNRepositoryInfoValidator(reposInfo, SVNUtil.getIDEClientAdapter(), new TextAreaNotificationListener(null));
                ConnectionTesterThread t = new ConnectionTesterThread(validator, null);
                ConnectionPanel.ra$_testButton(ConnectionPanel.this).setEnabled(false);
                t.start();
                ConnectionPanel.mav$fireTestHasBegun(ConnectionPanel.this);
            }
            catch (SVNClientException ce) {
                ExceptionDialog.showExceptionDialog((Component)ConnectionPanel.this, (Throwable)ce, (String)ConnectionPanel.ra$_res(ConnectionPanel.this).getString("NAV_CONNECTION_WIZARD_TEST_ERROR"), null, null);
                return;
            }
            catch (MalformedURLException mfue) {
                MessageDialog.error((Component)ConnectionPanel.this, (Object)ConnectionPanel.ra$_res(ConnectionPanel.this).getString("NAV_CONNECTION_WIZARD_TEST_BAD_URL", new Object[]{ConnectionPanel.ra$_urlField(ConnectionPanel.this).getText()}), (String)ConnectionPanel.ra$_res(ConnectionPanel.this).getString("NAV_CONNECTION_WIZARD_TEST_ERROR"), null);
                ConnectionPanel.mav$fireContainsUrl(ConnectionPanel.this, false);
                return;
            }
        }

        private ConnectionTester() {
        }

        ConnectionTester(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private final class ConnectionTesterThread
    extends Thread {
        private final SVNRepositoryInfoValidator _validator;

        private ConnectionTesterThread(SVNRepositoryInfoValidator validator) {
            this._validator = validator;
        }

        public void run() {
            boolean success = this._validator.validate();
            SwingUtilities.invokeLater(new 1(this, success));
        }

        ConnectionTesterThread(SVNRepositoryInfoValidator sVNRepositoryInfoValidator, 1 var3_3) {
            this(sVNRepositoryInfoValidator);
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ boolean v$success;
            final /* synthetic */ ConnectionTesterThread this$0;

            public void run() {
                ConnectionPanel.ra$_statusArea(this.this$0.ConnectionPanel.this).append(this.v$success ? ConnectionPanel.ra$_res(this.this$0.ConnectionPanel.this).getString("NAV_CONNECTION_WIZARD_TEST_SUCCESS") : ConnectionPanel.ra$_res(this.this$0.ConnectionPanel.this).getString("NAV_CONNECTION_WIZARD_TEST_FAILED"));
                ConnectionPanel.ra$_statusArea(this.this$0.ConnectionPanel.this).append("\n");
                ConnectionPanel.ra$_testButton(this.this$0.ConnectionPanel.this).setEnabled(true);
                ConnectionPanel.mav$fireTestHasFinished(this.this$0.ConnectionPanel.this);
            }

            public 1(ConnectionTesterThread connectionTesterThread, boolean bl) {
                this.v$success = bl;
                this.this$0 = connectionTesterThread;
            }
        }
    }

    private final class TextAreaNotificationListener
    implements ISVNNotifyListener {
        public void setCommand(int command) {
        }

        public void logCommandLine(String commandLine) {
        }

        public void logMessage(String message) {
            this.appendLater(message);
        }

        public void logError(String message) {
            this.appendLater(message);
        }

        public void logRevision(long revision) {
        }

        public void logCompleted(String message) {
            this.appendLater(message);
        }

        public void onNotify(File path, SVNNodeKind nodeKind) {
        }

        public void logRevision(long revision, String path) {
        }

        private void appendLater(String message) {
            SwingUtilities.invokeLater(new 1(this, message));
        }

        private TextAreaNotificationListener() {
        }

        TextAreaNotificationListener(1 var2_2) {
            this();
        }

        final class 1
        implements Runnable {
            private final /* synthetic */ String v$message;
            final /* synthetic */ TextAreaNotificationListener this$0;

            public void run() {
                ConnectionPanel.ra$_statusArea(this.this$0.ConnectionPanel.this).append(this.v$message);
                ConnectionPanel.ra$_statusArea(this.this$0.ConnectionPanel.this).append("\n");
            }

            public 1(TextAreaNotificationListener textAreaNotificationListener, String string) {
                this.v$message = string;
                this.this$0 = textAreaNotificationListener;
            }
        }
    }
}

